/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.text;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.util.SparseArray;
import com.google.android.gms.internal.fc;
import com.google.android.gms.internal.fk;
import com.google.android.gms.internal.fm;
import com.google.android.gms.internal.fq;
import com.google.android.gms.internal.fr;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.text.TextBlock;
import com.google.android.gms.vision.text.zzb;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public final class TextRecognizer
extends Detector<TextBlock> {
    private final fq zzbNU;

    private TextRecognizer() {
        throw new IllegalStateException("Default constructor called");
    }

    private TextRecognizer(fq fq2) {
        this.zzbNU = fq2;
    }

    public final SparseArray<TextBlock> detect(Frame frame) {
        ByteBuffer byteBuffer;
        int n;
        int n2;
        Object object;
        Bitmap bitmap;
        fm fm2 = new fm(new Rect());
        Frame frame2 = frame;
        TextRecognizer textRecognizer = this;
        if (frame2 == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        fc fc2 = fc.zzc((Frame)frame2);
        if (frame2.getBitmap() != null) {
            bitmap = frame2.getBitmap();
        } else {
            byte[] byArray;
            object = frame2.getMetadata();
            int n3 = fc2.height;
            n2 = fc2.width;
            n = object.getFormat();
            byteBuffer = frame2.getGrayscaleImageData();
            if (byteBuffer.hasArray() && byteBuffer.arrayOffset() == 0) {
                byArray = byteBuffer.array();
            } else {
                byArray = new byte[byteBuffer.capacity()];
                byteBuffer.get(byArray);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            new YuvImage(byArray, n, n2, n3, null).compressToJpeg(new Rect(0, 0, n2, n3), 100, (OutputStream)byteArrayOutputStream);
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            bitmap = BitmapFactory.decodeByteArray((byte[])byArray2, (int)0, (int)byArray2.length);
        }
        fc fc3 = fc2;
        Bitmap bitmap2 = bitmap;
        int n4 = bitmap2.getWidth();
        int n5 = bitmap2.getHeight();
        if (fc3.rotation != 0) {
            int n6;
            Matrix matrix = new Matrix();
            switch (fc3.rotation) {
                case 0: {
                    n6 = 0;
                    break;
                }
                case 1: {
                    n6 = 90;
                    break;
                }
                case 2: {
                    n6 = 180;
                    break;
                }
                case 3: {
                    n6 = 270;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported rotation degree.");
                }
            }
            matrix.postRotate((float)n6);
            bitmap2 = Bitmap.createBitmap((Bitmap)bitmap2, (int)0, (int)0, (int)n4, (int)n5, (Matrix)matrix, (boolean)false);
        }
        if (fc3.rotation == 1 || fc3.rotation == 3) {
            fc3.width = n5;
            fc3.height = n4;
        }
        bitmap = bitmap2;
        if (!fm2.zzbOh.isEmpty()) {
            ByteBuffer byteBuffer2;
            fc fc4 = fc2;
            n2 = frame2.getMetadata().getHeight();
            n = frame2.getMetadata().getWidth();
            byteBuffer = fm2.zzbOh;
            switch (fc4.rotation) {
                case 1: {
                    byteBuffer2 = new Rect(n2 - ((Rect)byteBuffer).bottom, ((Rect)byteBuffer).left, n2 - ((Rect)byteBuffer).top, ((Rect)byteBuffer).right);
                    break;
                }
                case 2: {
                    byteBuffer2 = new Rect(n - ((Rect)byteBuffer).right, n2 - ((Rect)byteBuffer).bottom, n - ((Rect)byteBuffer).left, n2 - ((Rect)byteBuffer).top);
                    break;
                }
                case 3: {
                    byteBuffer2 = new Rect(((Rect)byteBuffer).top, n - ((Rect)byteBuffer).right, ((Rect)byteBuffer).bottom, n - ((Rect)byteBuffer).left);
                    break;
                }
                default: {
                    byteBuffer2 = byteBuffer;
                }
            }
            object = byteBuffer2;
            fm2.zzbOh.set((Rect)object);
        }
        fc2.rotation = 0;
        return TextRecognizer.zza(textRecognizer.zzbNU.zza(bitmap, fc2, fm2));
    }

    private static SparseArray<TextBlock> zza(fk[] sparseArray) {
        SparseArray sparseArray2 = new SparseArray();
        for (fk fk2 : sparseArray) {
            SparseArray sparseArray3 = (SparseArray)sparseArray2.get(fk2.zzbOf);
            if (sparseArray3 == null) {
                sparseArray3 = new SparseArray();
                sparseArray2.append(fk2.zzbOf, (Object)sparseArray3);
            }
            sparseArray3.append(fk2.zzbOg, (Object)fk2);
        }
        SparseArray sparseArray4 = new SparseArray(sparseArray2.size());
        for (int i = 0; i < sparseArray2.size(); ++i) {
            sparseArray4.append(sparseArray2.keyAt(i), (Object)new TextBlock((SparseArray<fk>)((SparseArray)sparseArray2.valueAt(i))));
        }
        return sparseArray4;
    }

    public final boolean isOperational() {
        return this.zzbNU.isOperational();
    }

    public final void release() {
        super.release();
        this.zzbNU.zzDQ();
    }

    /* synthetic */ TextRecognizer(fq fq2, zzb zzb2) {
        this(fq2);
    }

    public static class Builder {
        private Context mContext;
        private fr zzbNV;

        public Builder(Context context) {
            this.mContext = context;
            this.zzbNV = new fr();
        }

        public TextRecognizer build() {
            fq fq2 = new fq(this.mContext, this.zzbNV);
            return new TextRecognizer(fq2, null);
        }
    }
}

