/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.barcode;

import android.content.Context;
import android.util.SparseArray;
import com.google.android.gms.internal.eu;
import com.google.android.gms.internal.ew;
import com.google.android.gms.internal.fc;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.barcode.Barcode;
import com.google.android.gms.vision.barcode.zzc;
import java.nio.ByteBuffer;

public final class BarcodeDetector
extends Detector<Barcode> {
    private final ew zzbNg;

    private BarcodeDetector() {
        throw new IllegalStateException("Default constructor called");
    }

    private BarcodeDetector(ew ew2) {
        this.zzbNg = ew2;
    }

    public final void release() {
        super.release();
        this.zzbNg.zzDQ();
    }

    public final SparseArray<Barcode> detect(Frame frame) {
        ByteBuffer byteBuffer;
        Barcode[] barcodeArray;
        if (frame == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        fc fc2 = fc.zzc((Frame)frame);
        if (frame.getBitmap() != null) {
            barcodeArray = this.zzbNg.zza(frame.getBitmap(), fc2);
            if (barcodeArray == null) {
                throw new IllegalArgumentException("Internal barcode detector error; check logcat output.");
            }
        } else {
            byteBuffer = frame.getGrayscaleImageData();
            barcodeArray = this.zzbNg.zza(byteBuffer, fc2);
        }
        byteBuffer = new SparseArray(barcodeArray.length);
        Barcode[] barcodeArray2 = barcodeArray;
        int n = barcodeArray.length;
        for (int i = 0; i < n; ++i) {
            Barcode barcode = barcodeArray2[i];
            byteBuffer.append(barcode.rawValue.hashCode(), (Object)barcode);
        }
        return byteBuffer;
    }

    public final boolean isOperational() {
        return this.zzbNg.isOperational();
    }

    /* synthetic */ BarcodeDetector(ew ew2, zzc zzc2) {
        this(ew2);
    }

    public static class Builder {
        private Context mContext;
        private eu zzbNh;

        public Builder(Context context) {
            this.mContext = context;
            this.zzbNh = new eu();
        }

        public Builder setBarcodeFormats(int n) {
            this.zzbNh.zzbNi = n;
            return this;
        }

        public BarcodeDetector build() {
            ew ew2 = new ew(this.mContext, this.zzbNh);
            return new BarcodeDetector(ew2, null);
        }
    }
}

