/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.face.internal.client;

import android.content.Context;
import android.graphics.PointF;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.zzdit;
import com.google.android.gms.internal.zzdiu;
import com.google.android.gms.vision.face.Face;
import com.google.android.gms.vision.face.Landmark;
import com.google.android.gms.vision.face.internal.client.FaceParcel;
import com.google.android.gms.vision.face.internal.client.LandmarkParcel;
import com.google.android.gms.vision.face.internal.client.zzc;
import com.google.android.gms.vision.face.internal.client.zze;
import com.google.android.gms.vision.face.internal.client.zzg;
import com.google.android.gms.vision.face.internal.client.zzh;
import java.nio.ByteBuffer;

public final class zza
extends zzdit<zze> {
    private final zzc zzkuw;

    public zza(Context context, zzc zzc2) {
        super(context, "FaceNativeHandle");
        this.zzkuw = zzc2;
        this.zzbjk();
    }

    public final Face[] zzb(ByteBuffer byteBuffer, zzdiu zzdiu2) {
        FaceParcel[] faceParcelArray;
        Face[] faceArray;
        if (!this.isOperational()) {
            return new Face[0];
        }
        try {
            faceArray = zzn.zzy((Object)byteBuffer);
            faceParcelArray = ((zze)this.zzbjk()).zzc((IObjectWrapper)faceArray, zzdiu2);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"FaceNativeHandle", (String)"Could not call native face detector", (Throwable)remoteException);
            return new Face[0];
        }
        faceArray = new Face[faceParcelArray.length];
        for (int i = 0; i < faceParcelArray.length; ++i) {
            FaceParcel faceParcel = faceParcelArray[i];
            faceArray[i] = new Face(faceParcel.id, new PointF(faceParcel.centerX, faceParcel.centerY), faceParcel.width, faceParcel.height, faceParcel.zzkux, faceParcel.zzkuy, zza.zza(faceParcel), faceParcel.zzkva, faceParcel.zzkvb, faceParcel.zzkvc);
        }
        return faceArray;
    }

    public final boolean zzfa(int n) {
        if (!this.isOperational()) {
            return false;
        }
        try {
            return ((zze)this.zzbjk()).zzfa(n);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"FaceNativeHandle", (String)"Could not call native face detector", (Throwable)remoteException);
            return false;
        }
    }

    protected final void zzbjh() throws RemoteException {
        ((zze)this.zzbjk()).zzbji();
    }

    private static Landmark[] zza(FaceParcel faceParcel) {
        Landmark[] landmarkArray;
        LandmarkParcel[] landmarkParcelArray = faceParcel.zzkuz;
        if (faceParcel.zzkuz == null) {
            landmarkArray = new Landmark[]{};
        } else {
            landmarkArray = new Landmark[landmarkParcelArray.length];
            for (int i = 0; i < landmarkParcelArray.length; ++i) {
                LandmarkParcel landmarkParcel = landmarkParcelArray[i];
                landmarkArray[i] = new Landmark(new PointF(landmarkParcel.x, landmarkParcel.y), landmarkParcel.type);
            }
        }
        return landmarkArray;
    }

    protected final /* synthetic */ Object zza(DynamiteModule dynamiteModule, Context context) throws RemoteException, DynamiteModule.zzc {
        IInterface iInterface;
        Context context2 = context;
        DynamiteModule dynamiteModule2 = dynamiteModule;
        zza zza2 = this;
        IBinder iBinder = dynamiteModule2.zzgx("com.google.android.gms.vision.face.ChimeraNativeFaceDetectorCreator");
        zzg zzg2 = iBinder == null ? null : ((iInterface = iBinder.queryLocalInterface("com.google.android.gms.vision.face.internal.client.INativeFaceDetectorCreator")) instanceof zzg ? (zzg)iInterface : new zzh(iBinder));
        IObjectWrapper iObjectWrapper = zzn.zzy((Object)context2);
        return zzg2.zza(iObjectWrapper, zza2.zzkuw);
    }
}

