/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.text;

import android.graphics.Point;
import android.graphics.Rect;
import android.util.SparseArray;
import com.google.android.gms.internal.zzdiw;
import com.google.android.gms.internal.zzdjc;
import com.google.android.gms.vision.text.Line;
import com.google.android.gms.vision.text.Text;
import com.google.android.gms.vision.text.zza;
import com.google.android.gms.vision.text.zzc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class TextBlock
implements Text {
    private zzdjc[] zzkvd;
    private Point[] cornerPoints;
    private List<Line> zzkve;
    private String zzkvf;
    private Rect zzkvg;

    TextBlock(SparseArray<zzdjc> sparseArray) {
        this.zzkvd = new zzdjc[sparseArray.size()];
        for (int i = 0; i < this.zzkvd.length; ++i) {
            this.zzkvd[i] = (zzdjc)((Object)sparseArray.valueAt(i));
        }
    }

    public String getLanguage() {
        if (this.zzkvf != null) {
            return this.zzkvf;
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        zzdjc[] zzdjcArray = this.zzkvd;
        int n = this.zzkvd.length;
        for (int i = 0; i < n; ++i) {
            zzdjc zzdjc2 = zzdjcArray[i];
            int n2 = 0;
            if (hashMap.containsKey(zzdjc2.zzkvf)) {
                n2 = (Integer)hashMap.get(zzdjc2.zzkvf);
            }
            hashMap.put(zzdjc2.zzkvf, n2 + 1);
        }
        this.zzkvf = Collections.max(hashMap.entrySet(), new zza(this)).getKey();
        if (this.zzkvf == null || this.zzkvf.isEmpty()) {
            this.zzkvf = "und";
        }
        return this.zzkvf;
    }

    @Override
    public String getValue() {
        if (this.zzkvd.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(this.zzkvd[0].zzkvo);
        for (int i = 1; i < this.zzkvd.length; ++i) {
            stringBuilder.append("\n");
            stringBuilder.append(this.zzkvd[i].zzkvo);
        }
        return stringBuilder.toString();
    }

    private static Point[] zza(int n, int n2, int n3, int n4, zzdiw zzdiw2) {
        int n5 = zzdiw2.left;
        int n6 = zzdiw2.top;
        double d = Math.sin(Math.toRadians(zzdiw2.zzkvj));
        double d2 = Math.cos(Math.toRadians(zzdiw2.zzkvj));
        Point[] pointArray = new Point[4];
        Point[] pointArray2 = pointArray;
        pointArray[0] = new Point(n, n2);
        pointArray2[1] = new Point(n3, n2);
        pointArray2[2] = new Point(n3, n4);
        pointArray2[3] = new Point(n, n4);
        for (int i = 0; i < 4; ++i) {
            int n7 = (int)((double)pointArray2[i].x * d2 - (double)pointArray2[i].y * d);
            int n8 = (int)((double)pointArray2[i].x * d + (double)pointArray2[i].y * d2);
            pointArray2[i].x = n7;
            pointArray2[i].y = n8;
            pointArray2[i].offset(n5, n6);
        }
        return pointArray2;
    }

    @Override
    public Point[] getCornerPoints() {
        if (this.cornerPoints == null) {
            TextBlock textBlock = this;
            if (textBlock.zzkvd.length == 0) {
                textBlock.cornerPoints = new Point[0];
            } else {
                int n = Integer.MAX_VALUE;
                int n2 = Integer.MIN_VALUE;
                int n3 = Integer.MAX_VALUE;
                int n4 = Integer.MIN_VALUE;
                for (int i = 0; i < textBlock.zzkvd.length; ++i) {
                    zzdiw zzdiw2 = textBlock.zzkvd[0].zzkvl;
                    zzdiw zzdiw3 = textBlock.zzkvd[i].zzkvl;
                    int n5 = -zzdiw2.left;
                    int n6 = -zzdiw2.top;
                    double d = Math.sin(Math.toRadians(zzdiw2.zzkvj));
                    double d2 = Math.cos(Math.toRadians(zzdiw2.zzkvj));
                    Point[] pointArray = new Point[4];
                    Point[] pointArray2 = pointArray;
                    pointArray[0] = new Point(zzdiw3.left, zzdiw3.top);
                    pointArray2[0].offset(n5, n6);
                    int n7 = (int)((double)pointArray2[0].x * d2 + (double)pointArray2[0].y * d);
                    int n8 = (int)((double)(-pointArray2[0].x) * d + (double)pointArray2[0].y * d2);
                    pointArray2[0].x = n7;
                    pointArray2[0].y = n8;
                    pointArray2[1] = new Point(n7 + zzdiw3.width, n8);
                    pointArray2[2] = new Point(n7 + zzdiw3.width, n8 + zzdiw3.height);
                    pointArray2[3] = new Point(n7, n8 + zzdiw3.height);
                    Point[] pointArray3 = pointArray2;
                    for (int j = 0; j < 4; ++j) {
                        Point point = pointArray3[j];
                        n = Math.min(n, point.x);
                        n2 = Math.max(n2, point.x);
                        n3 = Math.min(n3, point.y);
                        n4 = Math.max(n4, point.y);
                    }
                }
                textBlock.cornerPoints = TextBlock.zza(n, n3, n2, n4, textBlock.zzkvd[0].zzkvl);
            }
        }
        return this.cornerPoints;
    }

    @Override
    public List<? extends Text> getComponents() {
        TextBlock textBlock = this;
        if (textBlock.zzkvd.length == 0) {
            return new ArrayList(0);
        }
        if (textBlock.zzkve == null) {
            textBlock.zzkve = new ArrayList<Line>(textBlock.zzkvd.length);
            zzdjc[] zzdjcArray = textBlock.zzkvd;
            int n = textBlock.zzkvd.length;
            for (int i = 0; i < n; ++i) {
                zzdjc zzdjc2 = zzdjcArray[i];
                textBlock.zzkve.add(new Line(zzdjc2));
            }
        }
        return textBlock.zzkve;
    }

    @Override
    public Rect getBoundingBox() {
        if (this.zzkvg == null) {
            this.zzkvg = zzc.zza(this);
        }
        return this.zzkvg;
    }
}

