/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.text;

import android.graphics.Point;
import android.graphics.Rect;
import android.util.SparseArray;
import com.google.android.gms.internal.zzdjy;
import com.google.android.gms.internal.zzdke;
import com.google.android.gms.vision.text.Line;
import com.google.android.gms.vision.text.Text;
import com.google.android.gms.vision.text.zza;
import com.google.android.gms.vision.text.zzc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class TextBlock
implements Text {
    private zzdke[] zzkxx;
    private Point[] cornerPoints;
    private List<Line> zzkxy;
    private String zzkxz;
    private Rect zzkya;

    TextBlock(SparseArray<zzdke> sparseArray) {
        this.zzkxx = new zzdke[sparseArray.size()];
        for (int i = 0; i < this.zzkxx.length; ++i) {
            this.zzkxx[i] = (zzdke)((Object)sparseArray.valueAt(i));
        }
    }

    public String getLanguage() {
        if (this.zzkxz != null) {
            return this.zzkxz;
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        zzdke[] zzdkeArray = this.zzkxx;
        int n = this.zzkxx.length;
        for (int i = 0; i < n; ++i) {
            zzdke zzdke2 = zzdkeArray[i];
            int n2 = 0;
            if (hashMap.containsKey(zzdke2.zzkxz)) {
                n2 = (Integer)hashMap.get(zzdke2.zzkxz);
            }
            hashMap.put(zzdke2.zzkxz, n2 + 1);
        }
        this.zzkxz = Collections.max(hashMap.entrySet(), new zza(this)).getKey();
        if (this.zzkxz == null || this.zzkxz.isEmpty()) {
            this.zzkxz = "und";
        }
        return this.zzkxz;
    }

    @Override
    public String getValue() {
        if (this.zzkxx.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(this.zzkxx[0].zzkyi);
        for (int i = 1; i < this.zzkxx.length; ++i) {
            stringBuilder.append("\n");
            stringBuilder.append(this.zzkxx[i].zzkyi);
        }
        return stringBuilder.toString();
    }

    private static Point[] zza(int n, int n2, int n3, int n4, zzdjy zzdjy2) {
        int n5 = zzdjy2.left;
        int n6 = zzdjy2.top;
        double d = Math.sin(Math.toRadians(zzdjy2.zzkyd));
        double d2 = Math.cos(Math.toRadians(zzdjy2.zzkyd));
        Point[] pointArray = new Point[4];
        Point[] pointArray2 = pointArray;
        pointArray[0] = new Point(n, n2);
        pointArray2[1] = new Point(n3, n2);
        pointArray2[2] = new Point(n3, n4);
        pointArray2[3] = new Point(n, n4);
        for (int i = 0; i < 4; ++i) {
            int n7 = (int)((double)pointArray2[i].x * d2 - (double)pointArray2[i].y * d);
            int n8 = (int)((double)pointArray2[i].x * d + (double)pointArray2[i].y * d2);
            pointArray2[i].x = n7;
            pointArray2[i].y = n8;
            pointArray2[i].offset(n5, n6);
        }
        return pointArray2;
    }

    @Override
    public Point[] getCornerPoints() {
        if (this.cornerPoints == null) {
            TextBlock textBlock = this;
            if (textBlock.zzkxx.length == 0) {
                textBlock.cornerPoints = new Point[0];
            } else {
                int n = Integer.MAX_VALUE;
                int n2 = Integer.MIN_VALUE;
                int n3 = Integer.MAX_VALUE;
                int n4 = Integer.MIN_VALUE;
                for (int i = 0; i < textBlock.zzkxx.length; ++i) {
                    zzdjy zzdjy2 = textBlock.zzkxx[0].zzkyf;
                    zzdjy zzdjy3 = textBlock.zzkxx[i].zzkyf;
                    int n5 = -zzdjy2.left;
                    int n6 = -zzdjy2.top;
                    double d = Math.sin(Math.toRadians(zzdjy2.zzkyd));
                    double d2 = Math.cos(Math.toRadians(zzdjy2.zzkyd));
                    Point[] pointArray = new Point[4];
                    Point[] pointArray2 = pointArray;
                    pointArray[0] = new Point(zzdjy3.left, zzdjy3.top);
                    pointArray2[0].offset(n5, n6);
                    int n7 = (int)((double)pointArray2[0].x * d2 + (double)pointArray2[0].y * d);
                    int n8 = (int)((double)(-pointArray2[0].x) * d + (double)pointArray2[0].y * d2);
                    pointArray2[0].x = n7;
                    pointArray2[0].y = n8;
                    pointArray2[1] = new Point(n7 + zzdjy3.width, n8);
                    pointArray2[2] = new Point(n7 + zzdjy3.width, n8 + zzdjy3.height);
                    pointArray2[3] = new Point(n7, n8 + zzdjy3.height);
                    Point[] pointArray3 = pointArray2;
                    for (int j = 0; j < 4; ++j) {
                        Point point = pointArray3[j];
                        n = Math.min(n, point.x);
                        n2 = Math.max(n2, point.x);
                        n3 = Math.min(n3, point.y);
                        n4 = Math.max(n4, point.y);
                    }
                }
                textBlock.cornerPoints = TextBlock.zza(n, n3, n2, n4, textBlock.zzkxx[0].zzkyf);
            }
        }
        return this.cornerPoints;
    }

    @Override
    public List<? extends Text> getComponents() {
        TextBlock textBlock = this;
        if (textBlock.zzkxx.length == 0) {
            return new ArrayList(0);
        }
        if (textBlock.zzkxy == null) {
            textBlock.zzkxy = new ArrayList<Line>(textBlock.zzkxx.length);
            zzdke[] zzdkeArray = textBlock.zzkxx;
            int n = textBlock.zzkxx.length;
            for (int i = 0; i < n; ++i) {
                zzdke zzdke2 = zzdkeArray[i];
                textBlock.zzkxy.add(new Line(zzdke2));
            }
        }
        return textBlock.zzkxy;
    }

    @Override
    public Rect getBoundingBox() {
        if (this.zzkya == null) {
            this.zzkya = zzc.zza(this);
        }
        return this.zzkya;
    }
}

