/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.text;

import android.graphics.Point;
import android.graphics.Rect;
import android.util.SparseArray;
import com.google.android.gms.internal.vision.zzae;
import com.google.android.gms.internal.vision.zzy;
import com.google.android.gms.vision.text.Line;
import com.google.android.gms.vision.text.Text;
import com.google.android.gms.vision.text.zza;
import com.google.android.gms.vision.text.zzc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class TextBlock
implements Text {
    private zzae[] zzev;
    private Point[] cornerPoints;
    private List<Line> zzew;
    private String zzex;
    private Rect zzey;

    TextBlock(SparseArray<zzae> sparseArray) {
        this.zzev = new zzae[sparseArray.size()];
        for (int i = 0; i < this.zzev.length; ++i) {
            this.zzev[i] = (zzae)((Object)sparseArray.valueAt(i));
        }
    }

    public String getLanguage() {
        if (this.zzex != null) {
            return this.zzex;
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        zzae[] zzaeArray = this.zzev;
        int n = this.zzev.length;
        for (int i = 0; i < n; ++i) {
            zzae zzae2 = zzaeArray[i];
            int n2 = 0;
            if (hashMap.containsKey(zzae2.zzex)) {
                n2 = (Integer)hashMap.get(zzae2.zzex);
            }
            hashMap.put(zzae2.zzex, n2 + 1);
        }
        this.zzex = Collections.max(hashMap.entrySet(), new zza(this)).getKey();
        if (this.zzex == null || this.zzex.isEmpty()) {
            this.zzex = "und";
        }
        return this.zzex;
    }

    @Override
    public String getValue() {
        if (this.zzev.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(this.zzev[0].zzfg);
        for (int i = 1; i < this.zzev.length; ++i) {
            stringBuilder.append("\n");
            stringBuilder.append(this.zzev[i].zzfg);
        }
        return stringBuilder.toString();
    }

    @Override
    public Point[] getCornerPoints() {
        if (this.cornerPoints == null) {
            TextBlock textBlock = this;
            if (textBlock.zzev.length == 0) {
                textBlock.cornerPoints = new Point[0];
            } else {
                int n;
                int n2;
                int n3 = Integer.MAX_VALUE;
                int n4 = Integer.MIN_VALUE;
                int n5 = Integer.MAX_VALUE;
                int n6 = Integer.MIN_VALUE;
                for (int i = 0; i < textBlock.zzev.length; ++i) {
                    zzy zzy2 = textBlock.zzev[0].zzfd;
                    zzy zzy3 = textBlock.zzev[i].zzfd;
                    n2 = -zzy2.left;
                    n = -zzy2.top;
                    double d = Math.sin(Math.toRadians(zzy2.zzfb));
                    double d2 = Math.cos(Math.toRadians(zzy2.zzfb));
                    Point[] pointArray = new Point[4];
                    Point[] pointArray2 = pointArray;
                    pointArray[0] = new Point(zzy3.left, zzy3.top);
                    pointArray2[0].offset(n2, n);
                    int n7 = (int)((double)pointArray2[0].x * d2 + (double)pointArray2[0].y * d);
                    int n8 = (int)((double)(-pointArray2[0].x) * d + (double)pointArray2[0].y * d2);
                    pointArray2[0].x = n7;
                    pointArray2[0].y = n8;
                    pointArray2[1] = new Point(n7 + zzy3.width, n8);
                    pointArray2[2] = new Point(n7 + zzy3.width, n8 + zzy3.height);
                    pointArray2[3] = new Point(n7, n8 + zzy3.height);
                    Point[] pointArray3 = pointArray2;
                    for (int j = 0; j < 4; ++j) {
                        Point point = pointArray3[j];
                        n3 = Math.min(n3, point.x);
                        n4 = Math.max(n4, point.x);
                        n5 = Math.min(n5, point.y);
                        n6 = Math.max(n6, point.y);
                    }
                }
                zzy zzy4 = textBlock.zzev[0].zzfd;
                n = n6;
                n2 = n4;
                int n9 = n5;
                int n10 = n3;
                int n11 = zzy4.left;
                int n12 = zzy4.top;
                double d = Math.sin(Math.toRadians(zzy4.zzfb));
                double d3 = Math.cos(Math.toRadians(zzy4.zzfb));
                Point[] pointArray = new Point[4];
                Point[] pointArray4 = pointArray;
                pointArray[0] = new Point(n10, n9);
                pointArray4[1] = new Point(n2, n9);
                pointArray4[2] = new Point(n2, n);
                pointArray4[3] = new Point(n10, n);
                for (int i = 0; i < 4; ++i) {
                    int n13 = (int)((double)pointArray4[i].x * d3 - (double)pointArray4[i].y * d);
                    int n14 = (int)((double)pointArray4[i].x * d + (double)pointArray4[i].y * d3);
                    pointArray4[i].x = n13;
                    pointArray4[i].y = n14;
                    pointArray4[i].offset(n11, n12);
                }
                textBlock.cornerPoints = pointArray4;
            }
        }
        return this.cornerPoints;
    }

    @Override
    public List<? extends Text> getComponents() {
        TextBlock textBlock = this;
        if (textBlock.zzev.length == 0) {
            return new ArrayList(0);
        }
        if (textBlock.zzew == null) {
            textBlock.zzew = new ArrayList<Line>(textBlock.zzev.length);
            zzae[] zzaeArray = textBlock.zzev;
            int n = textBlock.zzev.length;
            for (int i = 0; i < n; ++i) {
                zzae zzae2 = zzaeArray[i];
                textBlock.zzew.add(new Line(zzae2));
            }
        }
        return textBlock.zzew;
    }

    @Override
    public Rect getBoundingBox() {
        if (this.zzey == null) {
            this.zzey = zzc.zza(this);
        }
        return this.zzey;
    }
}

