/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.text;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.util.SparseArray;
import com.google.android.gms.internal.vision.zzae;
import com.google.android.gms.internal.vision.zzag;
import com.google.android.gms.internal.vision.zzak;
import com.google.android.gms.internal.vision.zzal;
import com.google.android.gms.internal.vision.zzn;
import com.google.android.gms.internal.vision.zzp;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.text.TextBlock;
import com.google.android.gms.vision.text.zzb;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public final class TextRecognizer
extends Detector<TextBlock> {
    private final zzak zzez;

    private TextRecognizer() {
        throw new IllegalStateException("Default constructor called");
    }

    private TextRecognizer(zzak zzak2) {
        this.zzez = zzak2;
    }

    public final SparseArray<TextBlock> detect(Frame frame) {
        Rect rect;
        int n;
        int n2;
        Frame.Metadata metadata;
        Bitmap bitmap;
        zzag zzag2 = new zzag(new Rect());
        Frame frame2 = frame;
        TextRecognizer textRecognizer = this;
        if (frame2 == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        zzn zzn2 = zzn.zzc((Frame)frame2);
        if (frame2.getBitmap() != null) {
            bitmap = frame2.getBitmap();
        } else {
            byte[] byArray;
            metadata = frame2.getMetadata();
            int n3 = zzn2.height;
            n2 = zzn2.width;
            n = metadata.getFormat();
            rect = frame2.getGrayscaleImageData();
            if (rect.hasArray() && rect.arrayOffset() == 0) {
                byArray = rect.array();
            } else {
                byArray = new byte[rect.capacity()];
                rect.get(byArray);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            new YuvImage(byArray, n, n2, n3, null).compressToJpeg(new Rect(0, 0, n2, n3), 100, (OutputStream)byteArrayOutputStream);
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            bitmap = BitmapFactory.decodeByteArray((byte[])byArray2, (int)0, (int)byArray2.length);
        }
        bitmap = zzp.zzb((Bitmap)bitmap, (zzn)zzn2);
        if (!zzag2.zzfl.isEmpty()) {
            Rect rect2;
            zzn zzn3 = zzn2;
            n2 = frame2.getMetadata().getHeight();
            n = frame2.getMetadata().getWidth();
            rect = zzag2.zzfl;
            switch (zzn3.rotation) {
                case 1: {
                    rect2 = new Rect(n2 - rect.bottom, rect.left, n2 - rect.top, rect.right);
                    break;
                }
                case 2: {
                    rect2 = new Rect(n - rect.right, n2 - rect.bottom, n - rect.left, n2 - rect.top);
                    break;
                }
                case 3: {
                    rect2 = new Rect(rect.top, n - rect.right, rect.bottom, n - rect.left);
                    break;
                }
                default: {
                    rect2 = rect;
                }
            }
            metadata = rect2;
            zzag2.zzfl.set((Rect)metadata);
        }
        zzn2.rotation = 0;
        rect = textRecognizer.zzez.zza(bitmap, zzn2, zzag2);
        SparseArray sparseArray = new SparseArray();
        for (ByteArrayOutputStream byteArrayOutputStream : rect) {
            SparseArray sparseArray2 = (SparseArray)sparseArray.get(((zzae)((Object)byteArrayOutputStream)).zzfj);
            if (sparseArray2 == null) {
                sparseArray2 = new SparseArray();
                sparseArray.append(((zzae)((Object)byteArrayOutputStream)).zzfj, (Object)sparseArray2);
            }
            sparseArray2.append(((zzae)((Object)byteArrayOutputStream)).zzfk, (Object)byteArrayOutputStream);
        }
        Rect rect3 = new SparseArray(sparseArray.size());
        for (int i = 0; i < sparseArray.size(); ++i) {
            rect3.append(sparseArray.keyAt(i), (Object)new TextBlock((SparseArray<zzae>)((SparseArray)sparseArray.valueAt(i))));
        }
        return rect3;
    }

    public final boolean isOperational() {
        return this.zzez.isOperational();
    }

    public final void release() {
        super.release();
        this.zzez.zzp();
    }

    /* synthetic */ TextRecognizer(zzak zzak2, zzb zzb2) {
        this(zzak2);
    }

    public static class Builder {
        private Context zze;
        private zzal zzfa;

        public Builder(Context context) {
            this.zze = context;
            this.zzfa = new zzal();
        }

        public TextRecognizer build() {
            zzak zzak2 = new zzak(this.zze, this.zzfa);
            return new TextRecognizer(zzak2, null);
        }
    }
}

