/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.text;

import android.graphics.Point;
import android.graphics.Rect;
import android.util.SparseArray;
import com.google.android.gms.internal.vision.zzac;
import com.google.android.gms.internal.vision.zzw;
import com.google.android.gms.vision.text.Line;
import com.google.android.gms.vision.text.Text;
import com.google.android.gms.vision.text.zza;
import com.google.android.gms.vision.text.zzc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class TextBlock
implements Text {
    private zzac[] zzea;
    private Point[] cornerPoints;
    private List<Line> zzeb;
    private String zzec;
    private Rect zzed;

    TextBlock(SparseArray<zzac> sparseArray) {
        this.zzea = new zzac[sparseArray.size()];
        for (int i = 0; i < this.zzea.length; ++i) {
            this.zzea[i] = (zzac)((Object)sparseArray.valueAt(i));
        }
    }

    public String getLanguage() {
        if (this.zzec != null) {
            return this.zzec;
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        zzac[] zzacArray = this.zzea;
        int n = this.zzea.length;
        for (int i = 0; i < n; ++i) {
            zzac zzac2 = zzacArray[i];
            int n2 = 0;
            if (hashMap.containsKey(zzac2.zzec)) {
                n2 = (Integer)hashMap.get(zzac2.zzec);
            }
            hashMap.put(zzac2.zzec, n2 + 1);
        }
        this.zzec = Collections.max(hashMap.entrySet(), new zza(this)).getKey();
        if (this.zzec == null || this.zzec.isEmpty()) {
            this.zzec = "und";
        }
        return this.zzec;
    }

    @Override
    public String getValue() {
        if (this.zzea.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(this.zzea[0].zzel);
        for (int i = 1; i < this.zzea.length; ++i) {
            stringBuilder.append("\n");
            stringBuilder.append(this.zzea[i].zzel);
        }
        return stringBuilder.toString();
    }

    @Override
    public Point[] getCornerPoints() {
        if (this.cornerPoints == null) {
            TextBlock textBlock = this;
            if (textBlock.zzea.length == 0) {
                textBlock.cornerPoints = new Point[0];
            } else {
                int n;
                int n2;
                int n3 = Integer.MAX_VALUE;
                int n4 = Integer.MIN_VALUE;
                int n5 = Integer.MAX_VALUE;
                int n6 = Integer.MIN_VALUE;
                for (int i = 0; i < textBlock.zzea.length; ++i) {
                    zzw zzw2 = textBlock.zzea[0].zzei;
                    zzw zzw3 = textBlock.zzea[i].zzei;
                    n2 = -zzw2.left;
                    n = -zzw2.top;
                    double d = Math.sin(Math.toRadians(zzw2.zzeg));
                    double d2 = Math.cos(Math.toRadians(zzw2.zzeg));
                    Point[] pointArray = new Point[4];
                    Point[] pointArray2 = pointArray;
                    pointArray[0] = new Point(zzw3.left, zzw3.top);
                    pointArray2[0].offset(n2, n);
                    int n7 = (int)((double)pointArray2[0].x * d2 + (double)pointArray2[0].y * d);
                    int n8 = (int)((double)(-pointArray2[0].x) * d + (double)pointArray2[0].y * d2);
                    pointArray2[0].x = n7;
                    pointArray2[0].y = n8;
                    pointArray2[1] = new Point(n7 + zzw3.width, n8);
                    pointArray2[2] = new Point(n7 + zzw3.width, n8 + zzw3.height);
                    pointArray2[3] = new Point(n7, n8 + zzw3.height);
                    Point[] pointArray3 = pointArray2;
                    for (int j = 0; j < 4; ++j) {
                        Point point = pointArray3[j];
                        n3 = Math.min(n3, point.x);
                        n4 = Math.max(n4, point.x);
                        n5 = Math.min(n5, point.y);
                        n6 = Math.max(n6, point.y);
                    }
                }
                zzw zzw4 = textBlock.zzea[0].zzei;
                n = n6;
                n2 = n4;
                int n9 = n5;
                int n10 = n3;
                int n11 = zzw4.left;
                int n12 = zzw4.top;
                double d = Math.sin(Math.toRadians(zzw4.zzeg));
                double d3 = Math.cos(Math.toRadians(zzw4.zzeg));
                Point[] pointArray = new Point[4];
                Point[] pointArray4 = pointArray;
                pointArray[0] = new Point(n10, n9);
                pointArray4[1] = new Point(n2, n9);
                pointArray4[2] = new Point(n2, n);
                pointArray4[3] = new Point(n10, n);
                for (int i = 0; i < 4; ++i) {
                    int n13 = (int)((double)pointArray4[i].x * d3 - (double)pointArray4[i].y * d);
                    int n14 = (int)((double)pointArray4[i].x * d + (double)pointArray4[i].y * d3);
                    pointArray4[i].x = n13;
                    pointArray4[i].y = n14;
                    pointArray4[i].offset(n11, n12);
                }
                textBlock.cornerPoints = pointArray4;
            }
        }
        return this.cornerPoints;
    }

    @Override
    public List<? extends Text> getComponents() {
        TextBlock textBlock = this;
        if (textBlock.zzea.length == 0) {
            return new ArrayList(0);
        }
        if (textBlock.zzeb == null) {
            textBlock.zzeb = new ArrayList<Line>(textBlock.zzea.length);
            zzac[] zzacArray = textBlock.zzea;
            int n = textBlock.zzea.length;
            for (int i = 0; i < n; ++i) {
                zzac zzac2 = zzacArray[i];
                textBlock.zzeb.add(new Line(zzac2));
            }
        }
        return textBlock.zzeb;
    }

    @Override
    public Rect getBoundingBox() {
        if (this.zzed == null) {
            this.zzed = zzc.zza(this);
        }
        return this.zzed;
    }
}

