/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.text;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.util.SparseArray;
import com.google.android.gms.internal.vision.zzac;
import com.google.android.gms.internal.vision.zzae;
import com.google.android.gms.internal.vision.zzah;
import com.google.android.gms.internal.vision.zzai;
import com.google.android.gms.internal.vision.zzp;
import com.google.android.gms.internal.vision.zzq;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.text.TextBlock;
import com.google.android.gms.vision.text.zzb;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public final class TextRecognizer
extends Detector<TextBlock> {
    private final zzai zzee;

    private TextRecognizer() {
        throw new IllegalStateException("Default constructor called");
    }

    private TextRecognizer(zzai zzai2) {
        this.zzee = zzai2;
    }

    public final SparseArray<TextBlock> detect(Frame frame) {
        Rect rect;
        int n;
        int n2;
        Frame.Metadata metadata;
        Bitmap bitmap;
        zzae zzae2 = new zzae(new Rect());
        Frame frame2 = frame;
        TextRecognizer textRecognizer = this;
        if (frame2 == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        zzp zzp2 = zzp.zzc((Frame)frame2);
        if (frame2.getBitmap() != null) {
            bitmap = frame2.getBitmap();
        } else {
            byte[] byArray;
            metadata = frame2.getMetadata();
            int n3 = zzp2.height;
            n2 = zzp2.width;
            n = metadata.getFormat();
            rect = frame2.getGrayscaleImageData();
            if (rect.hasArray() && rect.arrayOffset() == 0) {
                byArray = rect.array();
            } else {
                byArray = new byte[rect.capacity()];
                rect.get(byArray);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            new YuvImage(byArray, n, n2, n3, null).compressToJpeg(new Rect(0, 0, n2, n3), 100, (OutputStream)byteArrayOutputStream);
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            bitmap = BitmapFactory.decodeByteArray((byte[])byArray2, (int)0, (int)byArray2.length);
        }
        bitmap = zzq.zzb((Bitmap)bitmap, (zzp)zzp2);
        if (!zzae2.zzeq.isEmpty()) {
            Rect rect2;
            zzp zzp3 = zzp2;
            n2 = frame2.getMetadata().getHeight();
            n = frame2.getMetadata().getWidth();
            rect = zzae2.zzeq;
            switch (zzp3.rotation) {
                case 1: {
                    rect2 = new Rect(n2 - rect.bottom, rect.left, n2 - rect.top, rect.right);
                    break;
                }
                case 2: {
                    rect2 = new Rect(n - rect.right, n2 - rect.bottom, n - rect.left, n2 - rect.top);
                    break;
                }
                case 3: {
                    rect2 = new Rect(rect.top, n - rect.right, rect.bottom, n - rect.left);
                    break;
                }
                default: {
                    rect2 = rect;
                }
            }
            metadata = rect2;
            zzae2.zzeq.set((Rect)metadata);
        }
        zzp2.rotation = 0;
        rect = textRecognizer.zzee.zza(bitmap, zzp2, zzae2);
        SparseArray sparseArray = new SparseArray();
        for (ByteArrayOutputStream byteArrayOutputStream : rect) {
            SparseArray sparseArray2 = (SparseArray)sparseArray.get(((zzac)((Object)byteArrayOutputStream)).zzeo);
            if (sparseArray2 == null) {
                sparseArray2 = new SparseArray();
                sparseArray.append(((zzac)((Object)byteArrayOutputStream)).zzeo, (Object)sparseArray2);
            }
            sparseArray2.append(((zzac)((Object)byteArrayOutputStream)).zzep, (Object)byteArrayOutputStream);
        }
        Rect rect3 = new SparseArray(sparseArray.size());
        for (int i = 0; i < sparseArray.size(); ++i) {
            rect3.append(sparseArray.keyAt(i), (Object)new TextBlock((SparseArray<zzac>)((SparseArray)sparseArray.valueAt(i))));
        }
        return rect3;
    }

    public final boolean isOperational() {
        return this.zzee.isOperational();
    }

    public final void release() {
        super.release();
        this.zzee.zzo();
    }

    /* synthetic */ TextRecognizer(zzai zzai2, zzb zzb2) {
        this(zzai2);
    }

    public static class Builder {
        private Context zze;
        private zzah zzef;

        public Builder(Context context) {
            this.zze = context;
            this.zzef = new zzah();
        }

        public TextRecognizer build() {
            zzai zzai2 = new zzai(this.zze, this.zzef);
            return new TextRecognizer(zzai2, null);
        }
    }
}

