/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.SparseArray;
import com.google.android.gms.vision.Frame;

public abstract class Detector<T> {
    private Object zzaUV = new Object();
    private Processor<T> zzaUW;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.zzaUV;
        synchronized (object) {
            if (this.zzaUW != null) {
                this.zzaUW.release();
                this.zzaUW = null;
            }
        }
    }

    public abstract SparseArray<T> detect(Frame var1);

    public boolean setFocus(int id) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveFrame(Frame frame) {
        Object object = this.zzaUV;
        synchronized (object) {
            if (this.zzaUW == null) {
                throw new IllegalStateException("Detector processor must first be set with setProcessor in order to receive detection results.");
            }
            Frame.Metadata metadata = new Frame.Metadata(frame.getMetadata());
            metadata.zzCd();
            SparseArray<T> sparseArray = this.detect(frame);
            boolean bl = this.isOperational();
            Detections<T> detections = new Detections<T>(sparseArray, metadata, bl);
            this.zzaUW.receiveDetections(detections);
        }
    }

    public void setProcessor(Processor<T> processor) {
        this.zzaUW = processor;
    }

    public boolean isOperational() {
        return true;
    }

    public static interface Processor<T> {
        public void release();

        public void receiveDetections(Detections<T> var1);
    }

    public static class Detections<T> {
        private SparseArray<T> zzaUX;
        private Frame.Metadata zzaUY;
        private boolean zzaUZ;

        public Detections(SparseArray<T> detectedItems, Frame.Metadata frameMetadata, boolean isOperational) {
            this.zzaUX = detectedItems;
            this.zzaUY = frameMetadata;
            this.zzaUZ = isOperational;
        }

        public SparseArray<T> getDetectedItems() {
            return this.zzaUX;
        }

        public Frame.Metadata getFrameMetadata() {
            return this.zzaUY;
        }

        public boolean detectorIsOperational() {
            return this.zzaUZ;
        }
    }
}

