/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.face;

import android.content.Context;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.face.Face;
import com.google.android.gms.vision.face.internal.client.FaceSettingsParcel;
import com.google.android.gms.vision.face.internal.client.zzg;
import com.google.android.gms.vision.internal.client.FrameMetadataParcel;
import com.google.android.gms.vision.zza;
import java.nio.ByteBuffer;
import java.util.HashSet;

public final class FaceDetector
extends Detector<Face> {
    public static final int NO_LANDMARKS = 0;
    public static final int ALL_LANDMARKS = 1;
    public static final int NO_CLASSIFICATIONS = 0;
    public static final int ALL_CLASSIFICATIONS = 1;
    public static final int FAST_MODE = 0;
    public static final int ACCURATE_MODE = 1;
    private final zza zzbiA = new zza();
    private final zzg zzbiB;
    private final Object zzpK = new Object();
    private boolean zzbiC = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Object object = this.zzpK;
        synchronized (object) {
            if (!this.zzbiC) {
                return;
            }
            this.zzbiB.zzGm();
            this.zzbiC = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            Object object = this.zzpK;
            synchronized (object) {
                if (this.zzbiC) {
                    Log.w((String)"FaceDetector", (String)"FaceDetector was not released with FaceDetector.release()");
                    this.release();
                }
            }
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SparseArray<Face> detect(Frame frame) {
        Face[] faceArray;
        if (frame == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        ByteBuffer byteBuffer = frame.getGrayscaleImageData();
        Object object = this.zzpK;
        synchronized (object) {
            if (!this.zzbiC) {
                throw new RuntimeException("Cannot use detector after release()");
            }
            faceArray = this.zzbiB.zzb(byteBuffer, FrameMetadataParcel.zzc(frame));
        }
        int n = 0;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        SparseArray sparseArray = new SparseArray(faceArray.length);
        for (Face face : faceArray) {
            int n2 = face.getId();
            n = Math.max(n, n2);
            if (hashSet.contains(n2)) {
                n2 = ++n;
            }
            hashSet.add(n2);
            int n3 = this.zzbiA.zzka(n2);
            sparseArray.append(n3, (Object)face);
        }
        return sparseArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setFocus(int id) {
        int n = this.zzbiA.zzkb(id);
        Object object = this.zzpK;
        synchronized (object) {
            if (!this.zzbiC) {
                throw new RuntimeException("Cannot use detector after release()");
            }
            return this.zzbiB.zzks(n);
        }
    }

    @Override
    public boolean isOperational() {
        return this.zzbiB.isOperational();
    }

    private FaceDetector() {
        throw new IllegalStateException("Default constructor called");
    }

    private FaceDetector(zzg handle) {
        this.zzbiB = handle;
    }

    public static class Builder {
        private final Context mContext;
        private int zzbiD = 0;
        private boolean zzbiE = false;
        private int zzbiF = 0;
        private boolean zzbiG = true;
        private int zzamE = 0;

        public Builder(Context context) {
            this.mContext = context;
        }

        public Builder setLandmarkType(int landmarkType) {
            if (landmarkType != 0 && landmarkType != 1) {
                throw new IllegalArgumentException("Invalid landmark type: " + landmarkType);
            }
            this.zzbiD = landmarkType;
            return this;
        }

        public Builder setProminentFaceOnly(boolean prominentFaceOnly) {
            this.zzbiE = prominentFaceOnly;
            return this;
        }

        public Builder setClassificationType(int classificationType) {
            if (classificationType != 0 && classificationType != 1) {
                throw new IllegalArgumentException("Invalid classification type: " + classificationType);
            }
            this.zzbiF = classificationType;
            return this;
        }

        public Builder setTrackingEnabled(boolean trackingEnabled) {
            this.zzbiG = trackingEnabled;
            return this;
        }

        public Builder setMode(int mode) {
            switch (mode) {
                case 0: 
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid mode: " + mode);
                }
            }
            this.zzamE = mode;
            return this;
        }

        public FaceDetector build() {
            FaceSettingsParcel faceSettingsParcel = new FaceSettingsParcel();
            faceSettingsParcel.mode = this.zzamE;
            faceSettingsParcel.zzbiO = this.zzbiD;
            faceSettingsParcel.zzbiP = this.zzbiF;
            faceSettingsParcel.zzbiQ = this.zzbiE;
            faceSettingsParcel.zzbiR = this.zzbiG;
            zzg zzg2 = new zzg(this.mContext, faceSettingsParcel);
            return new FaceDetector(zzg2);
        }
    }
}

