/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.barcode;

import android.graphics.Point;
import android.graphics.Rect;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.vision.barcode.zza;
import com.google.android.gms.vision.barcode.zzb;
import com.google.android.gms.vision.barcode.zzc;
import com.google.android.gms.vision.barcode.zzd;
import com.google.android.gms.vision.barcode.zze;
import com.google.android.gms.vision.barcode.zzf;
import com.google.android.gms.vision.barcode.zzg;
import com.google.android.gms.vision.barcode.zzh;
import com.google.android.gms.vision.barcode.zzi;
import com.google.android.gms.vision.barcode.zzj;
import com.google.android.gms.vision.barcode.zzk;
import com.google.android.gms.vision.barcode.zzl;
import com.google.android.gms.vision.barcode.zzm;

public class Barcode
implements SafeParcelable {
    public static final zzb CREATOR = new zzb();
    public static final int ALL_FORMATS = 0;
    public static final int CODE_128 = 1;
    public static final int CODE_39 = 2;
    public static final int CODE_93 = 4;
    public static final int CODABAR = 8;
    public static final int DATA_MATRIX = 16;
    public static final int EAN_13 = 32;
    public static final int EAN_8 = 64;
    public static final int ITF = 128;
    public static final int QR_CODE = 256;
    public static final int UPC_A = 512;
    public static final int UPC_E = 1024;
    public static final int PDF417 = 2048;
    public static final int AZTEC = 4096;
    public static final int CONTACT_INFO = 1;
    public static final int EMAIL = 2;
    public static final int ISBN = 3;
    public static final int PHONE = 4;
    public static final int PRODUCT = 5;
    public static final int SMS = 6;
    public static final int TEXT = 7;
    public static final int URL = 8;
    public static final int WIFI = 9;
    public static final int GEO = 10;
    public static final int CALENDAR_EVENT = 11;
    public static final int DRIVER_LICENSE = 12;
    final int versionCode;
    public int format;
    public String rawValue;
    public String displayValue;
    public int valueFormat;
    public Point[] cornerPoints;
    public Email email;
    public Phone phone;
    public Sms sms;
    public WiFi wifi;
    public UrlBookmark url;
    public GeoPoint geoPoint;
    public CalendarEvent calendarEvent;
    public ContactInfo contactInfo;
    public DriverLicense driverLicense;

    public Barcode() {
        this.versionCode = 1;
    }

    public Barcode(int versionCode, int format, String rawValue, String displayValue, int valueFormat, Point[] cornerPoints, Email email, Phone phone, Sms sms, WiFi wifi, UrlBookmark url, GeoPoint geoPoint, CalendarEvent calendarEvent, ContactInfo contactInfo, DriverLicense driverLicense) {
        this.versionCode = versionCode;
        this.format = format;
        this.rawValue = rawValue;
        this.displayValue = displayValue;
        this.valueFormat = valueFormat;
        this.cornerPoints = cornerPoints;
        this.email = email;
        this.phone = phone;
        this.sms = sms;
        this.wifi = wifi;
        this.url = url;
        this.geoPoint = geoPoint;
        this.calendarEvent = calendarEvent;
        this.contactInfo = contactInfo;
        this.driverLicense = driverLicense;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzb.zza(this, parcel, flags);
    }

    public Rect getBoundingBox() {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        for (int i = 0; i < this.cornerPoints.length; ++i) {
            Point point = this.cornerPoints[i];
            n = Math.min(n, point.x);
            n2 = Math.max(n2, point.x);
            n3 = Math.min(n3, point.y);
            n4 = Math.max(n4, point.y);
        }
        return new Rect(n, n3, n2, n4);
    }

    public static class DriverLicense
    implements SafeParcelable {
        public static final zzf CREATOR = new zzf();
        final int versionCode;
        public String documentType;
        public String firstName;
        public String middleName;
        public String lastName;
        public String gender;
        public String addressStreet;
        public String addressCity;
        public String addressState;
        public String addressZip;
        public String licenseNumber;
        public String issueDate;
        public String expiryDate;
        public String birthDate;
        public String issuingCountry;

        public DriverLicense() {
            this.versionCode = 1;
        }

        public DriverLicense(int versionCode, String documentType, String firstName, String middleName, String lastName, String gender, String addressStreet, String addressCity, String addressState, String addressZip, String licenseNumber, String issueDate, String expiryDate, String birthDate, String issuingCountry) {
            this.versionCode = versionCode;
            this.documentType = documentType;
            this.firstName = firstName;
            this.middleName = middleName;
            this.lastName = lastName;
            this.gender = gender;
            this.addressStreet = addressStreet;
            this.addressCity = addressCity;
            this.addressState = addressState;
            this.addressZip = addressZip;
            this.licenseNumber = licenseNumber;
            this.issueDate = issueDate;
            this.expiryDate = expiryDate;
            this.birthDate = birthDate;
            this.issuingCountry = issuingCountry;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int flags) {
            zzf.zza(this, parcel, flags);
        }
    }

    public static class ContactInfo
    implements SafeParcelable {
        public static final zze CREATOR = new zze();
        final int versionCode;
        public PersonName name;
        public String organization;
        public String title;
        public Phone[] phones;
        public Email[] emails;
        public String[] urls;
        public Address[] addresses;

        public ContactInfo() {
            this.versionCode = 1;
        }

        public ContactInfo(int versionCode, PersonName name, String organization, String title, Phone[] phones, Email[] emails, String[] urls, Address[] addresses) {
            this.versionCode = versionCode;
            this.name = name;
            this.organization = organization;
            this.title = title;
            this.phones = phones;
            this.emails = emails;
            this.urls = urls;
            this.addresses = addresses;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int flags) {
            zze.zza(this, parcel, flags);
        }
    }

    public static class Address
    implements SafeParcelable {
        public static final zza CREATOR = new zza();
        final int versionCode;
        public static final int UNKNOWN = 0;
        public static final int WORK = 1;
        public static final int HOME = 2;
        public int type;
        public String[] addressLines;

        public Address() {
            this.versionCode = 1;
        }

        public Address(int versionCode, int type, String[] addressLines) {
            this.versionCode = versionCode;
            this.type = type;
            this.addressLines = addressLines;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int flags) {
            zza.zza(this, parcel, flags);
        }
    }

    public static class PersonName
    implements SafeParcelable {
        public static final zzi CREATOR = new zzi();
        final int versionCode;
        public String formattedName;
        public String pronunciation;
        public String prefix;
        public String first;
        public String middle;
        public String last;
        public String suffix;

        public PersonName() {
            this.versionCode = 1;
        }

        public PersonName(int versionCode, String formattedName, String pronunciation, String prefix, String first, String middle, String last, String suffix) {
            this.versionCode = versionCode;
            this.formattedName = formattedName;
            this.pronunciation = pronunciation;
            this.prefix = prefix;
            this.first = first;
            this.middle = middle;
            this.last = last;
            this.suffix = suffix;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int flags) {
            zzi.zza(this, parcel, flags);
        }
    }

    public static class CalendarEvent
    implements SafeParcelable {
        public static final zzd CREATOR = new zzd();
        final int versionCode;
        public String summary;
        public String description;
        public String location;
        public String organizer;
        public String status;
        public CalendarDateTime start;
        public CalendarDateTime end;

        public CalendarEvent() {
            this.versionCode = 1;
        }

        public CalendarEvent(int versionCode, String summary, String description, String location, String organizer, String status, CalendarDateTime start, CalendarDateTime end) {
            this.versionCode = versionCode;
            this.summary = summary;
            this.description = description;
            this.location = location;
            this.organizer = organizer;
            this.status = status;
            this.start = start;
            this.end = end;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int flags) {
            zzd.zza(this, parcel, flags);
        }
    }

    public static class CalendarDateTime
    implements SafeParcelable {
        public static final zzc CREATOR = new zzc();
        final int versionCode;
        public int year;
        public int month;
        public int day;
        public int hours;
        public int minutes;
        public int seconds;
        public boolean isUtc;
        public String rawValue;

        public CalendarDateTime() {
            this.versionCode = 1;
        }

        public CalendarDateTime(int versionCode, int year, int month, int day, int hours, int minutes, int seconds, boolean isUtc, String rawValue) {
            this.versionCode = versionCode;
            this.year = year;
            this.month = month;
            this.day = day;
            this.hours = hours;
            this.minutes = minutes;
            this.seconds = seconds;
            this.isUtc = isUtc;
            this.rawValue = rawValue;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int flags) {
            zzc.zza(this, parcel, flags);
        }
    }

    public static class GeoPoint
    implements SafeParcelable {
        public static final zzh CREATOR = new zzh();
        final int versionCode;
        public double lat;
        public double lng;

        public GeoPoint() {
            this.versionCode = 1;
        }

        public GeoPoint(int versionCode, double lat, double lng) {
            this.versionCode = versionCode;
            this.lat = lat;
            this.lng = lng;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int flags) {
            zzh.zza(this, parcel, flags);
        }
    }

    public static class UrlBookmark
    implements SafeParcelable {
        public static final zzl CREATOR = new zzl();
        final int versionCode;
        public String title;
        public String url;

        public UrlBookmark() {
            this.versionCode = 1;
        }

        public UrlBookmark(int versionCode, String title, String url) {
            this.versionCode = versionCode;
            this.title = title;
            this.url = url;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int flags) {
            zzl.zza(this, parcel, flags);
        }
    }

    public static class WiFi
    implements SafeParcelable {
        public static final zzm CREATOR = new zzm();
        public static final int OPEN = 1;
        public static final int WPA = 2;
        public static final int WEP = 3;
        final int versionCode;
        public String ssid;
        public String password;
        public int encryptionType;

        public WiFi() {
            this.versionCode = 1;
        }

        public WiFi(int versionCode, String ssid, String password, int encryptionType) {
            this.versionCode = versionCode;
            this.ssid = ssid;
            this.password = password;
            this.encryptionType = encryptionType;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int flags) {
            zzm.zza(this, parcel, flags);
        }
    }

    public static class Sms
    implements SafeParcelable {
        public static final zzk CREATOR = new zzk();
        final int versionCode;
        public String message;
        public String phoneNumber;

        public Sms() {
            this.versionCode = 1;
        }

        public Sms(int versionCode, String message, String phoneNumber) {
            this.versionCode = versionCode;
            this.message = message;
            this.phoneNumber = phoneNumber;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int flags) {
            zzk.zza(this, parcel, flags);
        }
    }

    public static class Phone
    implements SafeParcelable {
        public static final zzj CREATOR = new zzj();
        public static final int UNKNOWN = 0;
        public static final int WORK = 1;
        public static final int HOME = 2;
        public static final int FAX = 3;
        public static final int MOBILE = 4;
        final int versionCode;
        public int type;
        public String number;

        public Phone() {
            this.versionCode = 1;
        }

        public Phone(int versionCode, int type, String number) {
            this.versionCode = versionCode;
            this.type = type;
            this.number = number;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int flags) {
            zzj.zza(this, parcel, flags);
        }
    }

    public static class Email
    implements SafeParcelable {
        public static final zzg CREATOR = new zzg();
        public static final int UNKNOWN = 0;
        public static final int WORK = 1;
        public static final int HOME = 2;
        final int versionCode;
        public int type;
        public String address;
        public String subject;
        public String body;

        public Email() {
            this.versionCode = 1;
        }

        public Email(int versionCode, int type, String address, String subject, String body) {
            this.versionCode = versionCode;
            this.type = type;
            this.address = address;
            this.subject = subject;
            this.body = body;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int flags) {
            zzg.zza(this, parcel, flags);
        }
    }
}

