/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.face.internal.client;

import android.content.Context;
import android.graphics.PointF;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzqi;
import com.google.android.gms.vision.face.Face;
import com.google.android.gms.vision.face.Landmark;
import com.google.android.gms.vision.face.internal.client.FaceParcel;
import com.google.android.gms.vision.face.internal.client.FaceSettingsParcel;
import com.google.android.gms.vision.face.internal.client.LandmarkParcel;
import com.google.android.gms.vision.face.internal.client.zzc;
import com.google.android.gms.vision.face.internal.client.zzd;
import com.google.android.gms.vision.internal.client.FrameMetadataParcel;
import java.nio.ByteBuffer;

public class zzf {
    private final Context mContext;
    private final FaceSettingsParcel zzbyi;
    private final Object zzpp = new Object();
    private zzc zzbyj = null;
    private boolean zzbxG = false;

    public zzf(Context context, FaceSettingsParcel faceSettingsParcel) {
        this.mContext = context;
        this.zzbyi = faceSettingsParcel;
        this.zzMY();
    }

    public Face[] zzb(ByteBuffer byteBuffer, FrameMetadataParcel frameMetadataParcel) {
        FaceParcel[] faceParcelArray;
        Face[] faceArray;
        if (!this.isOperational()) {
            return new Face[0];
        }
        try {
            faceArray = zze.zzD((Object)byteBuffer);
            faceParcelArray = this.zzMY().zzc((com.google.android.gms.dynamic.zzd)faceArray, frameMetadataParcel);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"FaceDetectorHandle", (String)"Could not call native face detector", (Throwable)remoteException);
            return new Face[0];
        }
        faceArray = new Face[faceParcelArray.length];
        for (int i = 0; i < faceParcelArray.length; ++i) {
            faceArray[i] = this.zza(faceParcelArray[i]);
        }
        return faceArray;
    }

    public boolean zzlx(int n) {
        if (!this.isOperational()) {
            return false;
        }
        try {
            return this.zzMY().zzlx(n);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"FaceDetectorHandle", (String)"Could not call native face detector", (Throwable)remoteException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzMW() {
        Object object = this.zzpp;
        synchronized (object) {
            if (this.zzbyj == null) {
                return;
            }
            try {
                this.zzbyj.zzMW();
            }
            catch (RemoteException remoteException) {
                Log.e((String)"FaceDetectorHandle", (String)"Could not finalize native face detector", (Throwable)remoteException);
            }
        }
    }

    public boolean isOperational() {
        return this.zzMY() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private zzc zzMY() {
        Object object = this.zzpp;
        synchronized (object) {
            if (this.zzbyj != null) {
                return this.zzbyj;
            }
            try {
                zzqi zzqi2 = zzqi.zza((Context)this.mContext, (zzqi.zzb)zzqi.zzaCr, (String)"com.google.android.gms.vision.dynamite");
                zzd zzd2 = zzd.zza.zzep(zzqi2.zzdM("com.google.android.gms.vision.face.ChimeraNativeFaceDetectorCreator"));
                com.google.android.gms.dynamic.zzd zzd3 = zze.zzD((Object)this.mContext);
                this.zzbyj = zzd2.zza(zzd3, this.zzbyi);
            }
            catch (RemoteException | zzqi.zza throwable) {
                Log.e((String)"FaceDetectorHandle", (String)"Error creating remote native face detector", (Throwable)throwable);
            }
            if (!this.zzbxG && this.zzbyj == null) {
                Log.w((String)"FaceDetectorHandle", (String)"Native face detector not yet available.  Reverting to no-op detection.");
                this.zzbxG = true;
            } else if (this.zzbxG && this.zzbyj != null) {
                Log.w((String)"FaceDetectorHandle", (String)"Native face detector is now available.");
            }
            return this.zzbyj;
        }
    }

    private Face zza(FaceParcel faceParcel) {
        return new Face(faceParcel.id, new PointF(faceParcel.centerX, faceParcel.centerY), faceParcel.width, faceParcel.height, faceParcel.zzbxX, faceParcel.zzbxY, this.zzb(faceParcel), faceParcel.zzbya, faceParcel.zzbyb, faceParcel.zzbyc);
    }

    private Landmark[] zzb(FaceParcel faceParcel) {
        Landmark[] landmarkArray;
        LandmarkParcel[] landmarkParcelArray = faceParcel.zzbxZ;
        if (landmarkParcelArray == null) {
            landmarkArray = new Landmark[]{};
        } else {
            landmarkArray = new Landmark[landmarkParcelArray.length];
            for (int i = 0; i < landmarkParcelArray.length; ++i) {
                landmarkArray[i] = this.zza(landmarkParcelArray[i]);
            }
        }
        return landmarkArray;
    }

    private Landmark zza(LandmarkParcel landmarkParcel) {
        return new Landmark(new PointF(landmarkParcel.x, landmarkParcel.y), landmarkParcel.type);
    }
}

