/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.ImageFormat;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.os.Build;
import android.os.SystemClock;
import android.support.annotation.RequiresPermission;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.WindowManager;
import com.google.android.gms.common.images.Size;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CameraSource {
    @SuppressLint(value={"InlinedApi"})
    public static final int CAMERA_FACING_BACK = 0;
    @SuppressLint(value={"InlinedApi"})
    public static final int CAMERA_FACING_FRONT = 1;
    private Context mContext;
    private final Object aDX = new Object();
    private Camera aDY;
    private int aDZ = 0;
    private int zzbrl;
    private Size aEa;
    private float aEb = 30.0f;
    private int aEc = 1024;
    private int aEd = 768;
    private boolean aEe = false;
    private SurfaceView aEf;
    private SurfaceTexture aEg;
    private boolean aEh;
    private Thread aEi;
    private zzb aEj;
    private Map<byte[], ByteBuffer> aEk = new HashMap<byte[], ByteBuffer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.aDX;
        synchronized (object) {
            this.stop();
            this.aEj.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.CAMERA")
    public CameraSource start() throws IOException {
        Object object = this.aDX;
        synchronized (object) {
            if (this.aDY != null) {
                return this;
            }
            this.aDY = this.zzchm();
            if (Build.VERSION.SDK_INT >= 11) {
                this.aEg = new SurfaceTexture(100);
                this.aDY.setPreviewTexture(this.aEg);
                this.aEh = true;
            } else {
                this.aEf = new SurfaceView(this.mContext);
                this.aDY.setPreviewDisplay(this.aEf.getHolder());
                this.aEh = false;
            }
            this.aDY.startPreview();
            this.aEi = new Thread(this.aEj);
            this.aEj.setActive(true);
            this.aEi.start();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.CAMERA")
    public CameraSource start(SurfaceHolder surfaceHolder) throws IOException {
        Object object = this.aDX;
        synchronized (object) {
            if (this.aDY != null) {
                return this;
            }
            this.aDY = this.zzchm();
            this.aDY.setPreviewDisplay(surfaceHolder);
            this.aDY.startPreview();
            this.aEi = new Thread(this.aEj);
            this.aEj.setActive(true);
            this.aEi.start();
            this.aEh = false;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.aDX;
        synchronized (object) {
            this.aEj.setActive(false);
            if (this.aEi != null) {
                try {
                    this.aEi.join();
                }
                catch (InterruptedException interruptedException) {
                    Log.d((String)"CameraSource", (String)"Frame processing thread interrupted on release.");
                }
                this.aEi = null;
            }
            if (this.aDY != null) {
                this.aDY.stopPreview();
                this.aDY.setPreviewCallbackWithBuffer(null);
                try {
                    if (this.aEh) {
                        this.aDY.setPreviewTexture(null);
                    } else {
                        this.aDY.setPreviewDisplay(null);
                    }
                }
                catch (Exception exception) {
                    String string = String.valueOf(exception);
                    Log.e((String)"CameraSource", (String)new StringBuilder(32 + String.valueOf(string).length()).append("Failed to clear camera preview: ").append(string).toString());
                }
                this.aDY.release();
                this.aDY = null;
            }
            this.aEk.clear();
        }
    }

    public Size getPreviewSize() {
        return this.aEa;
    }

    public int getCameraFacing() {
        return this.aDZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takePicture(ShutterCallback shutterCallback, PictureCallback pictureCallback) {
        Object object = this.aDX;
        synchronized (object) {
            if (this.aDY != null) {
                zzd zzd2 = new zzd();
                zzd2.aEt = shutterCallback;
                zzc zzc2 = new zzc();
                zzc2.aEs = pictureCallback;
                this.aDY.takePicture((Camera.ShutterCallback)zzd2, null, null, (Camera.PictureCallback)zzc2);
            }
        }
    }

    private CameraSource() {
    }

    @SuppressLint(value={"InlinedApi"})
    private Camera zzchm() {
        int n = CameraSource.zzym(this.aDZ);
        if (n == -1) {
            throw new RuntimeException("Could not find requested camera.");
        }
        Camera camera = Camera.open((int)n);
        zze zze2 = CameraSource.zza(camera, this.aEc, this.aEd);
        if (zze2 == null) {
            throw new RuntimeException("Could not find suitable preview size.");
        }
        Size size = zze2.zzcho();
        this.aEa = zze2.zzchn();
        int[] nArray = CameraSource.zza(camera, this.aEb);
        if (nArray == null) {
            throw new RuntimeException("Could not find suitable preview frames per second range.");
        }
        Camera.Parameters parameters = camera.getParameters();
        if (size != null) {
            parameters.setPictureSize(size.getWidth(), size.getHeight());
        }
        parameters.setPreviewSize(this.aEa.getWidth(), this.aEa.getHeight());
        parameters.setPreviewFpsRange(nArray[0], nArray[1]);
        parameters.setPreviewFormat(17);
        this.zza(camera, parameters, n);
        if (this.aEe) {
            if (parameters.getSupportedFocusModes().contains("continuous-video")) {
                parameters.setFocusMode("continuous-video");
            } else {
                Log.i((String)"CameraSource", (String)"Camera auto focus is not supported on this device.");
            }
        }
        camera.setParameters(parameters);
        camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)new zza());
        camera.addCallbackBuffer(this.zza(this.aEa));
        camera.addCallbackBuffer(this.zza(this.aEa));
        camera.addCallbackBuffer(this.zza(this.aEa));
        camera.addCallbackBuffer(this.zza(this.aEa));
        return camera;
    }

    private static int zzym(int n) {
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        for (int i = 0; i < Camera.getNumberOfCameras(); ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
            if (cameraInfo.facing != n) continue;
            return i;
        }
        return -1;
    }

    static zze zza(Camera camera, int n, int n2) {
        List<zze> list = CameraSource.zza(camera);
        zze zze2 = null;
        int n3 = Integer.MAX_VALUE;
        for (zze zze3 : list) {
            Size size = zze3.zzchn();
            int n4 = Math.abs(size.getWidth() - n) + Math.abs(size.getHeight() - n2);
            if (n4 >= n3) continue;
            zze2 = zze3;
            n3 = n4;
        }
        return zze2;
    }

    static List<zze> zza(Camera camera) {
        Camera.Parameters parameters = camera.getParameters();
        List list = parameters.getSupportedPreviewSizes();
        List list2 = parameters.getSupportedPictureSizes();
        ArrayList<zze> arrayList = new ArrayList<zze>();
        block0: for (Camera.Size size : list) {
            float f = (float)size.width / (float)size.height;
            for (Camera.Size size2 : list2) {
                float f2 = (float)size2.width / (float)size2.height;
                if (!(Math.abs(f - f2) < 0.01f)) continue;
                arrayList.add(new zze(size, size2));
                continue block0;
            }
        }
        if (arrayList.size() == 0) {
            Log.w((String)"CameraSource", (String)"No preview sizes have a corresponding same-aspect-ratio picture size");
            for (Camera.Size size : list) {
                arrayList.add(new zze(size, null));
            }
        }
        return arrayList;
    }

    @SuppressLint(value={"InlinedApi"})
    static int[] zza(Camera camera, float f) {
        int n = (int)(f * 1000.0f);
        int[] nArray = null;
        int n2 = Integer.MAX_VALUE;
        List list = camera.getParameters().getSupportedPreviewFpsRange();
        for (int[] nArray2 : list) {
            int n3 = n - nArray2[0];
            int n4 = n - nArray2[1];
            int n5 = Math.abs(n3) + Math.abs(n4);
            if (n5 >= n2) continue;
            nArray = nArray2;
            n2 = n5;
        }
        return nArray;
    }

    private void zza(Camera camera, Camera.Parameters parameters, int n) {
        int n2;
        int n3;
        WindowManager windowManager = (WindowManager)this.mContext.getSystemService("window");
        int n4 = 0;
        int n5 = windowManager.getDefaultDisplay().getRotation();
        switch (n5) {
            case 0: {
                n4 = 0;
                break;
            }
            case 1: {
                n4 = 90;
                break;
            }
            case 2: {
                n4 = 180;
                break;
            }
            case 3: {
                n4 = 270;
                break;
            }
            default: {
                Log.e((String)"CameraSource", (String)new StringBuilder(31).append("Bad rotation value: ").append(n5).toString());
            }
        }
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)n, (Camera.CameraInfo)cameraInfo);
        if (cameraInfo.facing == 1) {
            n3 = (cameraInfo.orientation + n4) % 360;
            n2 = (360 - n3) % 360;
        } else {
            n2 = n3 = (cameraInfo.orientation - n4 + 360) % 360;
        }
        this.zzbrl = n3 / 90;
        camera.setDisplayOrientation(n2);
        parameters.setRotation(n3);
    }

    @SuppressLint(value={"InlinedApi"})
    private byte[] zza(Size size) {
        int n = ImageFormat.getBitsPerPixel((int)17);
        long l = size.getHeight() * size.getWidth() * n;
        int n2 = (int)Math.ceil((double)l / 8.0) + 1;
        byte[] byArray = new byte[n2];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        if (!byteBuffer.hasArray() || byteBuffer.array() != byArray) {
            throw new IllegalStateException("Failed to create valid buffer for camera source.");
        }
        this.aEk.put(byArray, byteBuffer);
        return byArray;
    }

    private class zzb
    implements Runnable {
        private Detector<?> aEl;
        private long zzczk = SystemClock.elapsedRealtime();
        private final Object zzail = new Object();
        private boolean aEo = true;
        private long aEp;
        private int aEq = 0;
        private ByteBuffer aEr;

        zzb(Detector<?> detector) {
            this.aEl = detector;
        }

        @SuppressLint(value={"Assert"})
        void release() {
            assert (CameraSource.this.aEi.getState() == Thread.State.TERMINATED);
            this.aEl.release();
            this.aEl = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setActive(boolean bl) {
            Object object = this.zzail;
            synchronized (object) {
                this.aEo = bl;
                this.zzail.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void zza(byte[] byArray, Camera camera) {
            Object object = this.zzail;
            synchronized (object) {
                if (this.aEr != null) {
                    camera.addCallbackBuffer(this.aEr.array());
                    this.aEr = null;
                }
                if (!CameraSource.this.aEk.containsKey(byArray)) {
                    Log.d((String)"CameraSource", (String)"Skipping frame. Could not find ByteBuffer associated with the image data from the camera.");
                    return;
                }
                this.aEp = SystemClock.elapsedRealtime() - this.zzczk;
                ++this.aEq;
                this.aEr = (ByteBuffer)CameraSource.this.aEk.get(byArray);
                this.zzail.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @SuppressLint(value={"InlinedApi"})
        public void run() {
            while (true) {
                ByteBuffer byteBuffer;
                Frame frame;
                Object object = this.zzail;
                synchronized (object) {
                    while (this.aEo && this.aEr == null) {
                        try {
                            this.zzail.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            Log.d((String)"CameraSource", (String)"Frame processing loop terminated.", (Throwable)interruptedException);
                            return;
                        }
                    }
                    if (!this.aEo) {
                        return;
                    }
                    frame = new Frame.Builder().setImageData(this.aEr, CameraSource.this.aEa.getWidth(), CameraSource.this.aEa.getHeight(), 17).setId(this.aEq).setTimestampMillis(this.aEp).setRotation(CameraSource.this.zzbrl).build();
                    byteBuffer = this.aEr;
                    this.aEr = null;
                }
                try {
                    this.aEl.receiveFrame(frame);
                    continue;
                }
                catch (Throwable throwable) {
                    Log.e((String)"CameraSource", (String)"Exception thrown from receiver.", (Throwable)throwable);
                    continue;
                }
                finally {
                    CameraSource.this.aDY.addCallbackBuffer(byteBuffer.array());
                    continue;
                }
                break;
            }
        }
    }

    private class zza
    implements Camera.PreviewCallback {
        private zza() {
        }

        public void onPreviewFrame(byte[] byArray, Camera camera) {
            CameraSource.this.aEj.zza(byArray, camera);
        }
    }

    static class zze {
        private Size aEu;
        private Size aEv;

        public zze(Camera.Size size, Camera.Size size2) {
            this.aEu = new Size(size.width, size.height);
            if (size2 != null) {
                this.aEv = new Size(size2.width, size2.height);
            }
        }

        public Size zzchn() {
            return this.aEu;
        }

        public Size zzcho() {
            return this.aEv;
        }
    }

    private class zzc
    implements Camera.PictureCallback {
        private PictureCallback aEs;

        private zzc() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onPictureTaken(byte[] byArray, Camera camera) {
            if (this.aEs != null) {
                this.aEs.onPictureTaken(byArray);
            }
            Object object = CameraSource.this.aDX;
            synchronized (object) {
                if (CameraSource.this.aDY != null) {
                    CameraSource.this.aDY.startPreview();
                }
            }
        }
    }

    private class zzd
    implements Camera.ShutterCallback {
        private ShutterCallback aEt;

        private zzd() {
        }

        public void onShutter() {
            if (this.aEt != null) {
                this.aEt.onShutter();
            }
        }
    }

    public static interface PictureCallback {
        public void onPictureTaken(byte[] var1);
    }

    public static interface ShutterCallback {
        public void onShutter();
    }

    public static class Builder {
        private final Detector<?> aEl;
        private CameraSource aEm = new CameraSource();

        public Builder(Context context, Detector<?> detector) {
            if (context == null) {
                throw new IllegalArgumentException("No context supplied.");
            }
            if (detector == null) {
                throw new IllegalArgumentException("No detector supplied.");
            }
            this.aEl = detector;
            this.aEm.mContext = context;
        }

        public Builder setRequestedFps(float f) {
            if (f <= 0.0f) {
                throw new IllegalArgumentException(new StringBuilder(28).append("Invalid fps: ").append(f).toString());
            }
            this.aEm.aEb = f;
            return this;
        }

        public Builder setRequestedPreviewSize(int n, int n2) {
            int n3 = 1000000;
            if (n <= 0 || n > 1000000 || n2 <= 0 || n2 > 1000000) {
                throw new IllegalArgumentException(new StringBuilder(45).append("Invalid preview size: ").append(n).append("x").append(n2).toString());
            }
            this.aEm.aEc = n;
            this.aEm.aEd = n2;
            return this;
        }

        public Builder setFacing(int n) {
            if (n != 0 && n != 1) {
                throw new IllegalArgumentException(new StringBuilder(27).append("Invalid camera: ").append(n).toString());
            }
            this.aEm.aDZ = n;
            return this;
        }

        public Builder setAutoFocusEnabled(boolean bl) {
            this.aEm.aEe = bl;
            return this;
        }

        public CameraSource build() {
            CameraSource cameraSource = this.aEm;
            cameraSource.getClass();
            this.aEm.aEj = cameraSource.new zzb(this.aEl);
            return this.aEm;
        }
    }
}

