/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.SparseArray;
import com.google.android.gms.vision.Frame;

public abstract class Detector<T> {
    private Object aEw = new Object();
    private Processor<T> aEx;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.aEw;
        synchronized (object) {
            if (this.aEx != null) {
                this.aEx.release();
                this.aEx = null;
            }
        }
    }

    public abstract SparseArray<T> detect(Frame var1);

    public boolean setFocus(int n) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveFrame(Frame frame) {
        Object object = this.aEw;
        synchronized (object) {
            if (this.aEx == null) {
                throw new IllegalStateException("Detector processor must first be set with setProcessor in order to receive detection results.");
            }
            Frame.Metadata metadata = new Frame.Metadata(frame.getMetadata());
            metadata.zzchq();
            SparseArray<T> sparseArray = this.detect(frame);
            boolean bl = this.isOperational();
            Detections<T> detections = new Detections<T>(sparseArray, metadata, bl);
            this.aEx.receiveDetections(detections);
        }
    }

    public void setProcessor(Processor<T> processor) {
        this.aEx = processor;
    }

    public boolean isOperational() {
        return true;
    }

    public static interface Processor<T> {
        public void release();

        public void receiveDetections(Detections<T> var1);
    }

    public static class Detections<T> {
        private SparseArray<T> aEy;
        private Frame.Metadata aEz;
        private boolean aEA;

        public Detections(SparseArray<T> sparseArray, Frame.Metadata metadata, boolean bl) {
            this.aEy = sparseArray;
            this.aEz = metadata;
            this.aEA = bl;
        }

        public SparseArray<T> getDetectedItems() {
            return this.aEy;
        }

        public Frame.Metadata getFrameMetadata() {
            return this.aEz;
        }

        public boolean detectorIsOperational() {
            return this.aEA;
        }
    }
}

