/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.SparseArray;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Tracker;
import java.util.HashSet;

public class MultiProcessor<T>
implements Detector.Processor<T> {
    private Factory<T> aEO;
    private SparseArray<zza> aEP = new SparseArray();
    private int aEC = 3;

    @Override
    public void release() {
        for (int i = 0; i < this.aEP.size(); ++i) {
            Tracker tracker = ((zza)this.aEP.valueAt(i)).aEB;
            tracker.onDone();
        }
        this.aEP.clear();
    }

    @Override
    public void receiveDetections(Detector.Detections<T> detections) {
        this.zza(detections);
        this.zzb(detections);
        this.zzc(detections);
    }

    private MultiProcessor() {
    }

    private void zza(Detector.Detections<T> detections) {
        SparseArray<T> sparseArray = detections.getDetectedItems();
        for (int i = 0; i < sparseArray.size(); ++i) {
            int n = sparseArray.keyAt(i);
            Object object = sparseArray.valueAt(i);
            if (this.aEP.get(n) != null) continue;
            zza zza2 = new zza();
            zza2.aEB = this.aEO.create(object);
            zza2.aEB.onNewItem(n, object);
            this.aEP.append(n, (Object)zza2);
        }
    }

    private void zzb(Detector.Detections<T> detections) {
        SparseArray<T> sparseArray = detections.getDetectedItems();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = 0; i < this.aEP.size(); ++i) {
            int n = this.aEP.keyAt(i);
            if (sparseArray.get(n) != null) continue;
            zza zza2 = (zza)this.aEP.valueAt(i);
            zza2.aEF++;
            if (zza2.aEF >= this.aEC) {
                zza2.aEB.onDone();
                hashSet.add(n);
                continue;
            }
            zza2.aEB.onMissing(detections);
        }
        for (Integer n : hashSet) {
            this.aEP.delete(n.intValue());
        }
    }

    private void zzc(Detector.Detections<T> detections) {
        SparseArray<T> sparseArray = detections.getDetectedItems();
        for (int i = 0; i < sparseArray.size(); ++i) {
            int n = sparseArray.keyAt(i);
            Object object = sparseArray.valueAt(i);
            zza zza2 = (zza)this.aEP.get(n);
            zza2.aEF = 0;
            zza2.aEB.onUpdate(detections, object);
        }
    }

    private class zza {
        private Tracker<T> aEB;
        private int aEF = 0;

        private zza() {
        }
    }

    public static class Builder<T> {
        private MultiProcessor<T> aEQ = new MultiProcessor();

        public Builder(Factory<T> factory) {
            if (factory == null) {
                throw new IllegalArgumentException("No factory supplied.");
            }
            ((MultiProcessor)this.aEQ).aEO = factory;
        }

        public Builder<T> setMaxGapFrames(int n) {
            if (n < 0) {
                throw new IllegalArgumentException(new StringBuilder(28).append("Invalid max gap: ").append(n).toString());
            }
            ((MultiProcessor)this.aEQ).aEC = n;
            return this;
        }

        public MultiProcessor<T> build() {
            return this.aEQ;
        }
    }

    public static interface Factory<T> {
        public Tracker<T> create(T var1);
    }
}

