/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.barcode.internal.client;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzsb;
import com.google.android.gms.vision.barcode.Barcode;
import com.google.android.gms.vision.barcode.internal.client.BarcodeDetectorOptions;
import com.google.android.gms.vision.barcode.internal.client.zzb;
import com.google.android.gms.vision.barcode.internal.client.zzc;
import com.google.android.gms.vision.internal.client.FrameMetadataParcel;
import java.nio.ByteBuffer;

public class zzd {
    private final Context mContext;
    private final BarcodeDetectorOptions aEz;
    private final Object zzail = new Object();
    private zzb aEB = null;
    private boolean aEC = false;

    public zzd(Context context, BarcodeDetectorOptions barcodeDetectorOptions) {
        this.mContext = context;
        this.aEz = barcodeDetectorOptions;
        this.zzchw();
    }

    public Barcode[] zza(ByteBuffer byteBuffer, FrameMetadataParcel frameMetadataParcel) {
        if (!this.isOperational()) {
            return new Barcode[0];
        }
        try {
            com.google.android.gms.dynamic.zzd zzd2 = zze.zzac((Object)byteBuffer);
            return this.zzchw().zza(zzd2, frameMetadataParcel);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"NativeBarcodeDetectorHandle", (String)"Error calling native barcode detector", (Throwable)remoteException);
            return new Barcode[0];
        }
    }

    public Barcode[] zza(Bitmap bitmap, FrameMetadataParcel frameMetadataParcel) {
        if (!this.isOperational()) {
            return new Barcode[0];
        }
        try {
            com.google.android.gms.dynamic.zzd zzd2 = zze.zzac((Object)bitmap);
            return this.zzchw().zzb(zzd2, frameMetadataParcel);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"NativeBarcodeDetectorHandle", (String)"Error calling native barcode detector", (Throwable)remoteException);
            return new Barcode[0];
        }
    }

    public boolean isOperational() {
        return this.zzchw() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private zzb zzchw() {
        Object object = this.zzail;
        synchronized (object) {
            if (this.aEB != null) {
                return this.aEB;
            }
            try {
                zzsb zzsb2 = zzsb.zza((Context)this.mContext, (zzsb.zzb)zzsb.KL, (String)"com.google.android.gms.vision.dynamite");
                zzc zzc2 = zzc.zza.zzle(zzsb2.zziu("com.google.android.gms.vision.barcode.ChimeraNativeBarcodeDetectorCreator"));
                com.google.android.gms.dynamic.zzd zzd2 = zze.zzac((Object)this.mContext);
                this.aEB = zzc2.zza(zzd2, this.aEz);
            }
            catch (RemoteException | zzsb.zza throwable) {
                Log.e((String)"NativeBarcodeDetectorHandle", (String)"Error creating remote native barcode detector", (Throwable)throwable);
            }
            if (!this.aEC && this.aEB == null) {
                Log.w((String)"NativeBarcodeDetectorHandle", (String)"Native barcode detector not yet available.  Reverting to no-op detection.");
                this.aEC = true;
            } else if (this.aEC && this.aEB != null) {
                Log.w((String)"NativeBarcodeDetectorHandle", (String)"Native barcode detector is now available.");
            }
            return this.aEB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzchv() {
        Object object = this.zzail;
        synchronized (object) {
            if (this.aEB == null) {
                return;
            }
            try {
                this.aEB.zzchv();
            }
            catch (RemoteException remoteException) {
                Log.e((String)"NativeBarcodeDetectorHandle", (String)"Could not finalize native barcode detector", (Throwable)remoteException);
            }
        }
    }
}

