/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.face;

import android.util.SparseArray;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.FocusingProcessor;
import com.google.android.gms.vision.Tracker;
import com.google.android.gms.vision.face.Face;

public class LargestFaceFocusingProcessor
extends FocusingProcessor<Face> {
    public LargestFaceFocusingProcessor(Detector<Face> detector, Tracker<Face> tracker) {
        super(detector, tracker);
    }

    @Override
    public int selectFocus(Detector.Detections<Face> detections) {
        SparseArray<Face> sparseArray = detections.getDetectedItems();
        if (sparseArray.size() == 0) {
            throw new IllegalArgumentException("No faces for selectFocus.");
        }
        int n = sparseArray.keyAt(0);
        float f = ((Face)sparseArray.valueAt(0)).getWidth();
        for (int i = 1; i < sparseArray.size(); ++i) {
            int n2 = sparseArray.keyAt(i);
            Face face = (Face)sparseArray.valueAt(i);
            float f2 = face.getWidth();
            if (!(f2 > f)) continue;
            n = n2;
            f = f2;
        }
        return n;
    }

    public static class Builder {
        private LargestFaceFocusingProcessor aES;

        public Builder(Detector<Face> detector, Tracker<Face> tracker) {
            this.aES = new LargestFaceFocusingProcessor(detector, tracker);
        }

        public Builder setMaxGapFrames(int n) {
            this.aES.zzzv(n);
            return this;
        }

        public LargestFaceFocusingProcessor build() {
            return this.aES;
        }
    }
}

