/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.SparseArray;
import com.google.android.gms.vision.Frame;

public abstract class Detector<T> {
    private Object aNB = new Object();
    private Processor<T> aNC;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.aNB;
        synchronized (object) {
            if (this.aNC != null) {
                this.aNC.release();
                this.aNC = null;
            }
        }
    }

    public abstract SparseArray<T> detect(Frame var1);

    public boolean setFocus(int n) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveFrame(Frame frame) {
        Object object = this.aNB;
        synchronized (object) {
            if (this.aNC == null) {
                throw new IllegalStateException("Detector processor must first be set with setProcessor in order to receive detection results.");
            }
            Frame.Metadata metadata = new Frame.Metadata(frame.getMetadata());
            metadata.zzclo();
            SparseArray<T> sparseArray = this.detect(frame);
            boolean bl = this.isOperational();
            Detections<T> detections = new Detections<T>(sparseArray, metadata, bl);
            this.aNC.receiveDetections(detections);
        }
    }

    public void setProcessor(Processor<T> processor) {
        this.aNC = processor;
    }

    public boolean isOperational() {
        return true;
    }

    public static interface Processor<T> {
        public void release();

        public void receiveDetections(Detections<T> var1);
    }

    public static class Detections<T> {
        private SparseArray<T> aND;
        private Frame.Metadata aNE;
        private boolean aNF;

        public Detections(SparseArray<T> sparseArray, Frame.Metadata metadata, boolean bl) {
            this.aND = sparseArray;
            this.aNE = metadata;
            this.aNF = bl;
        }

        public SparseArray<T> getDetectedItems() {
            return this.aND;
        }

        public Frame.Metadata getFrameMetadata() {
            return this.aNE;
        }

        public boolean detectorIsOperational() {
            return this.aNF;
        }
    }
}

