/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Tracker;

public abstract class FocusingProcessor<T>
implements Detector.Processor<T> {
    private Detector<T> aNq;
    private Tracker<T> aNG;
    private int aNH = 3;
    private boolean aNI = false;
    private int aNJ;
    private int aNK = 0;

    public FocusingProcessor(Detector<T> detector, Tracker<T> tracker) {
        this.aNq = detector;
        this.aNG = tracker;
    }

    @Override
    public void release() {
        this.aNG.onDone();
    }

    @Override
    public void receiveDetections(Detector.Detections<T> detections) {
        int n;
        Object object;
        SparseArray<T> sparseArray = detections.getDetectedItems();
        if (sparseArray.size() == 0) {
            if (this.aNK == this.aNH) {
                this.aNG.onDone();
                this.aNI = false;
            } else {
                this.aNG.onMissing(detections);
            }
            ++this.aNK;
            return;
        }
        this.aNK = 0;
        if (this.aNI) {
            Object object2 = sparseArray.get(this.aNJ);
            if (object2 != null) {
                this.aNG.onUpdate(detections, object2);
                return;
            }
            this.aNG.onDone();
            this.aNI = false;
        }
        if ((object = sparseArray.get(n = this.selectFocus(detections))) == null) {
            Log.w((String)"FocusingProcessor", (String)new StringBuilder(35).append("Invalid focus selected: ").append(n).toString());
            return;
        }
        this.aNI = true;
        this.aNJ = n;
        this.aNq.setFocus(this.aNJ);
        this.aNG.onNewItem(this.aNJ, object);
        this.aNG.onUpdate(detections, object);
    }

    public abstract int selectFocus(Detector.Detections<T> var1);

    protected void zzaaq(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(new StringBuilder(28).append("Invalid max gap: ").append(n).toString());
        }
        this.aNH = n;
    }
}

