/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.graphics.Bitmap;
import android.graphics.Color;
import java.nio.ByteBuffer;

public class Frame {
    public static final int ROTATION_0 = 0;
    public static final int ROTATION_90 = 1;
    public static final int ROTATION_180 = 2;
    public static final int ROTATION_270 = 3;
    private Metadata aNL = new Metadata();
    private ByteBuffer aNM = null;
    private Bitmap mBitmap = null;

    public Metadata getMetadata() {
        return this.aNL;
    }

    public ByteBuffer getGrayscaleImageData() {
        if (this.mBitmap != null) {
            return this.zzcln();
        }
        return this.aNM;
    }

    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    private Frame() {
    }

    private ByteBuffer zzcln() {
        int n = this.mBitmap.getWidth();
        int n2 = this.mBitmap.getHeight();
        int[] nArray = new int[n * n2];
        this.mBitmap.getPixels(nArray, 0, n, 0, 0, n, n2);
        byte[] byArray = new byte[n * n2];
        for (int i = 0; i < nArray.length; ++i) {
            byArray[i] = (byte)((float)Color.red((int)nArray[i]) * 0.299f + (float)Color.green((int)nArray[i]) * 0.587f + (float)Color.blue((int)nArray[i]) * 0.114f);
        }
        return ByteBuffer.wrap(byArray);
    }

    public static class Metadata {
        private int zzakh;
        private int zzaki;
        private int mId;
        private long aeh;
        private int zzbzf;
        private int format = -1;

        public Metadata() {
        }

        public Metadata(Metadata metadata) {
            this.zzakh = metadata.getWidth();
            this.zzaki = metadata.getHeight();
            this.mId = metadata.getId();
            this.aeh = metadata.getTimestampMillis();
            this.zzbzf = metadata.getRotation();
        }

        public int getWidth() {
            return this.zzakh;
        }

        public int getHeight() {
            return this.zzaki;
        }

        public int getId() {
            return this.mId;
        }

        public long getTimestampMillis() {
            return this.aeh;
        }

        public int getRotation() {
            return this.zzbzf;
        }

        public int getFormat() {
            return this.format;
        }

        public void zzclo() {
            if (this.zzbzf % 2 != 0) {
                int n = this.zzakh;
                this.zzakh = this.zzaki;
                this.zzaki = n;
            }
            this.zzbzf = 0;
        }
    }

    public static class Builder {
        private Frame aNN = new Frame();

        public Builder setBitmap(Bitmap bitmap) {
            int n = bitmap.getWidth();
            int n2 = bitmap.getHeight();
            this.aNN.mBitmap = bitmap;
            Metadata metadata = this.aNN.getMetadata();
            metadata.zzakh = n;
            metadata.zzaki = n2;
            return this;
        }

        public Builder setImageData(ByteBuffer byteBuffer, int n, int n2, int n3) {
            if (byteBuffer == null) {
                throw new IllegalArgumentException("Null image data supplied.");
            }
            if (byteBuffer.capacity() < n * n2) {
                throw new IllegalArgumentException("Invalid image data size.");
            }
            switch (n3) {
                case 16: 
                case 17: 
                case 842094169: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new StringBuilder(37).append("Unsupported image format: ").append(n3).toString());
                }
            }
            this.aNN.aNM = byteBuffer;
            Metadata metadata = this.aNN.getMetadata();
            metadata.zzakh = n;
            metadata.zzaki = n2;
            metadata.format = n3;
            return this;
        }

        public Builder setId(int n) {
            this.aNN.getMetadata().mId = n;
            return this;
        }

        public Builder setTimestampMillis(long l) {
            this.aNN.getMetadata().aeh = l;
            return this;
        }

        public Builder setRotation(int n) {
            this.aNN.getMetadata().zzbzf = n;
            return this;
        }

        public Frame build() {
            if (this.aNN.aNM == null && this.aNN.mBitmap == null) {
                throw new IllegalStateException("Missing image data.  Call either setBitmap or setImageData to specify the image");
            }
            return this.aNN;
        }
    }
}

