/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.barcode;

import android.graphics.Point;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.vision.barcode.zza;
import com.google.android.gms.vision.barcode.zzb;
import com.google.android.gms.vision.barcode.zzc;
import com.google.android.gms.vision.barcode.zzd;
import com.google.android.gms.vision.barcode.zze;
import com.google.android.gms.vision.barcode.zzf;
import com.google.android.gms.vision.barcode.zzg;
import com.google.android.gms.vision.barcode.zzh;
import com.google.android.gms.vision.barcode.zzi;
import com.google.android.gms.vision.barcode.zzj;
import com.google.android.gms.vision.barcode.zzk;
import com.google.android.gms.vision.barcode.zzl;
import com.google.android.gms.vision.barcode.zzm;

public class Barcode
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<Barcode> CREATOR = new zzb();
    public static final int ALL_FORMATS = 0;
    public static final int CODE_128 = 1;
    public static final int CODE_39 = 2;
    public static final int CODE_93 = 4;
    public static final int CODABAR = 8;
    public static final int DATA_MATRIX = 16;
    public static final int EAN_13 = 32;
    public static final int EAN_8 = 64;
    public static final int ITF = 128;
    public static final int QR_CODE = 256;
    public static final int UPC_A = 512;
    public static final int UPC_E = 1024;
    public static final int PDF417 = 2048;
    public static final int AZTEC = 4096;
    public static final int CONTACT_INFO = 1;
    public static final int EMAIL = 2;
    public static final int ISBN = 3;
    public static final int PHONE = 4;
    public static final int PRODUCT = 5;
    public static final int SMS = 6;
    public static final int TEXT = 7;
    public static final int URL = 8;
    public static final int WIFI = 9;
    public static final int GEO = 10;
    public static final int CALENDAR_EVENT = 11;
    public static final int DRIVER_LICENSE = 12;
    final int versionCode;
    public int format;
    public String rawValue;
    public String displayValue;
    public int valueFormat;
    public Point[] cornerPoints;
    public Email email;
    public Phone phone;
    public Sms sms;
    public WiFi wifi;
    public UrlBookmark url;
    public GeoPoint geoPoint;
    public CalendarEvent calendarEvent;
    public ContactInfo contactInfo;
    public DriverLicense driverLicense;

    public Barcode() {
        this.versionCode = 1;
    }

    public Barcode(int n, int n2, String string, String string2, int n3, Point[] pointArray, Email email, Phone phone, Sms sms, WiFi wiFi, UrlBookmark urlBookmark, GeoPoint geoPoint, CalendarEvent calendarEvent, ContactInfo contactInfo, DriverLicense driverLicense) {
        this.versionCode = n;
        this.format = n2;
        this.rawValue = string;
        this.displayValue = string2;
        this.valueFormat = n3;
        this.cornerPoints = pointArray;
        this.email = email;
        this.phone = phone;
        this.sms = sms;
        this.wifi = wiFi;
        this.url = urlBookmark;
        this.geoPoint = geoPoint;
        this.calendarEvent = calendarEvent;
        this.contactInfo = contactInfo;
        this.driverLicense = driverLicense;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzb.zza(this, parcel, n);
    }

    public Rect getBoundingBox() {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        for (int i = 0; i < this.cornerPoints.length; ++i) {
            Point point = this.cornerPoints[i];
            n = Math.min(n, point.x);
            n2 = Math.max(n2, point.x);
            n3 = Math.min(n3, point.y);
            n4 = Math.max(n4, point.y);
        }
        return new Rect(n, n3, n2, n4);
    }

    public static class DriverLicense
    extends AbstractSafeParcelable {
        public static final Parcelable.Creator<DriverLicense> CREATOR = new zzf();
        final int versionCode;
        public String documentType;
        public String firstName;
        public String middleName;
        public String lastName;
        public String gender;
        public String addressStreet;
        public String addressCity;
        public String addressState;
        public String addressZip;
        public String licenseNumber;
        public String issueDate;
        public String expiryDate;
        public String birthDate;
        public String issuingCountry;

        public DriverLicense() {
            this.versionCode = 1;
        }

        public DriverLicense(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14) {
            this.versionCode = n;
            this.documentType = string;
            this.firstName = string2;
            this.middleName = string3;
            this.lastName = string4;
            this.gender = string5;
            this.addressStreet = string6;
            this.addressCity = string7;
            this.addressState = string8;
            this.addressZip = string9;
            this.licenseNumber = string10;
            this.issueDate = string11;
            this.expiryDate = string12;
            this.birthDate = string13;
            this.issuingCountry = string14;
        }

        public void writeToParcel(Parcel parcel, int n) {
            zzf.zza(this, parcel, n);
        }
    }

    public static class ContactInfo
    extends AbstractSafeParcelable {
        public static final Parcelable.Creator<ContactInfo> CREATOR = new zze();
        final int versionCode;
        public PersonName name;
        public String organization;
        public String title;
        public Phone[] phones;
        public Email[] emails;
        public String[] urls;
        public Address[] addresses;

        public ContactInfo() {
            this.versionCode = 1;
        }

        public ContactInfo(int n, PersonName personName, String string, String string2, Phone[] phoneArray, Email[] emailArray, String[] stringArray, Address[] addressArray) {
            this.versionCode = n;
            this.name = personName;
            this.organization = string;
            this.title = string2;
            this.phones = phoneArray;
            this.emails = emailArray;
            this.urls = stringArray;
            this.addresses = addressArray;
        }

        public void writeToParcel(Parcel parcel, int n) {
            zze.zza(this, parcel, n);
        }
    }

    public static class Address
    extends AbstractSafeParcelable {
        public static final Parcelable.Creator<Address> CREATOR = new zza();
        final int versionCode;
        public static final int UNKNOWN = 0;
        public static final int WORK = 1;
        public static final int HOME = 2;
        public int type;
        public String[] addressLines;

        public Address() {
            this.versionCode = 1;
        }

        public Address(int n, int n2, String[] stringArray) {
            this.versionCode = n;
            this.type = n2;
            this.addressLines = stringArray;
        }

        public void writeToParcel(Parcel parcel, int n) {
            zza.zza(this, parcel, n);
        }
    }

    public static class PersonName
    extends AbstractSafeParcelable {
        public static final Parcelable.Creator<PersonName> CREATOR = new zzi();
        final int versionCode;
        public String formattedName;
        public String pronunciation;
        public String prefix;
        public String first;
        public String middle;
        public String last;
        public String suffix;

        public PersonName() {
            this.versionCode = 1;
        }

        public PersonName(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
            this.versionCode = n;
            this.formattedName = string;
            this.pronunciation = string2;
            this.prefix = string3;
            this.first = string4;
            this.middle = string5;
            this.last = string6;
            this.suffix = string7;
        }

        public void writeToParcel(Parcel parcel, int n) {
            zzi.zza(this, parcel, n);
        }
    }

    public static class CalendarEvent
    extends AbstractSafeParcelable {
        public static final Parcelable.Creator<CalendarEvent> CREATOR = new zzd();
        final int versionCode;
        public String summary;
        public String description;
        public String location;
        public String organizer;
        public String status;
        public CalendarDateTime start;
        public CalendarDateTime end;

        public CalendarEvent() {
            this.versionCode = 1;
        }

        public CalendarEvent(int n, String string, String string2, String string3, String string4, String string5, CalendarDateTime calendarDateTime, CalendarDateTime calendarDateTime2) {
            this.versionCode = n;
            this.summary = string;
            this.description = string2;
            this.location = string3;
            this.organizer = string4;
            this.status = string5;
            this.start = calendarDateTime;
            this.end = calendarDateTime2;
        }

        public void writeToParcel(Parcel parcel, int n) {
            zzd.zza(this, parcel, n);
        }
    }

    public static class CalendarDateTime
    extends AbstractSafeParcelable {
        public static final Parcelable.Creator<CalendarDateTime> CREATOR = new zzc();
        final int versionCode;
        public int year;
        public int month;
        public int day;
        public int hours;
        public int minutes;
        public int seconds;
        public boolean isUtc;
        public String rawValue;

        public CalendarDateTime() {
            this.versionCode = 1;
        }

        public CalendarDateTime(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, String string) {
            this.versionCode = n;
            this.year = n2;
            this.month = n3;
            this.day = n4;
            this.hours = n5;
            this.minutes = n6;
            this.seconds = n7;
            this.isUtc = bl;
            this.rawValue = string;
        }

        public void writeToParcel(Parcel parcel, int n) {
            zzc.zza(this, parcel, n);
        }
    }

    public static class GeoPoint
    extends AbstractSafeParcelable {
        public static final Parcelable.Creator<GeoPoint> CREATOR = new zzh();
        final int versionCode;
        public double lat;
        public double lng;

        public GeoPoint() {
            this.versionCode = 1;
        }

        public GeoPoint(int n, double d, double d2) {
            this.versionCode = n;
            this.lat = d;
            this.lng = d2;
        }

        public void writeToParcel(Parcel parcel, int n) {
            zzh.zza(this, parcel, n);
        }
    }

    public static class UrlBookmark
    extends AbstractSafeParcelable {
        public static final Parcelable.Creator<UrlBookmark> CREATOR = new zzl();
        final int versionCode;
        public String title;
        public String url;

        public UrlBookmark() {
            this.versionCode = 1;
        }

        public UrlBookmark(int n, String string, String string2) {
            this.versionCode = n;
            this.title = string;
            this.url = string2;
        }

        public void writeToParcel(Parcel parcel, int n) {
            zzl.zza(this, parcel, n);
        }
    }

    public static class WiFi
    extends AbstractSafeParcelable {
        public static final Parcelable.Creator<WiFi> CREATOR = new zzm();
        public static final int OPEN = 1;
        public static final int WPA = 2;
        public static final int WEP = 3;
        final int versionCode;
        public String ssid;
        public String password;
        public int encryptionType;

        public WiFi() {
            this.versionCode = 1;
        }

        public WiFi(int n, String string, String string2, int n2) {
            this.versionCode = n;
            this.ssid = string;
            this.password = string2;
            this.encryptionType = n2;
        }

        public void writeToParcel(Parcel parcel, int n) {
            zzm.zza(this, parcel, n);
        }
    }

    public static class Sms
    extends AbstractSafeParcelable {
        public static final Parcelable.Creator<Sms> CREATOR = new zzk();
        final int versionCode;
        public String message;
        public String phoneNumber;

        public Sms() {
            this.versionCode = 1;
        }

        public Sms(int n, String string, String string2) {
            this.versionCode = n;
            this.message = string;
            this.phoneNumber = string2;
        }

        public void writeToParcel(Parcel parcel, int n) {
            zzk.zza(this, parcel, n);
        }
    }

    public static class Phone
    extends AbstractSafeParcelable {
        public static final Parcelable.Creator<Phone> CREATOR = new zzj();
        public static final int UNKNOWN = 0;
        public static final int WORK = 1;
        public static final int HOME = 2;
        public static final int FAX = 3;
        public static final int MOBILE = 4;
        final int versionCode;
        public int type;
        public String number;

        public Phone() {
            this.versionCode = 1;
        }

        public Phone(int n, int n2, String string) {
            this.versionCode = n;
            this.type = n2;
            this.number = string;
        }

        public void writeToParcel(Parcel parcel, int n) {
            zzj.zza(this, parcel, n);
        }
    }

    public static class Email
    extends AbstractSafeParcelable {
        public static final Parcelable.Creator<Email> CREATOR = new zzg();
        public static final int UNKNOWN = 0;
        public static final int WORK = 1;
        public static final int HOME = 2;
        final int versionCode;
        public int type;
        public String address;
        public String subject;
        public String body;

        public Email() {
            this.versionCode = 1;
        }

        public Email(int n, int n2, String string, String string2, String string3) {
            this.versionCode = n;
            this.type = n2;
            this.address = string;
            this.subject = string2;
            this.body = string3;
        }

        public void writeToParcel(Parcel parcel, int n) {
            zzg.zza(this, parcel, n);
        }
    }
}

