/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.barcode;

import android.content.Context;
import android.util.SparseArray;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.barcode.Barcode;
import com.google.android.gms.vision.barcode.internal.client.BarcodeDetectorOptions;
import com.google.android.gms.vision.barcode.internal.client.zzb;
import com.google.android.gms.vision.internal.client.FrameMetadataParcel;
import java.nio.ByteBuffer;

public final class BarcodeDetector
extends Detector<Barcode> {
    private final zzb aNX;

    private BarcodeDetector() {
        throw new IllegalStateException("Default constructor called");
    }

    private BarcodeDetector(zzb zzb2) {
        this.aNX = zzb2;
    }

    @Override
    public void release() {
        super.release();
        this.aNX.zzclr();
    }

    @Override
    public SparseArray<Barcode> detect(Frame frame) {
        ByteBuffer byteBuffer;
        Barcode[] barcodeArray;
        if (frame == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        FrameMetadataParcel frameMetadataParcel = FrameMetadataParcel.zzc(frame);
        if (frame.getBitmap() != null) {
            barcodeArray = this.aNX.zza(frame.getBitmap(), frameMetadataParcel);
            if (barcodeArray == null) {
                throw new IllegalArgumentException("Internal barcode detector error; check logcat output.");
            }
        } else {
            byteBuffer = frame.getGrayscaleImageData();
            barcodeArray = this.aNX.zza(byteBuffer, frameMetadataParcel);
        }
        byteBuffer = new SparseArray(barcodeArray.length);
        for (Barcode barcode : barcodeArray) {
            byteBuffer.append(barcode.rawValue.hashCode(), (Object)barcode);
        }
        return byteBuffer;
    }

    @Override
    public boolean isOperational() {
        return this.aNX.isOperational();
    }

    public static class Builder {
        private Context mContext;
        private BarcodeDetectorOptions aNY;

        public Builder(Context context) {
            this.mContext = context;
            this.aNY = new BarcodeDetectorOptions();
        }

        public Builder setBarcodeFormats(int n) {
            this.aNY.aNZ = n;
            return this;
        }

        public BarcodeDetector build() {
            zzb zzb2 = new zzb(this.mContext, this.aNY);
            return new BarcodeDetector(zzb2);
        }
    }
}

