/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzbks;
import com.google.android.gms.internal.zzbkt;
import com.google.android.gms.internal.zzbkz;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.fragment.WalletFragmentInitParams;
import com.google.android.gms.wallet.fragment.WalletFragmentOptions;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;

@TargetApi(value=12)
public final class WalletFragment
extends Fragment {
    private zzb zzbSd;
    private boolean mCreated = false;
    private final com.google.android.gms.dynamic.zzb zzbSe = com.google.android.gms.dynamic.zzb.zza((Fragment)this);
    private final zzc zzbSf = new zzc();
    private zza zzbSg = new zza(this);
    private final Fragment zzaRK = this;
    private WalletFragmentOptions zzbRU;
    private WalletFragmentInitParams zzbRV;
    private MaskedWalletRequest zzbRW;
    private MaskedWallet zzbRX;
    private Boolean zzbRY;

    public static WalletFragment newInstance(WalletFragmentOptions walletFragmentOptions) {
        WalletFragment walletFragment = new WalletFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("extraWalletFragmentOptions", (Parcelable)walletFragmentOptions);
        walletFragment.zzaRK.setArguments(bundle);
        return walletFragment;
    }

    public void initialize(WalletFragmentInitParams walletFragmentInitParams) {
        if (this.zzbSd != null) {
            this.zzbSd.initialize(walletFragmentInitParams);
            this.zzbRV = null;
        } else if (this.zzbRV == null) {
            this.zzbRV = walletFragmentInitParams;
            if (this.zzbRW != null) {
                Log.w((String)"WalletFragment", (String)"updateMaskedWalletRequest() was called before initialize()");
            }
            if (this.zzbRX != null) {
                Log.w((String)"WalletFragment", (String)"updateMaskedWallet() was called before initialize()");
            }
        } else {
            Log.w((String)"WalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once. Ignoring.");
        }
    }

    public void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
        if (this.zzbSd != null) {
            this.zzbSd.updateMaskedWalletRequest(maskedWalletRequest);
            this.zzbRW = null;
        } else {
            this.zzbRW = maskedWalletRequest;
        }
    }

    public void updateMaskedWallet(MaskedWallet maskedWallet) {
        if (this.zzbSd != null) {
            this.zzbSd.updateMaskedWallet(maskedWallet);
            this.zzbRX = null;
        } else {
            this.zzbRX = maskedWallet;
        }
    }

    public void setEnabled(boolean bl) {
        if (this.zzbSd != null) {
            this.zzbSd.setEnabled(bl);
            this.zzbRY = null;
        } else {
            this.zzbRY = bl;
        }
    }

    public void setOnStateChangedListener(OnStateChangedListener onStateChangedListener) {
        this.zzbSg.zza(onStateChangedListener);
    }

    public int getState() {
        return this.zzbSd != null ? this.zzbSd.getState() : 0;
    }

    public void onInflate(Activity activity, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(activity, attributeSet, bundle);
        if (this.zzbRU == null) {
            this.zzbRU = WalletFragmentOptions.zzc((Context)activity, attributeSet);
        }
        Bundle bundle2 = new Bundle();
        bundle2.putParcelable("attrKeyWalletFragmentOptions", (Parcelable)this.zzbRU);
        this.zzbSf.onInflate(activity, bundle2, bundle);
    }

    public void onCreate(Bundle bundle) {
        WalletFragmentOptions walletFragmentOptions;
        super.onCreate(bundle);
        if (bundle != null) {
            bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
            WalletFragmentInitParams walletFragmentInitParams = (WalletFragmentInitParams)bundle.getParcelable("walletFragmentInitParams");
            if (walletFragmentInitParams != null) {
                if (this.zzbRV != null) {
                    Log.w((String)"WalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once.Ignoring.");
                }
                this.zzbRV = walletFragmentInitParams;
            }
            if (this.zzbRW == null) {
                this.zzbRW = (MaskedWalletRequest)bundle.getParcelable("maskedWalletRequest");
            }
            if (this.zzbRX == null) {
                this.zzbRX = (MaskedWallet)bundle.getParcelable("maskedWallet");
            }
            if (bundle.containsKey("walletFragmentOptions")) {
                this.zzbRU = (WalletFragmentOptions)bundle.getParcelable("walletFragmentOptions");
            }
            if (bundle.containsKey("enabled")) {
                this.zzbRY = bundle.getBoolean("enabled");
            }
        } else if (this.zzaRK.getArguments() != null && (walletFragmentOptions = (WalletFragmentOptions)this.zzaRK.getArguments().getParcelable("extraWalletFragmentOptions")) != null) {
            walletFragmentOptions.zzci((Context)this.zzaRK.getActivity());
            this.zzbRU = walletFragmentOptions;
        }
        this.mCreated = true;
        this.zzbSf.onCreate(bundle);
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return this.zzbSf.onCreateView(layoutInflater, viewGroup, bundle);
    }

    public void onStart() {
        super.onStart();
        this.zzbSf.onStart();
    }

    public void onResume() {
        super.onResume();
        this.zzbSf.onResume();
        FragmentManager fragmentManager = this.zzaRK.getActivity().getFragmentManager();
        Fragment fragment = fragmentManager.findFragmentByTag("GooglePlayServicesErrorDialog");
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commit();
            int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.zzaRK.getActivity());
            GooglePlayServicesUtil.showErrorDialogFragment((int)n, (Activity)this.zzaRK.getActivity(), (int)-1);
        }
    }

    public void onPause() {
        super.onPause();
        this.zzbSf.onPause();
    }

    public void onStop() {
        super.onStop();
        this.zzbSf.onStop();
    }

    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
        this.zzbSf.onSaveInstanceState(bundle);
        if (this.zzbRV != null) {
            bundle.putParcelable("walletFragmentInitParams", (Parcelable)this.zzbRV);
            this.zzbRV = null;
        }
        if (this.zzbRW != null) {
            bundle.putParcelable("maskedWalletRequest", (Parcelable)this.zzbRW);
            this.zzbRW = null;
        }
        if (this.zzbRX != null) {
            bundle.putParcelable("maskedWallet", (Parcelable)this.zzbRX);
            this.zzbRX = null;
        }
        if (this.zzbRU != null) {
            bundle.putParcelable("walletFragmentOptions", (Parcelable)this.zzbRU);
            this.zzbRU = null;
        }
        if (this.zzbRY != null) {
            bundle.putBoolean("enabled", this.zzbRY.booleanValue());
            this.zzbRY = null;
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.mCreated = false;
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        if (this.zzbSd != null) {
            this.zzbSd.onActivityResult(n, n2, intent);
        }
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(WalletFragment var1, int var2, int var3, Bundle var4);
    }

    static class zza
    extends zzbkt.zza {
        private OnStateChangedListener zzbSh;
        private final WalletFragment zzbSi;

        zza(WalletFragment walletFragment) {
            this.zzbSi = walletFragment;
        }

        @Override
        public void zza(int n, int n2, Bundle bundle) {
            if (this.zzbSh != null) {
                this.zzbSh.onStateChanged(this.zzbSi, n, n2, bundle);
            }
        }

        public void zza(OnStateChangedListener onStateChangedListener) {
            this.zzbSh = onStateChangedListener;
        }
    }

    private static class zzb
    implements LifecycleDelegate {
        private final zzbks zzbSb;

        private zzb(zzbks zzbks2) {
            this.zzbSb = zzbks2;
        }

        private void initialize(WalletFragmentInitParams walletFragmentInitParams) {
            try {
                this.zzbSb.initialize(walletFragmentInitParams);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void setEnabled(boolean bl) {
            try {
                this.zzbSb.setEnabled(bl);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
            try {
                this.zzbSb.updateMaskedWalletRequest(maskedWalletRequest);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWallet(MaskedWallet maskedWallet) {
            try {
                this.zzbSb.updateMaskedWallet(maskedWallet);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private int getState() {
            try {
                return this.zzbSb.getState();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            WalletFragmentOptions walletFragmentOptions = (WalletFragmentOptions)bundle.getParcelable("extraWalletFragmentOptions");
            try {
                this.zzbSb.zza(zzd.zzA((Object)activity), walletFragmentOptions, bundle2);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onCreate(Bundle bundle) {
            try {
                this.zzbSb.onCreate(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            try {
                IObjectWrapper iObjectWrapper = this.zzbSb.onCreateView(zzd.zzA((Object)layoutInflater), zzd.zzA((Object)viewGroup), bundle);
                return (View)zzd.zzF((IObjectWrapper)iObjectWrapper);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onStart() {
            try {
                this.zzbSb.onStart();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onResume() {
            try {
                this.zzbSb.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onPause() {
            try {
                this.zzbSb.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onStop() {
            try {
                this.zzbSb.onStop();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onDestroyView() {
        }

        public void onDestroy() {
        }

        public void onLowMemory() {
        }

        public void onSaveInstanceState(Bundle bundle) {
            try {
                this.zzbSb.onSaveInstanceState(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void onActivityResult(int n, int n2, Intent intent) {
            try {
                this.zzbSb.onActivityResult(n, n2, intent);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }
    }

    private class zzc
    extends com.google.android.gms.dynamic.zza<zzb>
    implements View.OnClickListener {
        private zzc() {
        }

        protected void zza(zze<zzb> zze2) {
            Activity activity = WalletFragment.this.zzaRK.getActivity();
            if (WalletFragment.this.zzbSd == null && WalletFragment.this.mCreated && activity != null) {
                try {
                    zzbks zzbks2 = zzbkz.zza(activity, (com.google.android.gms.dynamic.zzc)WalletFragment.this.zzbSe, WalletFragment.this.zzbRU, WalletFragment.this.zzbSg);
                    WalletFragment.this.zzbSd = new zzb(zzbks2);
                    WalletFragment.this.zzbRU = null;
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return;
                }
                zze2.zza((LifecycleDelegate)WalletFragment.this.zzbSd);
                if (WalletFragment.this.zzbRV != null) {
                    WalletFragment.this.zzbSd.initialize(WalletFragment.this.zzbRV);
                    WalletFragment.this.zzbRV = null;
                }
                if (WalletFragment.this.zzbRW != null) {
                    WalletFragment.this.zzbSd.updateMaskedWalletRequest(WalletFragment.this.zzbRW);
                    WalletFragment.this.zzbRW = null;
                }
                if (WalletFragment.this.zzbRX != null) {
                    WalletFragment.this.zzbSd.updateMaskedWallet(WalletFragment.this.zzbRX);
                    WalletFragment.this.zzbRX = null;
                }
                if (WalletFragment.this.zzbRY != null) {
                    WalletFragment.this.zzbSd.setEnabled(WalletFragment.this.zzbRY);
                    WalletFragment.this.zzbRY = null;
                }
            }
        }

        protected void zza(FrameLayout frameLayout) {
            WalletFragmentStyle walletFragmentStyle;
            Button button = new Button((Context)WalletFragment.this.zzaRK.getActivity());
            button.setText(R.string.wallet_buy_button_place_holder);
            int n = -1;
            int n2 = -2;
            if (WalletFragment.this.zzbRU != null && (walletFragmentStyle = WalletFragment.this.zzbRU.getFragmentStyle()) != null) {
                DisplayMetrics displayMetrics = WalletFragment.this.zzaRK.getResources().getDisplayMetrics();
                n = walletFragmentStyle.zza("buyButtonWidth", displayMetrics, -1);
                n2 = walletFragmentStyle.zza("buyButtonHeight", displayMetrics, -2);
            }
            button.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            button.setOnClickListener((View.OnClickListener)this);
            frameLayout.addView((View)button);
        }

        public void onClick(View view) {
            Activity activity = WalletFragment.this.zzaRK.getActivity();
            int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)activity);
            GooglePlayServicesUtil.showErrorDialogFragment((int)n, (Activity)activity, (int)-1);
        }
    }
}

