/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbcn;
import com.google.android.gms.wallet.CardRequirements;
import com.google.android.gms.wallet.PaymentMethodTokenizationParameters;
import com.google.android.gms.wallet.ShippingAddressRequirements;
import com.google.android.gms.wallet.TransactionInfo;
import com.google.android.gms.wallet.zzad;
import com.google.android.gms.wallet.zzae;
import java.util.ArrayList;
import java.util.Collection;

public final class PaymentDataRequest
extends zzbck {
    public static final Parcelable.Creator<PaymentDataRequest> CREATOR = new zzae();
    boolean zzkoe;
    boolean zzkof;
    CardRequirements zzkog;
    boolean zzkoh;
    ShippingAddressRequirements zzkoi;
    ArrayList<Integer> zzkmi;
    PaymentMethodTokenizationParameters zzkoj;
    TransactionInfo zzkok;
    boolean zzkol;

    PaymentDataRequest(boolean bl, boolean bl2, CardRequirements cardRequirements, boolean bl3, ShippingAddressRequirements shippingAddressRequirements, ArrayList<Integer> arrayList, PaymentMethodTokenizationParameters paymentMethodTokenizationParameters, TransactionInfo transactionInfo, boolean bl4) {
        this.zzkoe = bl;
        this.zzkof = bl2;
        this.zzkog = cardRequirements;
        this.zzkoh = bl3;
        this.zzkoi = shippingAddressRequirements;
        this.zzkmi = arrayList;
        this.zzkoj = paymentMethodTokenizationParameters;
        this.zzkok = transactionInfo;
        this.zzkol = bl4;
    }

    private PaymentDataRequest() {
        this.zzkol = true;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PaymentDataRequest paymentDataRequest = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zza((Parcel)parcel2, (int)1, (boolean)paymentDataRequest.zzkoe);
        zzbcn.zza((Parcel)parcel2, (int)2, (boolean)paymentDataRequest.zzkof);
        zzbcn.zza((Parcel)parcel2, (int)3, (Parcelable)paymentDataRequest.zzkog, (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)4, (boolean)paymentDataRequest.zzkoh);
        zzbcn.zza((Parcel)parcel2, (int)5, (Parcelable)paymentDataRequest.zzkoi, (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)6, paymentDataRequest.zzkmi, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)7, (Parcelable)paymentDataRequest.zzkoj, (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)8, (Parcelable)paymentDataRequest.zzkok, (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)9, (boolean)paymentDataRequest.zzkol);
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }

    public final boolean isEmailRequired() {
        return this.zzkoe;
    }

    public final boolean isPhoneNumberRequired() {
        return this.zzkof;
    }

    @Nullable
    public final CardRequirements getCardRequirements() {
        return this.zzkog;
    }

    public final boolean isShippingAddressRequired() {
        return this.zzkoh;
    }

    @Nullable
    public final ShippingAddressRequirements getShippingAddressRequirements() {
        return this.zzkoi;
    }

    public final ArrayList<Integer> getAllowedPaymentMethods() {
        return this.zzkmi;
    }

    public final PaymentMethodTokenizationParameters getPaymentMethodTokenizationParameters() {
        return this.zzkoj;
    }

    public final TransactionInfo getTransactionInfo() {
        return this.zzkok;
    }

    public final boolean isUiRequired() {
        return this.zzkol;
    }

    public static Builder newBuilder() {
        return new Builder(new PaymentDataRequest(), null);
    }

    public final class Builder {
        private /* synthetic */ PaymentDataRequest zzkom;

        private Builder(PaymentDataRequest paymentDataRequest) {
            this.zzkom = paymentDataRequest;
        }

        public final Builder setEmailRequired(boolean bl) {
            this.zzkom.zzkoe = bl;
            return this;
        }

        public final Builder setPhoneNumberRequired(boolean bl) {
            this.zzkom.zzkof = bl;
            return this;
        }

        public final Builder setCardRequirements(@NonNull CardRequirements cardRequirements) {
            this.zzkom.zzkog = cardRequirements;
            return this;
        }

        public final Builder setShippingAddressRequired(boolean bl) {
            this.zzkom.zzkoh = bl;
            return this;
        }

        public final Builder setShippingAddressRequirements(@NonNull ShippingAddressRequirements shippingAddressRequirements) {
            this.zzkom.zzkoi = shippingAddressRequirements;
            return this;
        }

        public final Builder addAllowedPaymentMethod(int n) {
            if (this.zzkom.zzkmi == null) {
                this.zzkom.zzkmi = new ArrayList();
            }
            this.zzkom.zzkmi.add(n);
            return this;
        }

        public final Builder addAllowedPaymentMethods(@NonNull Collection<Integer> collection) {
            zzbp.zzb((collection != null && !collection.isEmpty() ? 1 : 0) != 0, (Object)"allowedPaymentMethods can't be null or empty!");
            if (this.zzkom.zzkmi == null) {
                this.zzkom.zzkmi = new ArrayList();
            }
            this.zzkom.zzkmi.addAll(collection);
            return this;
        }

        public final Builder setPaymentMethodTokenizationParameters(PaymentMethodTokenizationParameters paymentMethodTokenizationParameters) {
            this.zzkom.zzkoj = paymentMethodTokenizationParameters;
            return this;
        }

        public final Builder setTransactionInfo(@NonNull TransactionInfo transactionInfo) {
            this.zzkom.zzkok = transactionInfo;
            return this;
        }

        public final Builder setUiRequired(boolean bl) {
            this.zzkom.zzkol = bl;
            return this;
        }

        public final PaymentDataRequest build() {
            zzbp.zzb(this.zzkom.zzkmi, (Object)"Allowed payment methods must be set! You can set it through addAllowedPaymentMethod() or addAllowedPaymentMethods() in the PaymentDataRequest Builder.");
            zzbp.zzb((Object)((Object)this.zzkom.zzkog), (Object)"Card requirements must be set!");
            zzbp.zzb((Object)((Object)this.zzkom.zzkok), (Object)"Transaction info must be set!");
            return this.zzkom;
        }

        /* synthetic */ Builder(PaymentDataRequest paymentDataRequest, zzad zzad2) {
            this(paymentDataRequest);
        }
    }
}

