/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.wallet.fragment.zzg;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class WalletFragmentStyle
extends zzbgl {
    public static final Parcelable.Creator<WalletFragmentStyle> CREATOR = new zzg();
    private Bundle zzlpm;
    private int zzlpn;

    public WalletFragmentStyle() {
        this.zzlpm = new Bundle();
        this.zzlpm.putInt("buyButtonAppearanceDefault", 4);
        this.zzlpm.putInt("maskedWalletDetailsLogoImageTypeDefault", 3);
    }

    WalletFragmentStyle(Bundle bundle, int n) {
        this.zzlpm = bundle;
        this.zzlpn = n;
    }

    public final WalletFragmentStyle setStyleResourceId(int n) {
        this.zzlpn = n;
        return this;
    }

    public final WalletFragmentStyle setBuyButtonText(int n) {
        this.zzlpm.putInt("buyButtonText", n);
        return this;
    }

    public final WalletFragmentStyle setBuyButtonHeight(int n) {
        this.zzlpm.putLong("buyButtonHeight", WalletFragmentStyle.zzfp(n));
        return this;
    }

    public final WalletFragmentStyle setBuyButtonHeight(int n, float f) {
        this.zzlpm.putLong("buyButtonHeight", WalletFragmentStyle.zzb(n, f));
        return this;
    }

    public final WalletFragmentStyle setBuyButtonWidth(int n) {
        this.zzlpm.putLong("buyButtonWidth", WalletFragmentStyle.zzfp(n));
        return this;
    }

    public final WalletFragmentStyle setBuyButtonWidth(int n, float f) {
        this.zzlpm.putLong("buyButtonWidth", WalletFragmentStyle.zzb(n, f));
        return this;
    }

    public final WalletFragmentStyle setBuyButtonAppearance(int n) {
        this.zzlpm.putInt("buyButtonAppearance", n);
        return this;
    }

    public final WalletFragmentStyle setMaskedWalletDetailsTextAppearance(int n) {
        this.zzlpm.putInt("maskedWalletDetailsTextAppearance", n);
        return this;
    }

    public final WalletFragmentStyle setMaskedWalletDetailsHeaderTextAppearance(int n) {
        this.zzlpm.putInt("maskedWalletDetailsHeaderTextAppearance", n);
        return this;
    }

    public final WalletFragmentStyle setMaskedWalletDetailsBackgroundColor(int n) {
        this.zzlpm.remove("maskedWalletDetailsBackgroundResource");
        this.zzlpm.putInt("maskedWalletDetailsBackgroundColor", n);
        return this;
    }

    public final WalletFragmentStyle setMaskedWalletDetailsBackgroundResource(int n) {
        this.zzlpm.remove("maskedWalletDetailsBackgroundColor");
        this.zzlpm.putInt("maskedWalletDetailsBackgroundResource", n);
        return this;
    }

    public final WalletFragmentStyle setMaskedWalletDetailsButtonTextAppearance(int n) {
        this.zzlpm.putInt("maskedWalletDetailsButtonTextAppearance", n);
        return this;
    }

    public final WalletFragmentStyle setMaskedWalletDetailsButtonBackgroundColor(int n) {
        this.zzlpm.remove("maskedWalletDetailsButtonBackgroundResource");
        this.zzlpm.putInt("maskedWalletDetailsButtonBackgroundColor", n);
        return this;
    }

    public final WalletFragmentStyle setMaskedWalletDetailsButtonBackgroundResource(int n) {
        this.zzlpm.remove("maskedWalletDetailsButtonBackgroundColor");
        this.zzlpm.putInt("maskedWalletDetailsButtonBackgroundResource", n);
        return this;
    }

    public final WalletFragmentStyle setMaskedWalletDetailsLogoImageType(int n) {
        this.zzlpm.putInt("maskedWalletDetailsLogoImageType", n);
        return this;
    }

    @Deprecated
    public final WalletFragmentStyle setMaskedWalletDetailsLogoTextColor(int n) {
        this.zzlpm.putInt("maskedWalletDetailsLogoTextColor", n);
        return this;
    }

    @Hide
    public final int zza(String string2, DisplayMetrics displayMetrics, int n) {
        if (this.zzlpm.containsKey(string2)) {
            int n2;
            DisplayMetrics displayMetrics2 = displayMetrics;
            long l = this.zzlpm.getLong(string2);
            int n3 = (int)(l >>> 32);
            int n4 = (int)l;
            switch (n3) {
                case 129: {
                    return n4;
                }
                case 128: {
                    return TypedValue.complexToDimensionPixelSize((int)n4, (DisplayMetrics)displayMetrics2);
                }
                case 0: {
                    n2 = 0;
                    break;
                }
                case 1: {
                    n2 = 1;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
                case 3: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 4;
                    break;
                }
                case 5: {
                    n2 = 5;
                    break;
                }
                default: {
                    throw new IllegalStateException(new StringBuilder(36).append("Unexpected unit or type: ").append(n3).toString());
                }
            }
            return Math.round(TypedValue.applyDimension((int)n2, (float)Float.intBitsToFloat(n4), (DisplayMetrics)displayMetrics2));
        }
        return n;
    }

    private static long zzb(int n, float f) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return WalletFragmentStyle.zzr(n, Float.floatToIntBits(f));
            }
        }
        throw new IllegalArgumentException(new StringBuilder(30).append("Unrecognized unit: ").append(n).toString());
    }

    private static long zzfp(int n) {
        if (n < 0) {
            if (n == -1 || n == -2) {
                return WalletFragmentStyle.zzr(129, n);
            }
            throw new IllegalArgumentException(new StringBuilder(39).append("Unexpected dimension value: ").append(n).toString());
        }
        return WalletFragmentStyle.zzb(0, n);
    }

    private static long zzr(int n, int n2) {
        return (long)n << 32 | (long)n2 & 0xFFFFFFFFL;
    }

    @Hide
    public final void zzet(Context context) {
        int n = this.zzlpn <= 0 ? R.style.WalletFragmentDefaultStyle : this.zzlpn;
        int[] nArray = R.styleable.WalletFragmentStyle;
        TypedArray typedArray = context.obtainStyledAttributes(n, nArray);
        this.zza(typedArray, R.styleable.WalletFragmentStyle_buyButtonWidth, "buyButtonWidth");
        this.zza(typedArray, R.styleable.WalletFragmentStyle_buyButtonHeight, "buyButtonHeight");
        this.zzb(typedArray, R.styleable.WalletFragmentStyle_buyButtonText, "buyButtonText");
        this.zzb(typedArray, R.styleable.WalletFragmentStyle_buyButtonAppearance, "buyButtonAppearance");
        this.zzb(typedArray, R.styleable.WalletFragmentStyle_maskedWalletDetailsTextAppearance, "maskedWalletDetailsTextAppearance");
        this.zzb(typedArray, R.styleable.WalletFragmentStyle_maskedWalletDetailsHeaderTextAppearance, "maskedWalletDetailsHeaderTextAppearance");
        this.zza(typedArray, R.styleable.WalletFragmentStyle_maskedWalletDetailsBackground, "maskedWalletDetailsBackgroundColor", "maskedWalletDetailsBackgroundResource");
        this.zzb(typedArray, R.styleable.WalletFragmentStyle_maskedWalletDetailsButtonTextAppearance, "maskedWalletDetailsButtonTextAppearance");
        this.zza(typedArray, R.styleable.WalletFragmentStyle_maskedWalletDetailsButtonBackground, "maskedWalletDetailsButtonBackgroundColor", "maskedWalletDetailsButtonBackgroundResource");
        this.zzb(typedArray, R.styleable.WalletFragmentStyle_maskedWalletDetailsLogoTextColor, "maskedWalletDetailsLogoTextColor");
        this.zzb(typedArray, R.styleable.WalletFragmentStyle_maskedWalletDetailsLogoImageType, "maskedWalletDetailsLogoImageType");
        typedArray.recycle();
    }

    private final void zza(TypedArray typedArray, int n, String string2) {
        if (this.zzlpm.containsKey(string2)) {
            return;
        }
        TypedValue typedValue = typedArray.peekValue(n);
        if (typedValue != null) {
            long l;
            TypedValue typedValue2 = typedValue;
            switch (typedValue2.type) {
                case 16: {
                    l = WalletFragmentStyle.zzfp(typedValue2.data);
                    break;
                }
                case 5: {
                    l = WalletFragmentStyle.zzr(128, typedValue2.data);
                    break;
                }
                default: {
                    int n2 = typedValue2.type;
                    throw new IllegalArgumentException(new StringBuilder(38).append("Unexpected dimension type: ").append(n2).toString());
                }
            }
            this.zzlpm.putLong(string2, l);
        }
    }

    private final void zzb(TypedArray typedArray, int n, String string2) {
        if (this.zzlpm.containsKey(string2)) {
            return;
        }
        TypedValue typedValue = typedArray.peekValue(n);
        if (typedValue != null) {
            this.zzlpm.putInt(string2, typedValue.data);
        }
    }

    private final void zza(TypedArray typedArray, int n, String string2, String string3) {
        if (this.zzlpm.containsKey(string2) || this.zzlpm.containsKey(string3)) {
            return;
        }
        TypedValue typedValue = typedArray.peekValue(n);
        if (typedValue != null) {
            if (typedValue.type >= 28 && typedValue.type <= 31) {
                this.zzlpm.putInt(string2, typedValue.data);
                return;
            }
            this.zzlpm.putInt(string3, typedValue.resourceId);
        }
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        WalletFragmentStyle walletFragmentStyle = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (Bundle)walletFragmentStyle.zzlpm, (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)3, (int)walletFragmentStyle.zzlpn);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Dimension {
        public static final int UNIT_PX = 0;
        public static final int UNIT_DIP = 1;
        public static final int UNIT_SP = 2;
        public static final int UNIT_PT = 3;
        public static final int UNIT_IN = 4;
        public static final int UNIT_MM = 5;
        public static final int MATCH_PARENT = -1;
        public static final int WRAP_CONTENT = -2;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LogoImageType {
        @Deprecated
        public static final int GOOGLE_WALLET_CLASSIC = 1;
        @Deprecated
        public static final int GOOGLE_WALLET_MONOCHROME = 2;
        public static final int ANDROID_PAY = 3;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BuyButtonAppearance {
        public static final int ANDROID_PAY_DARK = 4;
        public static final int ANDROID_PAY_LIGHT = 5;
        public static final int ANDROID_PAY_LIGHT_WITH_BORDER = 6;
        @Deprecated
        public static final int GOOGLE_WALLET_CLASSIC = 1;
        @Deprecated
        public static final int GOOGLE_WALLET_GRAYSCALE = 2;
        @Deprecated
        public static final int GOOGLE_WALLET_MONOCHROME = 3;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BuyButtonText {
        public static final int BUY_WITH = 5;
        public static final int LOGO_ONLY = 6;
        public static final int DONATE_WITH = 7;
    }
}

