/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.wallet.wobs.CommonWalletObject;
import com.google.android.gms.wallet.wobs.LabelValueRow;
import com.google.android.gms.wallet.wobs.TextModuleData;
import com.google.android.gms.wallet.wobs.TimeInterval;
import com.google.android.gms.wallet.wobs.UriData;
import com.google.android.gms.wallet.wobs.WalletObjectMessage;
import com.google.android.gms.wallet.zzn;
import com.google.android.gms.wallet.zzo;
import java.util.ArrayList;
import java.util.Collection;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="GiftCardWalletObjectCreator")
public final class GiftCardWalletObject
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<GiftCardWalletObject> CREATOR = new zzo();
    @SafeParcelable.Field(id=2)
    CommonWalletObject zzbk = CommonWalletObject.zze().zzf();
    @SafeParcelable.Field(id=3)
    String zzbl;
    @SafeParcelable.Field(id=4)
    String pin;
    @Deprecated
    @SafeParcelable.Field(id=5)
    String zzbm;
    @SafeParcelable.Field(id=6)
    long zzbn;
    @SafeParcelable.Field(id=7)
    String zzbo;
    @SafeParcelable.Field(id=8)
    long zzbp;
    @SafeParcelable.Field(id=9)
    String zzbq;

    public static Builder newBuilder() {
        return new GiftCardWalletObject().new Builder(null);
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GiftCardWalletObject giftCardWalletObject = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)2, (Parcelable)giftCardWalletObject.zzbk, (int)n, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)giftCardWalletObject.zzbl, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)4, (String)giftCardWalletObject.pin, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)5, (String)giftCardWalletObject.zzbm, (boolean)false);
        SafeParcelWriter.writeLong((Parcel)parcel2, (int)6, (long)giftCardWalletObject.zzbn);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)7, (String)giftCardWalletObject.zzbo, (boolean)false);
        SafeParcelWriter.writeLong((Parcel)parcel2, (int)8, (long)giftCardWalletObject.zzbp);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)9, (String)giftCardWalletObject.zzbq, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    GiftCardWalletObject() {
    }

    @SafeParcelable.Constructor
    GiftCardWalletObject(@SafeParcelable.Param(id=2) CommonWalletObject commonWalletObject, @SafeParcelable.Param(id=3) String string, @SafeParcelable.Param(id=4) String string2, @SafeParcelable.Param(id=5) String string3, @SafeParcelable.Param(id=6) long l, @SafeParcelable.Param(id=7) String string4, @SafeParcelable.Param(id=8) long l2, @SafeParcelable.Param(id=9) String string5) {
        this.zzbk = commonWalletObject;
        this.zzbl = string;
        this.pin = string2;
        this.zzbn = l;
        this.zzbo = string4;
        this.zzbp = l2;
        this.zzbq = string5;
        this.zzbm = string3;
    }

    public final String getId() {
        return this.zzbk.getId();
    }

    public final String getClassId() {
        return this.zzbk.getClassId();
    }

    public final String getTitle() {
        return this.zzbk.getName();
    }

    public final String getIssuerName() {
        return this.zzbk.getIssuerName();
    }

    public final String getBarcodeAlternateText() {
        return this.zzbk.getBarcodeAlternateText();
    }

    public final String getBarcodeType() {
        return this.zzbk.getBarcodeType();
    }

    public final String getBarcodeValue() {
        return this.zzbk.getBarcodeValue();
    }

    @Deprecated
    public final String getBarcodeLabel() {
        return this.zzbk.getBarcodeLabel();
    }

    public final int getState() {
        return this.zzbk.getState();
    }

    public final ArrayList<WalletObjectMessage> getMessages() {
        return this.zzbk.getMessages();
    }

    public final TimeInterval getValidTimeInterval() {
        return this.zzbk.getValidTimeInterval();
    }

    public final ArrayList<LatLng> getLocations() {
        return this.zzbk.getLocations();
    }

    @Deprecated
    public final String getInfoModuleDataHexFontColor() {
        return this.zzbk.getInfoModuleDataHexFontColor();
    }

    @Deprecated
    public final String getInfoModuleDataHexBackgroundColor() {
        return this.zzbk.getInfoModuleDataHexBackgroundColor();
    }

    public final ArrayList<LabelValueRow> getInfoModuleDataLabelValueRows() {
        return this.zzbk.getInfoModuleDataLabelValueRows();
    }

    public final boolean getInfoModuleDataShowLastUpdateTime() {
        return this.zzbk.getInfoModuleDataShowLastUpdateTime();
    }

    public final ArrayList<UriData> getImageModuleDataMainImageUris() {
        return this.zzbk.getImageModuleDataMainImageUris();
    }

    public final ArrayList<TextModuleData> getTextModulesData() {
        return this.zzbk.getTextModulesData();
    }

    public final ArrayList<UriData> getLinksModuleDataUris() {
        return this.zzbk.getLinksModuleDataUris();
    }

    public final String getCardNumber() {
        return this.zzbl;
    }

    public final String getPin() {
        return this.pin;
    }

    public final long getBalanceMicros() {
        return this.zzbn;
    }

    public final String getBalanceCurrencyCode() {
        return this.zzbo;
    }

    public final long getBalanceUpdateTime() {
        return this.zzbp;
    }

    public final String getEventNumber() {
        return this.zzbq;
    }

    @Deprecated
    public final String getCardIdentifier() {
        return this.zzbm;
    }

    public final class Builder {
        private CommonWalletObject.zza zzbr = CommonWalletObject.zze();

        private Builder() {
        }

        public final Builder setCardNumber(String string) {
            GiftCardWalletObject.this.zzbl = string;
            return this;
        }

        public final Builder setPin(String string) {
            GiftCardWalletObject.this.pin = string;
            return this;
        }

        public final Builder setBalanceMicros(long l) {
            GiftCardWalletObject.this.zzbn = l;
            return this;
        }

        public final Builder setBalanceCurrencyCode(String string) {
            GiftCardWalletObject.this.zzbo = string;
            return this;
        }

        public final Builder setBalanceUpdateTime(long l) {
            GiftCardWalletObject.this.zzbp = l;
            return this;
        }

        public final Builder setEventNumber(String string) {
            GiftCardWalletObject.this.zzbq = string;
            return this;
        }

        @Deprecated
        public final Builder setCardIdentifier(String string) {
            GiftCardWalletObject.this.zzbm = string;
            return this;
        }

        public final Builder setId(String string) {
            this.zzbr.zza(string);
            return this;
        }

        public final Builder setIssuerName(String string) {
            this.zzbr.zzd(string);
            return this;
        }

        public final Builder setTitle(String string) {
            this.zzbr.zzc(string);
            return this;
        }

        public final Builder setBarcodeAlternateText(String string) {
            this.zzbr.zze(string);
            return this;
        }

        public final Builder setBarcodeType(String string) {
            this.zzbr.zzf(string);
            return this;
        }

        public final Builder setBarcodeValue(String string) {
            this.zzbr.zzg(string);
            return this;
        }

        @Deprecated
        public final Builder setBarcodeLabel(String string) {
            this.zzbr.zzh(string);
            return this;
        }

        public final Builder setClassId(String string) {
            this.zzbr.zzb(string);
            return this;
        }

        public final Builder setState(int n) {
            this.zzbr.zzc(n);
            return this;
        }

        public final Builder addMessages(Collection<WalletObjectMessage> collection) {
            this.zzbr.zza(collection);
            return this;
        }

        public final Builder addMessage(WalletObjectMessage walletObjectMessage) {
            this.zzbr.zza(walletObjectMessage);
            return this;
        }

        public final Builder setValidTimeInterval(TimeInterval timeInterval) {
            this.zzbr.zza(timeInterval);
            return this;
        }

        public final Builder addLocations(Collection<LatLng> collection) {
            this.zzbr.zzb(collection);
            return this;
        }

        public final Builder addLocation(LatLng latLng) {
            this.zzbr.zza(latLng);
            return this;
        }

        @Deprecated
        public final Builder setInfoModuleDataHexFontColor(String string) {
            this.zzbr.zzi(string);
            return this;
        }

        @Deprecated
        public final Builder setInfoModuleDataHexBackgroundColor(String string) {
            this.zzbr.zzj(string);
            return this;
        }

        public final Builder addInfoModuleDataLabelValueRows(Collection<LabelValueRow> collection) {
            this.zzbr.zzc(collection);
            return this;
        }

        public final Builder addInfoModuleDataLabelValueRow(LabelValueRow labelValueRow) {
            this.zzbr.zza(labelValueRow);
            return this;
        }

        public final Builder setInfoModuleDataShowLastUpdateTime(boolean bl) {
            this.zzbr.zza(bl);
            return this;
        }

        public final Builder addImageModuleDataMainImageUris(Collection<UriData> collection) {
            this.zzbr.zzd(collection);
            return this;
        }

        public final Builder addImageModuleDataMainImageUri(UriData uriData) {
            this.zzbr.zza(uriData);
            return this;
        }

        public final Builder addTextModulesData(Collection<TextModuleData> collection) {
            this.zzbr.zze(collection);
            return this;
        }

        public final Builder addTextModuleData(TextModuleData textModuleData) {
            this.zzbr.zza(textModuleData);
            return this;
        }

        public final Builder addLinksModuleDataUris(Collection<UriData> collection) {
            this.zzbr.zzf(collection);
            return this;
        }

        public final Builder addLinksModuleDataUri(UriData uriData) {
            this.zzbr.zzb(uriData);
            return this;
        }

        public final GiftCardWalletObject build() {
            Preconditions.checkArgument((!TextUtils.isEmpty((CharSequence)GiftCardWalletObject.this.zzbl) ? 1 : 0) != 0, (Object)"Card number is required.");
            GiftCardWalletObject.this.zzbk = this.zzbr.zzf();
            Preconditions.checkArgument((!TextUtils.isEmpty((CharSequence)GiftCardWalletObject.this.zzbk.getName()) ? 1 : 0) != 0, (Object)"Card name is required.");
            Preconditions.checkArgument((!TextUtils.isEmpty((CharSequence)GiftCardWalletObject.this.zzbk.getIssuerName()) ? 1 : 0) != 0, (Object)"Card issuer name is required.");
            return GiftCardWalletObject.this;
        }

        /* synthetic */ Builder(zzn zzn2) {
            this();
        }
    }
}

