/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wallet.zzao;
import com.google.android.gms.wallet.zzap;

@SafeParcelable.Class(creator="TransactionInfoCreator")
public final class TransactionInfo
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<TransactionInfo> CREATOR = new zzap();
    @SafeParcelable.Field(id=1)
    int zzep;
    @SafeParcelable.Field(id=2)
    String zzao;
    @SafeParcelable.Field(id=3)
    String zzap;

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        TransactionInfo transactionInfo = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1, (int)transactionInfo.zzep);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)transactionInfo.zzao, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)transactionInfo.zzap, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    @SafeParcelable.Constructor
    public TransactionInfo(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) String string2) {
        this.zzep = n;
        this.zzao = string;
        this.zzap = string2;
    }

    private TransactionInfo() {
    }

    public static Builder newBuilder() {
        return new TransactionInfo().new Builder(null);
    }

    public final int getTotalPriceStatus() {
        return this.zzep;
    }

    @Nullable
    public final String getTotalPrice() {
        return this.zzao;
    }

    public final String getCurrencyCode() {
        return this.zzap;
    }

    public final class Builder {
        private Builder() {
        }

        public final Builder setTotalPriceStatus(int n) {
            TransactionInfo.this.zzep = n;
            return this;
        }

        public final Builder setTotalPrice(@NonNull String string) {
            TransactionInfo.this.zzao = string;
            return this;
        }

        public final Builder setCurrencyCode(@NonNull String string) {
            TransactionInfo.this.zzap = string;
            return this;
        }

        public final TransactionInfo build() {
            Preconditions.checkNotEmpty((String)TransactionInfo.this.zzap, (Object)"currencyCode must be set!");
            Builder builder = this;
            if (!(builder.TransactionInfo.this.zzep == 1 || builder.TransactionInfo.this.zzep == 2 || builder.TransactionInfo.this.zzep == 3)) {
                throw new IllegalArgumentException("totalPriceStatus must be set to one of WalletConstants.TotalPriceStatus!");
            }
            if (TransactionInfo.this.zzep == 2) {
                Preconditions.checkNotEmpty((String)TransactionInfo.this.zzao, (Object)"An estimated total price must be set if totalPriceStatus is set to WalletConstants.TOTAL_PRICE_STATUS_ESTIMATED!");
            }
            if (TransactionInfo.this.zzep == 3) {
                Preconditions.checkNotEmpty((String)TransactionInfo.this.zzao, (Object)"An final total price must be set if totalPriceStatus is set to WalletConstants.TOTAL_PRICE_STATUS_FINAL!");
            }
            return TransactionInfo.this;
        }

        /* synthetic */ Builder(zzao zzao2) {
            this();
        }
    }
}

