/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.internal.wallet.zzaf;
import com.google.android.gms.internal.wallet.zzan;
import com.google.android.gms.internal.wallet.zzao;
import com.google.android.gms.internal.wallet.zzg;
import com.google.android.gms.internal.wallet.zzy;
import com.google.android.gms.wallet.Payments;
import com.google.android.gms.wallet.PaymentsClient;
import com.google.android.gms.wallet.WalletObjectsClient;
import com.google.android.gms.wallet.wobs.WalletObjects;
import com.google.android.gms.wallet.zzaq;
import java.util.Locale;

public final class Wallet {
    private static final Api.ClientKey<zzaf> CLIENT_KEY = new Api.ClientKey();
    private static final Api.AbstractClientBuilder<zzaf, WalletOptions> CLIENT_BUILDER = new zzaq();
    public static final Api<WalletOptions> API = new Api("Wallet.API", CLIENT_BUILDER, CLIENT_KEY);
    @Deprecated
    public static final Payments Payments = new zzy();
    private static final WalletObjects zzer = new zzao();
    private static final zzg zzes = new zzan();

    public static PaymentsClient getPaymentsClient(@NonNull Activity activity, @NonNull WalletOptions walletOptions) {
        return new PaymentsClient(activity, walletOptions);
    }

    public static PaymentsClient getPaymentsClient(@NonNull Context context, @NonNull WalletOptions walletOptions) {
        return new PaymentsClient(context, walletOptions);
    }

    public static WalletObjectsClient getWalletObjectsClient(@NonNull Activity activity, @Nullable WalletOptions walletOptions) {
        return new WalletObjectsClient(activity, walletOptions);
    }

    private Wallet() {
    }

    public static abstract class zzb
    extends zza<Status> {
        public zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected /* synthetic */ Result createFailedResult(Status status) {
            return status;
        }
    }

    public static abstract class zza<R extends Result>
    extends BaseImplementation.ApiMethodImpl<R, zzaf> {
        public zza(GoogleApiClient googleApiClient) {
            super(API, googleApiClient);
        }

        @VisibleForTesting
        protected abstract void zza(zzaf var1) throws RemoteException;

        @VisibleForTesting
        protected /* synthetic */ void doExecute(Api.AnyClient anyClient) throws RemoteException {
            this.zza((zzaf)anyClient);
        }
    }

    public static final class WalletOptions
    implements Api.ApiOptions.HasAccountOptions {
        public final int environment;
        public final int theme;
        private final Account account;
        @VisibleForTesting
        final boolean zzet;

        private WalletOptions() {
            this(new Builder());
        }

        private WalletOptions(Builder builder) {
            this.environment = builder.environment;
            this.theme = builder.theme;
            this.zzet = builder.zzet;
            this.account = null;
        }

        public final Account getAccount() {
            return null;
        }

        public final boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof WalletOptions) {
                WalletOptions walletOptions = (WalletOptions)object;
                bl = Objects.equal((Object)this.environment, (Object)walletOptions.environment) && Objects.equal((Object)this.theme, (Object)walletOptions.theme) && Objects.equal(null, null) && Objects.equal((Object)this.zzet, (Object)walletOptions.zzet);
            }
            return bl;
        }

        public final int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.environment, this.theme, null, this.zzet});
        }

        /* synthetic */ WalletOptions(Builder builder, zzaq zzaq2) {
            this(builder);
        }

        /* synthetic */ WalletOptions(zzaq zzaq2) {
            this();
        }

        public static final class Builder {
            private int environment = 3;
            private int theme = 0;
            private boolean zzet = true;

            public final Builder setEnvironment(int n) {
                if (n != 0 && n != 0 && n != 2 && n != 1 && n != 3) {
                    String string = String.format(Locale.US, "Invalid environment value %d", n);
                    throw new IllegalArgumentException(string);
                }
                this.environment = n;
                return this;
            }

            public final Builder setTheme(int n) {
                if (n != 0 && n != 1) {
                    String string = String.format(Locale.US, "Invalid theme value %d", n);
                    throw new IllegalArgumentException(string);
                }
                this.theme = n;
                return this;
            }

            @Deprecated
            public final Builder useGoogleWallet() {
                this.zzet = false;
                return this;
            }

            public final WalletOptions build() {
                return new WalletOptions(this, null);
            }
        }
    }
}

