/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.fragment.zzc;
import com.google.android.gms.wallet.fragment.zzd;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="WalletFragmentInitParamsCreator")
public final class WalletFragmentInitParams
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final Parcelable.Creator<WalletFragmentInitParams> CREATOR = new zzd();
    @SafeParcelable.Field(id=2, getter="getAccountName")
    private String zzcj;
    @SafeParcelable.Field(id=3, getter="getMaskedWalletRequest")
    private MaskedWalletRequest zzfk;
    @SafeParcelable.Field(id=4, getter="getMaskedWalletRequestCode", defaultValue="-1")
    private int zzfz;
    @SafeParcelable.Field(id=5, getter="getMaskedWallet")
    private MaskedWallet zzfl;

    public static Builder newBuilder() {
        return new WalletFragmentInitParams().new Builder(null);
    }

    private WalletFragmentInitParams() {
        this.zzfz = -1;
    }

    @SafeParcelable.Constructor
    WalletFragmentInitParams(@SafeParcelable.Param(id=2) String string2, @SafeParcelable.Param(id=3) MaskedWalletRequest maskedWalletRequest, @SafeParcelable.Param(id=4) int n, @SafeParcelable.Param(id=5) MaskedWallet maskedWallet) {
        this.zzcj = string2;
        this.zzfk = maskedWalletRequest;
        this.zzfz = n;
        this.zzfl = maskedWallet;
    }

    public final String getAccountName() {
        return this.zzcj;
    }

    public final MaskedWalletRequest getMaskedWalletRequest() {
        return this.zzfk;
    }

    public final int getMaskedWalletRequestCode() {
        return this.zzfz;
    }

    public final MaskedWallet getMaskedWallet() {
        return this.zzfl;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        WalletFragmentInitParams walletFragmentInitParams = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)walletFragmentInitParams.getAccountName(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)3, (Parcelable)walletFragmentInitParams.getMaskedWalletRequest(), (int)n, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)4, (int)walletFragmentInitParams.getMaskedWalletRequestCode());
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)5, (Parcelable)walletFragmentInitParams.getMaskedWallet(), (int)n, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public final class Builder {
        private Builder() {
        }

        public final Builder setAccountName(String string2) {
            WalletFragmentInitParams.this.zzcj = string2;
            return this;
        }

        public final Builder setMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
            WalletFragmentInitParams.this.zzfk = maskedWalletRequest;
            return this;
        }

        public final Builder setMaskedWalletRequestCode(int n) {
            WalletFragmentInitParams.this.zzfz = n;
            return this;
        }

        public final Builder setMaskedWallet(MaskedWallet maskedWallet) {
            WalletFragmentInitParams.this.zzfl = maskedWallet;
            return this;
        }

        public final WalletFragmentInitParams build() {
            Preconditions.checkState((WalletFragmentInitParams.this.zzfl != null && WalletFragmentInitParams.this.zzfk == null || WalletFragmentInitParams.this.zzfl == null && WalletFragmentInitParams.this.zzfk != null ? 1 : 0) != 0, (Object)"Exactly one of MaskedWallet or MaskedWalletRequest is required");
            Preconditions.checkState((WalletFragmentInitParams.this.zzfz >= 0 ? 1 : 0) != 0, (Object)"masked wallet request code is required and must be non-negative");
            return WalletFragmentInitParams.this;
        }

        /* synthetic */ Builder(zzc zzc2) {
            this();
        }
    }
}

