/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.dynamic.zzf;
import com.google.android.gms.dynamic.zzh;
import com.google.android.gms.internal.zzrh;
import com.google.android.gms.internal.zzri;
import com.google.android.gms.internal.zzrp;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.fragment.WalletFragmentInitParams;
import com.google.android.gms.wallet.fragment.WalletFragmentOptions;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;

public final class SupportWalletFragment
extends Fragment {
    private zzb zzbdU;
    private boolean mCreated = false;
    private final zzh zzbdV = zzh.zza((Fragment)this);
    private final zzc zzbdW = new zzc();
    private zza zzbdX = new zza(this);
    private final Fragment zzafl = this;
    private WalletFragmentOptions zzbdY;
    private WalletFragmentInitParams zzbdZ;
    private MaskedWalletRequest zzbea;
    private MaskedWallet zzbeb;
    private Boolean zzbec;

    public static SupportWalletFragment newInstance(WalletFragmentOptions options) {
        SupportWalletFragment supportWalletFragment = new SupportWalletFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("extraWalletFragmentOptions", (Parcelable)options);
        supportWalletFragment.zzafl.setArguments(bundle);
        return supportWalletFragment;
    }

    public void initialize(WalletFragmentInitParams initParams) {
        if (this.zzbdU != null) {
            this.zzbdU.initialize(initParams);
            this.zzbdZ = null;
        } else if (this.zzbdZ == null) {
            this.zzbdZ = initParams;
            if (this.zzbea != null) {
                Log.w((String)"SupportWalletFragment", (String)"updateMaskedWalletRequest() was called before initialize()");
            }
            if (this.zzbeb != null) {
                Log.w((String)"SupportWalletFragment", (String)"updateMaskedWallet() was called before initialize()");
            }
        } else {
            Log.w((String)"SupportWalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once. Ignoring.");
        }
    }

    public void updateMaskedWalletRequest(MaskedWalletRequest request) {
        if (this.zzbdU != null) {
            this.zzbdU.updateMaskedWalletRequest(request);
            this.zzbea = null;
        } else {
            this.zzbea = request;
        }
    }

    public void updateMaskedWallet(MaskedWallet maskedWallet) {
        if (this.zzbdU != null) {
            this.zzbdU.updateMaskedWallet(maskedWallet);
            this.zzbeb = null;
        } else {
            this.zzbeb = maskedWallet;
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.zzbdU != null) {
            this.zzbdU.setEnabled(enabled);
            this.zzbec = null;
        } else {
            this.zzbec = enabled;
        }
    }

    public void setOnStateChangedListener(OnStateChangedListener listener) {
        this.zzbdX.zza(listener);
    }

    public int getState() {
        return this.zzbdU != null ? this.zzbdU.getState() : 0;
    }

    public void onInflate(Activity activity, AttributeSet attrs, Bundle savedInstanceState) {
        super.onInflate(activity, attrs, savedInstanceState);
        if (this.zzbdY == null) {
            this.zzbdY = WalletFragmentOptions.zza((Context)activity, attrs);
        }
        Bundle bundle = new Bundle();
        bundle.putParcelable("attrKeyWalletFragmentOptions", (Parcelable)this.zzbdY);
        this.zzbdW.onInflate(activity, bundle, savedInstanceState);
    }

    public void onCreate(Bundle savedInstanceState) {
        WalletFragmentOptions walletFragmentOptions;
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            savedInstanceState.setClassLoader(WalletFragmentOptions.class.getClassLoader());
            WalletFragmentInitParams walletFragmentInitParams = (WalletFragmentInitParams)savedInstanceState.getParcelable("walletFragmentInitParams");
            if (walletFragmentInitParams != null) {
                if (this.zzbdZ != null) {
                    Log.w((String)"SupportWalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once.Ignoring.");
                }
                this.zzbdZ = walletFragmentInitParams;
            }
            if (this.zzbea == null) {
                this.zzbea = (MaskedWalletRequest)savedInstanceState.getParcelable("maskedWalletRequest");
            }
            if (this.zzbeb == null) {
                this.zzbeb = (MaskedWallet)savedInstanceState.getParcelable("maskedWallet");
            }
            if (savedInstanceState.containsKey("walletFragmentOptions")) {
                this.zzbdY = (WalletFragmentOptions)savedInstanceState.getParcelable("walletFragmentOptions");
            }
            if (savedInstanceState.containsKey("enabled")) {
                this.zzbec = savedInstanceState.getBoolean("enabled");
            }
        } else if (this.zzafl.getArguments() != null && (walletFragmentOptions = (WalletFragmentOptions)this.zzafl.getArguments().getParcelable("extraWalletFragmentOptions")) != null) {
            walletFragmentOptions.zzaT((Context)this.zzafl.getActivity());
            this.zzbdY = walletFragmentOptions;
        }
        this.mCreated = true;
        this.zzbdW.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return this.zzbdW.onCreateView(inflater, container, savedInstanceState);
    }

    public void onStart() {
        super.onStart();
        this.zzbdW.onStart();
    }

    public void onResume() {
        super.onResume();
        this.zzbdW.onResume();
        FragmentManager fragmentManager = this.zzafl.getActivity().getSupportFragmentManager();
        Fragment fragment = fragmentManager.findFragmentByTag("GooglePlayServicesErrorDialog");
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commit();
            int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.zzafl.getActivity());
            GooglePlayServicesUtil.showErrorDialogFragment((int)n, (Activity)this.zzafl.getActivity(), (int)-1);
        }
    }

    public void onPause() {
        super.onPause();
        this.zzbdW.onPause();
    }

    public void onStop() {
        super.onStop();
        this.zzbdW.onStop();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.setClassLoader(WalletFragmentOptions.class.getClassLoader());
        this.zzbdW.onSaveInstanceState(outState);
        if (this.zzbdZ != null) {
            outState.putParcelable("walletFragmentInitParams", (Parcelable)this.zzbdZ);
            this.zzbdZ = null;
        }
        if (this.zzbea != null) {
            outState.putParcelable("maskedWalletRequest", (Parcelable)this.zzbea);
            this.zzbea = null;
        }
        if (this.zzbeb != null) {
            outState.putParcelable("maskedWallet", (Parcelable)this.zzbeb);
            this.zzbeb = null;
        }
        if (this.zzbdY != null) {
            outState.putParcelable("walletFragmentOptions", (Parcelable)this.zzbdY);
            this.zzbdY = null;
        }
        if (this.zzbec != null) {
            outState.putBoolean("enabled", this.zzbec.booleanValue());
            this.zzbec = null;
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.mCreated = false;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (this.zzbdU != null) {
            this.zzbdU.onActivityResult(requestCode, resultCode, data);
        }
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(SupportWalletFragment var1, int var2, int var3, Bundle var4);
    }

    static class zza
    extends zzri.zza {
        private OnStateChangedListener zzbed;
        private final SupportWalletFragment zzbee;

        zza(SupportWalletFragment supportWalletFragment) {
            this.zzbee = supportWalletFragment;
        }

        @Override
        public void zza(int n, int n2, Bundle bundle) {
            if (this.zzbed != null) {
                this.zzbed.onStateChanged(this.zzbee, n, n2, bundle);
            }
        }

        public void zza(OnStateChangedListener onStateChangedListener) {
            this.zzbed = onStateChangedListener;
        }
    }

    private static class zzb
    implements LifecycleDelegate {
        private final zzrh zzbef;

        private zzb(zzrh zzrh2) {
            this.zzbef = zzrh2;
        }

        private void initialize(WalletFragmentInitParams startParams) {
            try {
                this.zzbef.initialize(startParams);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void setEnabled(boolean enabled) {
            try {
                this.zzbef.setEnabled(enabled);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWalletRequest(MaskedWalletRequest request) {
            try {
                this.zzbef.updateMaskedWalletRequest(request);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWallet(MaskedWallet maskedWallet) {
            try {
                this.zzbef.updateMaskedWallet(maskedWallet);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private int getState() {
            try {
                return this.zzbef.getState();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onInflate(Activity activity, Bundle attrs, Bundle savedInstanceState) {
            WalletFragmentOptions walletFragmentOptions = (WalletFragmentOptions)attrs.getParcelable("extraWalletFragmentOptions");
            try {
                this.zzbef.zza(zze.zzy((Object)activity), walletFragmentOptions, savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onCreate(Bundle savedInstanceState) {
            try {
                this.zzbef.onCreate(savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            try {
                zzd zzd2 = this.zzbef.onCreateView(zze.zzy((Object)inflater), zze.zzy((Object)container), savedInstanceState);
                return (View)zze.zzp((zzd)zzd2);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onStart() {
            try {
                this.zzbef.onStart();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onResume() {
            try {
                this.zzbef.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onPause() {
            try {
                this.zzbef.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onStop() {
            try {
                this.zzbef.onStop();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onDestroyView() {
        }

        public void onDestroy() {
        }

        public void onLowMemory() {
        }

        public void onSaveInstanceState(Bundle outState) {
            try {
                this.zzbef.onSaveInstanceState(outState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void onActivityResult(int requestCode, int resultCode, Intent data) {
            try {
                this.zzbef.onActivityResult(requestCode, resultCode, data);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }
    }

    private class zzc
    extends com.google.android.gms.dynamic.zza<zzb>
    implements View.OnClickListener {
        private zzc() {
        }

        protected void zza(zzf<zzb> zzf2) {
            FragmentActivity fragmentActivity = SupportWalletFragment.this.zzafl.getActivity();
            if (SupportWalletFragment.this.zzbdU == null && SupportWalletFragment.this.mCreated && fragmentActivity != null) {
                try {
                    zzrh zzrh2 = zzrp.zza((Activity)fragmentActivity, (com.google.android.gms.dynamic.zzc)SupportWalletFragment.this.zzbdV, SupportWalletFragment.this.zzbdY, SupportWalletFragment.this.zzbdX);
                    SupportWalletFragment.this.zzbdU = new zzb(zzrh2);
                    SupportWalletFragment.this.zzbdY = null;
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return;
                }
                zzf2.zza((LifecycleDelegate)SupportWalletFragment.this.zzbdU);
                if (SupportWalletFragment.this.zzbdZ != null) {
                    SupportWalletFragment.this.zzbdU.initialize(SupportWalletFragment.this.zzbdZ);
                    SupportWalletFragment.this.zzbdZ = null;
                }
                if (SupportWalletFragment.this.zzbea != null) {
                    SupportWalletFragment.this.zzbdU.updateMaskedWalletRequest(SupportWalletFragment.this.zzbea);
                    SupportWalletFragment.this.zzbea = null;
                }
                if (SupportWalletFragment.this.zzbeb != null) {
                    SupportWalletFragment.this.zzbdU.updateMaskedWallet(SupportWalletFragment.this.zzbeb);
                    SupportWalletFragment.this.zzbeb = null;
                }
                if (SupportWalletFragment.this.zzbec != null) {
                    SupportWalletFragment.this.zzbdU.setEnabled(SupportWalletFragment.this.zzbec);
                    SupportWalletFragment.this.zzbec = null;
                }
            }
        }

        protected void zza(FrameLayout frameLayout) {
            WalletFragmentStyle walletFragmentStyle;
            Button button = new Button((Context)SupportWalletFragment.this.zzafl.getActivity());
            button.setText(R.string.wallet_buy_button_place_holder);
            int n = -1;
            int n2 = -2;
            if (SupportWalletFragment.this.zzbdY != null && (walletFragmentStyle = SupportWalletFragment.this.zzbdY.getFragmentStyle()) != null) {
                DisplayMetrics displayMetrics = SupportWalletFragment.this.zzafl.getResources().getDisplayMetrics();
                n = walletFragmentStyle.zza("buyButtonWidth", displayMetrics, n);
                n2 = walletFragmentStyle.zza("buyButtonHeight", displayMetrics, n2);
            }
            button.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            button.setOnClickListener((View.OnClickListener)this);
            frameLayout.addView((View)button);
        }

        public void onClick(View view) {
            FragmentActivity fragmentActivity = SupportWalletFragment.this.zzafl.getActivity();
            int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)fragmentActivity);
            GooglePlayServicesUtil.showErrorDialogFragment((int)n, (Activity)fragmentActivity, (int)-1);
        }
    }
}

