/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wallet.Cart;
import com.google.android.gms.wallet.CountrySpecification;
import com.google.android.gms.wallet.PaymentMethodTokenizationParameters;
import com.google.android.gms.wallet.zzl;
import java.util.ArrayList;
import java.util.Collection;

public final class MaskedWalletRequest
implements SafeParcelable {
    public static final Parcelable.Creator<MaskedWalletRequest> CREATOR = new zzl();
    private final int mVersionCode;
    String zzbjh;
    boolean zzbkc;
    boolean zzbkd;
    boolean zzbke;
    String zzbkf;
    String zzbja;
    String zzbkg;
    Cart zzbjr;
    boolean zzbkh;
    boolean zzbki;
    CountrySpecification[] zzbkj;
    boolean zzbkk;
    boolean zzbkl;
    ArrayList<com.google.android.gms.identity.intents.model.CountrySpecification> zzbkm;
    PaymentMethodTokenizationParameters zzbkn;
    ArrayList<Integer> zzbko;

    public static Builder newBuilder() {
        MaskedWalletRequest maskedWalletRequest = new MaskedWalletRequest();
        maskedWalletRequest.getClass();
        return maskedWalletRequest.new Builder();
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzl.zza(this, dest, flags);
    }

    MaskedWalletRequest(int versionCode, String merchantTransactionId, boolean phoneNumberRequired, boolean shippingAddressRequired, boolean useMinimalBillingAddress, String estimatedTotalPrice, String currencyCode, String merchantName, Cart cart, boolean shouldRetrieveWalletObjects, boolean isBillingAgreement, CountrySpecification[] allowedShippingCountrySpecifications, boolean allowPrepaidCard, boolean allowDebitCard, ArrayList<com.google.android.gms.identity.intents.model.CountrySpecification> allowedCountrySpecificationsForShipping, PaymentMethodTokenizationParameters paymentMethodTokenizationParameters, ArrayList<Integer> allowedCardNetworks) {
        this.mVersionCode = versionCode;
        this.zzbjh = merchantTransactionId;
        this.zzbkc = phoneNumberRequired;
        this.zzbkd = shippingAddressRequired;
        this.zzbke = useMinimalBillingAddress;
        this.zzbkf = estimatedTotalPrice;
        this.zzbja = currencyCode;
        this.zzbkg = merchantName;
        this.zzbjr = cart;
        this.zzbkh = shouldRetrieveWalletObjects;
        this.zzbki = isBillingAgreement;
        this.zzbkj = allowedShippingCountrySpecifications;
        this.zzbkk = allowPrepaidCard;
        this.zzbkl = allowDebitCard;
        this.zzbkm = allowedCountrySpecificationsForShipping;
        this.zzbkn = paymentMethodTokenizationParameters;
        this.zzbko = allowedCardNetworks;
    }

    MaskedWalletRequest() {
        this.mVersionCode = 3;
        this.zzbkk = true;
        this.zzbkl = true;
    }

    public String getMerchantTransactionId() {
        return this.zzbjh;
    }

    public boolean isPhoneNumberRequired() {
        return this.zzbkc;
    }

    public boolean isShippingAddressRequired() {
        return this.zzbkd;
    }

    @Deprecated
    public boolean useMinimalBillingAddress() {
        return this.zzbke;
    }

    public String getEstimatedTotalPrice() {
        return this.zzbkf;
    }

    public String getCurrencyCode() {
        return this.zzbja;
    }

    public String getMerchantName() {
        return this.zzbkg;
    }

    public Cart getCart() {
        return this.zzbjr;
    }

    @Deprecated
    public boolean isBillingAgreement() {
        return this.zzbki;
    }

    public CountrySpecification[] getAllowedShippingCountrySpecifications() {
        return this.zzbkj;
    }

    public boolean allowPrepaidCard() {
        return this.zzbkk;
    }

    public boolean allowDebitCard() {
        return this.zzbkl;
    }

    public ArrayList<com.google.android.gms.identity.intents.model.CountrySpecification> getAllowedCountrySpecificationsForShipping() {
        return this.zzbkm;
    }

    public PaymentMethodTokenizationParameters getPaymentMethodTokenizationParameters() {
        return this.zzbkn;
    }

    public ArrayList<Integer> getAllowedCardNetworks() {
        return this.zzbko;
    }

    public final class Builder {
        private Builder() {
        }

        public Builder setMerchantTransactionId(String merchantTransactionId) {
            MaskedWalletRequest.this.zzbjh = merchantTransactionId;
            return this;
        }

        public Builder setPhoneNumberRequired(boolean phoneNumberRequired) {
            MaskedWalletRequest.this.zzbkc = phoneNumberRequired;
            return this;
        }

        public Builder setShippingAddressRequired(boolean shippingAddressRequired) {
            MaskedWalletRequest.this.zzbkd = shippingAddressRequired;
            return this;
        }

        @Deprecated
        public Builder setUseMinimalBillingAddress(boolean useMinimalBillingAddress) {
            MaskedWalletRequest.this.zzbke = useMinimalBillingAddress;
            return this;
        }

        public Builder setEstimatedTotalPrice(String estimatedTotalPrice) {
            MaskedWalletRequest.this.zzbkf = estimatedTotalPrice;
            return this;
        }

        public Builder setCurrencyCode(String currencyCode) {
            MaskedWalletRequest.this.zzbja = currencyCode;
            return this;
        }

        public Builder setMerchantName(String merchantName) {
            MaskedWalletRequest.this.zzbkg = merchantName;
            return this;
        }

        public Builder setCart(Cart cart) {
            MaskedWalletRequest.this.zzbjr = cart;
            return this;
        }

        @Deprecated
        public Builder setIsBillingAgreement(boolean isBillingAgreement) {
            MaskedWalletRequest.this.zzbki = isBillingAgreement;
            return this;
        }

        public Builder setAllowPrepaidCard(boolean allowPrepaidCard) {
            MaskedWalletRequest.this.zzbkk = allowPrepaidCard;
            return this;
        }

        public Builder setAllowDebitCard(boolean allowDebitCard) {
            MaskedWalletRequest.this.zzbkl = allowDebitCard;
            return this;
        }

        public Builder addAllowedCountrySpecificationForShipping(com.google.android.gms.identity.intents.model.CountrySpecification countrySpecification) {
            if (MaskedWalletRequest.this.zzbkm == null) {
                MaskedWalletRequest.this.zzbkm = new ArrayList();
            }
            MaskedWalletRequest.this.zzbkm.add(countrySpecification);
            return this;
        }

        public Builder addAllowedCountrySpecificationsForShipping(Collection<com.google.android.gms.identity.intents.model.CountrySpecification> countrySpecifications) {
            if (countrySpecifications != null) {
                if (MaskedWalletRequest.this.zzbkm == null) {
                    MaskedWalletRequest.this.zzbkm = new ArrayList();
                }
                MaskedWalletRequest.this.zzbkm.addAll(countrySpecifications);
            }
            return this;
        }

        public Builder setPaymentMethodTokenizationParameters(PaymentMethodTokenizationParameters paymentMethodTokenizationParameters) {
            MaskedWalletRequest.this.zzbkn = paymentMethodTokenizationParameters;
            return this;
        }

        public Builder addAllowedCardNetwork(int allowedCardNetwork) {
            if (MaskedWalletRequest.this.zzbko == null) {
                MaskedWalletRequest.this.zzbko = new ArrayList();
            }
            MaskedWalletRequest.this.zzbko.add(allowedCardNetwork);
            return this;
        }

        public Builder addAllowedCardNetworks(Collection<Integer> allowedCardNetworks) {
            if (allowedCardNetworks != null) {
                if (MaskedWalletRequest.this.zzbko == null) {
                    MaskedWalletRequest.this.zzbko = new ArrayList();
                }
                MaskedWalletRequest.this.zzbko.addAll(allowedCardNetworks);
            }
            return this;
        }

        public MaskedWalletRequest build() {
            return MaskedWalletRequest.this;
        }
    }
}

