/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.dynamic.zzf;
import com.google.android.gms.internal.zzrx;
import com.google.android.gms.internal.zzry;
import com.google.android.gms.internal.zzsf;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.fragment.WalletFragmentInitParams;
import com.google.android.gms.wallet.fragment.WalletFragmentOptions;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;

@TargetApi(value=12)
public final class WalletFragment
extends Fragment {
    private zzb zzbqj;
    private boolean mCreated = false;
    private final com.google.android.gms.dynamic.zzb zzbqk = com.google.android.gms.dynamic.zzb.zza((Fragment)this);
    private final zzc zzbql = new zzc();
    private zza zzbqm = new zza(this);
    private final Fragment zzavH = this;
    private WalletFragmentOptions zzbqa;
    private WalletFragmentInitParams zzbqb;
    private MaskedWalletRequest zzbqc;
    private MaskedWallet zzbqd;
    private Boolean zzbqe;

    public static WalletFragment newInstance(WalletFragmentOptions options) {
        WalletFragment walletFragment = new WalletFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("extraWalletFragmentOptions", (Parcelable)options);
        walletFragment.zzavH.setArguments(bundle);
        return walletFragment;
    }

    public void initialize(WalletFragmentInitParams initParams) {
        if (this.zzbqj != null) {
            this.zzbqj.initialize(initParams);
            this.zzbqb = null;
        } else if (this.zzbqb == null) {
            this.zzbqb = initParams;
            if (this.zzbqc != null) {
                Log.w((String)"WalletFragment", (String)"updateMaskedWalletRequest() was called before initialize()");
            }
            if (this.zzbqd != null) {
                Log.w((String)"WalletFragment", (String)"updateMaskedWallet() was called before initialize()");
            }
        } else {
            Log.w((String)"WalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once. Ignoring.");
        }
    }

    public void updateMaskedWalletRequest(MaskedWalletRequest request) {
        if (this.zzbqj != null) {
            this.zzbqj.updateMaskedWalletRequest(request);
            this.zzbqc = null;
        } else {
            this.zzbqc = request;
        }
    }

    public void updateMaskedWallet(MaskedWallet maskedWallet) {
        if (this.zzbqj != null) {
            this.zzbqj.updateMaskedWallet(maskedWallet);
            this.zzbqd = null;
        } else {
            this.zzbqd = maskedWallet;
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.zzbqj != null) {
            this.zzbqj.setEnabled(enabled);
            this.zzbqe = null;
        } else {
            this.zzbqe = enabled;
        }
    }

    public void setOnStateChangedListener(OnStateChangedListener listener) {
        this.zzbqm.zza(listener);
    }

    public int getState() {
        return this.zzbqj != null ? this.zzbqj.getState() : 0;
    }

    public void onInflate(Activity activity, AttributeSet attrs, Bundle savedInstanceState) {
        super.onInflate(activity, attrs, savedInstanceState);
        if (this.zzbqa == null) {
            this.zzbqa = WalletFragmentOptions.zzb((Context)activity, attrs);
        }
        Bundle bundle = new Bundle();
        bundle.putParcelable("attrKeyWalletFragmentOptions", (Parcelable)this.zzbqa);
        this.zzbql.onInflate(activity, bundle, savedInstanceState);
    }

    public void onCreate(Bundle savedInstanceState) {
        WalletFragmentOptions walletFragmentOptions;
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            savedInstanceState.setClassLoader(WalletFragmentOptions.class.getClassLoader());
            WalletFragmentInitParams walletFragmentInitParams = (WalletFragmentInitParams)savedInstanceState.getParcelable("walletFragmentInitParams");
            if (walletFragmentInitParams != null) {
                if (this.zzbqb != null) {
                    Log.w((String)"WalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once.Ignoring.");
                }
                this.zzbqb = walletFragmentInitParams;
            }
            if (this.zzbqc == null) {
                this.zzbqc = (MaskedWalletRequest)savedInstanceState.getParcelable("maskedWalletRequest");
            }
            if (this.zzbqd == null) {
                this.zzbqd = (MaskedWallet)savedInstanceState.getParcelable("maskedWallet");
            }
            if (savedInstanceState.containsKey("walletFragmentOptions")) {
                this.zzbqa = (WalletFragmentOptions)savedInstanceState.getParcelable("walletFragmentOptions");
            }
            if (savedInstanceState.containsKey("enabled")) {
                this.zzbqe = savedInstanceState.getBoolean("enabled");
            }
        } else if (this.zzavH.getArguments() != null && (walletFragmentOptions = (WalletFragmentOptions)this.zzavH.getArguments().getParcelable("extraWalletFragmentOptions")) != null) {
            walletFragmentOptions.zzbc((Context)this.zzavH.getActivity());
            this.zzbqa = walletFragmentOptions;
        }
        this.mCreated = true;
        this.zzbql.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return this.zzbql.onCreateView(inflater, container, savedInstanceState);
    }

    public void onStart() {
        super.onStart();
        this.zzbql.onStart();
    }

    public void onResume() {
        super.onResume();
        this.zzbql.onResume();
        FragmentManager fragmentManager = this.zzavH.getActivity().getFragmentManager();
        Fragment fragment = fragmentManager.findFragmentByTag("GooglePlayServicesErrorDialog");
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commit();
            int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.zzavH.getActivity());
            GooglePlayServicesUtil.showErrorDialogFragment((int)n, (Activity)this.zzavH.getActivity(), (int)-1);
        }
    }

    public void onPause() {
        super.onPause();
        this.zzbql.onPause();
    }

    public void onStop() {
        super.onStop();
        this.zzbql.onStop();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.setClassLoader(WalletFragmentOptions.class.getClassLoader());
        this.zzbql.onSaveInstanceState(outState);
        if (this.zzbqb != null) {
            outState.putParcelable("walletFragmentInitParams", (Parcelable)this.zzbqb);
            this.zzbqb = null;
        }
        if (this.zzbqc != null) {
            outState.putParcelable("maskedWalletRequest", (Parcelable)this.zzbqc);
            this.zzbqc = null;
        }
        if (this.zzbqd != null) {
            outState.putParcelable("maskedWallet", (Parcelable)this.zzbqd);
            this.zzbqd = null;
        }
        if (this.zzbqa != null) {
            outState.putParcelable("walletFragmentOptions", (Parcelable)this.zzbqa);
            this.zzbqa = null;
        }
        if (this.zzbqe != null) {
            outState.putBoolean("enabled", this.zzbqe.booleanValue());
            this.zzbqe = null;
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.mCreated = false;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (this.zzbqj != null) {
            this.zzbqj.onActivityResult(requestCode, resultCode, data);
        }
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(WalletFragment var1, int var2, int var3, Bundle var4);
    }

    static class zza
    extends zzry.zza {
        private OnStateChangedListener zzbqn;
        private final WalletFragment zzbqo;

        zza(WalletFragment walletFragment) {
            this.zzbqo = walletFragment;
        }

        @Override
        public void zza(int n, int n2, Bundle bundle) {
            if (this.zzbqn != null) {
                this.zzbqn.onStateChanged(this.zzbqo, n, n2, bundle);
            }
        }

        public void zza(OnStateChangedListener onStateChangedListener) {
            this.zzbqn = onStateChangedListener;
        }
    }

    private static class zzb
    implements LifecycleDelegate {
        private final zzrx zzbqh;

        private zzb(zzrx zzrx2) {
            this.zzbqh = zzrx2;
        }

        private void initialize(WalletFragmentInitParams startParams) {
            try {
                this.zzbqh.initialize(startParams);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void setEnabled(boolean enabled) {
            try {
                this.zzbqh.setEnabled(enabled);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWalletRequest(MaskedWalletRequest request) {
            try {
                this.zzbqh.updateMaskedWalletRequest(request);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWallet(MaskedWallet maskedWallet) {
            try {
                this.zzbqh.updateMaskedWallet(maskedWallet);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private int getState() {
            try {
                return this.zzbqh.getState();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onInflate(Activity activity, Bundle attrs, Bundle savedInstanceState) {
            WalletFragmentOptions walletFragmentOptions = (WalletFragmentOptions)attrs.getParcelable("extraWalletFragmentOptions");
            try {
                this.zzbqh.zza(zze.zzC((Object)activity), walletFragmentOptions, savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onCreate(Bundle savedInstanceState) {
            try {
                this.zzbqh.onCreate(savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            try {
                zzd zzd2 = this.zzbqh.onCreateView(zze.zzC((Object)inflater), zze.zzC((Object)container), savedInstanceState);
                return (View)zze.zzp((zzd)zzd2);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onStart() {
            try {
                this.zzbqh.onStart();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onResume() {
            try {
                this.zzbqh.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onPause() {
            try {
                this.zzbqh.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onStop() {
            try {
                this.zzbqh.onStop();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onDestroyView() {
        }

        public void onDestroy() {
        }

        public void onLowMemory() {
        }

        public void onSaveInstanceState(Bundle outState) {
            try {
                this.zzbqh.onSaveInstanceState(outState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void onActivityResult(int requestCode, int resultCode, Intent data) {
            try {
                this.zzbqh.onActivityResult(requestCode, resultCode, data);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }
    }

    private class zzc
    extends com.google.android.gms.dynamic.zza<zzb>
    implements View.OnClickListener {
        private zzc() {
        }

        protected void zza(zzf<zzb> zzf2) {
            Activity activity = WalletFragment.this.zzavH.getActivity();
            if (WalletFragment.this.zzbqj == null && WalletFragment.this.mCreated && activity != null) {
                try {
                    zzrx zzrx2 = zzsf.zza(activity, (com.google.android.gms.dynamic.zzc)WalletFragment.this.zzbqk, WalletFragment.this.zzbqa, WalletFragment.this.zzbqm);
                    WalletFragment.this.zzbqj = new zzb(zzrx2);
                    WalletFragment.this.zzbqa = null;
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return;
                }
                zzf2.zza((LifecycleDelegate)WalletFragment.this.zzbqj);
                if (WalletFragment.this.zzbqb != null) {
                    WalletFragment.this.zzbqj.initialize(WalletFragment.this.zzbqb);
                    WalletFragment.this.zzbqb = null;
                }
                if (WalletFragment.this.zzbqc != null) {
                    WalletFragment.this.zzbqj.updateMaskedWalletRequest(WalletFragment.this.zzbqc);
                    WalletFragment.this.zzbqc = null;
                }
                if (WalletFragment.this.zzbqd != null) {
                    WalletFragment.this.zzbqj.updateMaskedWallet(WalletFragment.this.zzbqd);
                    WalletFragment.this.zzbqd = null;
                }
                if (WalletFragment.this.zzbqe != null) {
                    WalletFragment.this.zzbqj.setEnabled(WalletFragment.this.zzbqe);
                    WalletFragment.this.zzbqe = null;
                }
            }
        }

        protected void zza(FrameLayout frameLayout) {
            WalletFragmentStyle walletFragmentStyle;
            Button button = new Button((Context)WalletFragment.this.zzavH.getActivity());
            button.setText(R.string.wallet_buy_button_place_holder);
            int n = -1;
            int n2 = -2;
            if (WalletFragment.this.zzbqa != null && (walletFragmentStyle = WalletFragment.this.zzbqa.getFragmentStyle()) != null) {
                DisplayMetrics displayMetrics = WalletFragment.this.zzavH.getResources().getDisplayMetrics();
                n = walletFragmentStyle.zza("buyButtonWidth", displayMetrics, n);
                n2 = walletFragmentStyle.zza("buyButtonHeight", displayMetrics, n2);
            }
            button.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            button.setOnClickListener((View.OnClickListener)this);
            frameLayout.addView((View)button);
        }

        public void onClick(View view) {
            Activity activity = WalletFragment.this.zzavH.getActivity();
            int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)activity);
            GooglePlayServicesUtil.showErrorDialogFragment((int)n, (Activity)activity, (int)-1);
        }
    }
}

