/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;
import com.google.android.gms.wallet.fragment.zzb;

public final class WalletFragmentOptions
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final Parcelable.Creator<WalletFragmentOptions> CREATOR = new zzb();
    final int mVersionCode;
    private int aHp;
    private int mTheme;
    private WalletFragmentStyle aId;
    private int Dr;

    public static Builder newBuilder() {
        WalletFragmentOptions walletFragmentOptions = new WalletFragmentOptions();
        ((Object)((Object)walletFragmentOptions)).getClass();
        return walletFragmentOptions.new Builder();
    }

    private WalletFragmentOptions() {
        this.mVersionCode = 1;
        this.aHp = 3;
        this.aId = new WalletFragmentStyle();
    }

    WalletFragmentOptions(int n, int n2, int n3, WalletFragmentStyle walletFragmentStyle, int n4) {
        this.mVersionCode = n;
        this.aHp = n2;
        this.mTheme = n3;
        this.aId = walletFragmentStyle;
        this.Dr = n4;
    }

    public int getEnvironment() {
        return this.aHp;
    }

    public int getTheme() {
        return this.mTheme;
    }

    public WalletFragmentStyle getFragmentStyle() {
        return this.aId;
    }

    public int getMode() {
        return this.Dr;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzb.zza(this, parcel, n);
    }

    public void zzei(Context context) {
        if (this.aId != null) {
            this.aId.zzei(context);
        }
    }

    public static WalletFragmentOptions zzc(Context context, AttributeSet attributeSet) {
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.WalletFragmentOptions);
        int n = typedArray.getInt(R.styleable.WalletFragmentOptions_appTheme, 0);
        int n2 = typedArray.getInt(R.styleable.WalletFragmentOptions_environment, 1);
        int n3 = typedArray.getResourceId(R.styleable.WalletFragmentOptions_fragmentStyle, 0);
        int n4 = typedArray.getInt(R.styleable.WalletFragmentOptions_fragmentMode, 1);
        typedArray.recycle();
        WalletFragmentOptions walletFragmentOptions = new WalletFragmentOptions();
        walletFragmentOptions.mTheme = n;
        walletFragmentOptions.aHp = n2;
        walletFragmentOptions.aId = new WalletFragmentStyle().setStyleResourceId(n3);
        walletFragmentOptions.aId.zzei(context);
        walletFragmentOptions.Dr = n4;
        return walletFragmentOptions;
    }

    public final class Builder {
        private Builder() {
        }

        public Builder setEnvironment(int n) {
            WalletFragmentOptions.this.aHp = n;
            return this;
        }

        public Builder setTheme(int n) {
            WalletFragmentOptions.this.mTheme = n;
            return this;
        }

        public Builder setFragmentStyle(int n) {
            WalletFragmentOptions.this.aId = new WalletFragmentStyle().setStyleResourceId(n);
            return this;
        }

        public Builder setFragmentStyle(WalletFragmentStyle walletFragmentStyle) {
            WalletFragmentOptions.this.aId = walletFragmentStyle;
            return this;
        }

        public Builder setMode(int n) {
            WalletFragmentOptions.this.Dr = n;
            return this;
        }

        public WalletFragmentOptions build() {
            return WalletFragmentOptions.this;
        }
    }
}

