/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.annotation.SuppressLint;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Binder;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.util.zzx;
import com.google.android.gms.common.zzf;
import com.google.android.gms.wearable.CapabilityApi;
import com.google.android.gms.wearable.CapabilityInfo;
import com.google.android.gms.wearable.Channel;
import com.google.android.gms.wearable.ChannelApi;
import com.google.android.gms.wearable.DataApi;
import com.google.android.gms.wearable.DataEventBuffer;
import com.google.android.gms.wearable.MessageApi;
import com.google.android.gms.wearable.MessageEvent;
import com.google.android.gms.wearable.Node;
import com.google.android.gms.wearable.NodeApi;
import com.google.android.gms.wearable.internal.zzbv;
import com.google.android.gms.wearable.internal.zzbz;
import com.google.android.gms.wearable.internal.zzcc;
import com.google.android.gms.wearable.internal.zzh;
import com.google.android.gms.wearable.internal.zzk;
import com.google.android.gms.wearable.internal.zzo;
import com.google.android.gms.wearable.internal.zzs;
import com.google.android.gms.wearable.zzd;
import java.util.List;

public abstract class WearableListenerService
extends Service
implements CapabilityApi.CapabilityListener,
ChannelApi.ChannelListener,
DataApi.DataListener,
MessageApi.MessageListener,
NodeApi.NodeListener {
    public static final String BIND_LISTENER_INTENT_ACTION = "com.google.android.gms.wearable.BIND_LISTENER";
    private ComponentName zzbRg;
    private zzb zzbRh;
    private IBinder zzaEa;
    private Intent zzbRi;
    private final Object zzbRj = new Object();
    private boolean zzbRk;

    public void onCreate() {
        String string;
        super.onCreate();
        this.zzbRg = new ComponentName((Context)this, this.getClass().getName());
        if (Log.isLoggable((String)"WearableLS", (int)3)) {
            string = String.valueOf(this.zzbRg);
            Log.d((String)"WearableLS", (String)new StringBuilder(10 + String.valueOf(string).length()).append("onCreate: ").append(string).toString());
        }
        string = new HandlerThread("WearableListenerService");
        string.start();
        this.zzbRh = new zzb(string.getLooper());
        this.zzbRi = new Intent(BIND_LISTENER_INTENT_ACTION);
        this.zzbRi.setComponent(this.zzbRg);
        this.zzaEa = new zzc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDestroy() {
        Object object;
        if (Log.isLoggable((String)"WearableLS", (int)3)) {
            object = String.valueOf(this.zzbRg);
            Log.d((String)"WearableLS", (String)new StringBuilder(11 + String.valueOf(object).length()).append("onDestroy: ").append((String)object).toString());
        }
        object = this.zzbRj;
        synchronized (object) {
            this.zzbRk = true;
            if (this.zzbRh == null) {
                String string = String.valueOf(this.zzbRg);
                throw new IllegalStateException(new StringBuilder(111 + String.valueOf(string).length()).append("onDestroy: mServiceHandler not set, did you override onCreate() but forget to call super.onCreate()? component=").append(string).toString());
            }
            this.zzbRh.quit();
        }
        super.onDestroy();
    }

    public final IBinder onBind(Intent intent) {
        if (BIND_LISTENER_INTENT_ACTION.equals(intent.getAction())) {
            return this.zzaEa;
        }
        return null;
    }

    @Override
    public void onDataChanged(DataEventBuffer dataEventBuffer) {
    }

    @Override
    public void onMessageReceived(MessageEvent messageEvent) {
    }

    @Override
    public void onPeerConnected(Node node) {
    }

    @Override
    public void onPeerDisconnected(Node node) {
    }

    public void onConnectedNodes(List<Node> list) {
    }

    @Override
    public void onCapabilityChanged(CapabilityInfo capabilityInfo) {
    }

    @Override
    public void onChannelOpened(Channel channel) {
    }

    @Override
    public void onChannelClosed(Channel channel, int n, int n2) {
    }

    @Override
    public void onInputClosed(Channel channel, int n, int n2) {
    }

    @Override
    public void onOutputClosed(Channel channel, int n, int n2) {
    }

    public void onNotificationReceived(zzd zzd2) {
    }

    public void onEntityUpdate(com.google.android.gms.wearable.zzb zzb2) {
    }

    private final class zzc
    extends zzbv.zza {
        private volatile int zzbRn = -1;

        private zzc() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void zzaq(final DataHolder dataHolder) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    DataEventBuffer dataEventBuffer = new DataEventBuffer(dataHolder);
                    try {
                        WearableListenerService.this.onDataChanged(dataEventBuffer);
                    }
                    finally {
                        dataEventBuffer.release();
                    }
                }
            };
            try {
                String string = String.valueOf(dataHolder);
                int n = dataHolder.getCount();
                boolean bl = this.zza(runnable, "onDataItemChanged", new StringBuilder(18 + String.valueOf(string).length()).append(string).append(", rows=").append(n).toString());
                if (bl) return;
            }
            catch (Throwable throwable) {
                dataHolder.close();
                throw throwable;
            }
            dataHolder.close();
        }

        @Override
        public void zza(final zzbz zzbz2) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WearableListenerService.this.onMessageReceived(zzbz2);
                }
            };
            this.zza(runnable, "onMessageReceived", zzbz2);
        }

        @Override
        public void zza(final zzcc zzcc2) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WearableListenerService.this.onPeerConnected(zzcc2);
                }
            };
            this.zza(runnable, "onPeerConnected", zzcc2);
        }

        @Override
        public void zzb(final zzcc zzcc2) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WearableListenerService.this.onPeerDisconnected(zzcc2);
                }
            };
            this.zza(runnable, "onPeerDisconnected", zzcc2);
        }

        @Override
        public void onConnectedNodes(final List<zzcc> list) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WearableListenerService.this.onConnectedNodes(list);
                }
            };
            this.zza(runnable, "onConnectedNodes", list);
        }

        @Override
        public void zza(final zzo zzo2) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WearableListenerService.this.onCapabilityChanged(zzo2);
                }
            };
            this.zza(runnable, "onConnectedCapabilityChanged", zzo2);
        }

        @Override
        public void zza(final zzk zzk2) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WearableListenerService.this.onNotificationReceived(zzk2);
                }
            };
            this.zza(runnable, "onNotificationReceived", zzk2);
        }

        @Override
        public void zza(final zzh zzh2) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WearableListenerService.this.onEntityUpdate(zzh2);
                }
            };
            this.zza(runnable, "onEntityUpdate", zzh2);
        }

        @Override
        public void zza(final zzs zzs2) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    zzs2.zza(WearableListenerService.this);
                }
            };
            this.zza(runnable, "onChannelEvent", (Object)zzs2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean zza(Runnable runnable, String string, Object object) {
            if (Log.isLoggable((String)"WearableLS", (int)3)) {
                Log.d((String)"WearableLS", (String)String.format("%s: %s %s", string, WearableListenerService.this.zzbRg.toString(), object));
            }
            if (!this.zzSH()) {
                return false;
            }
            Object object2 = WearableListenerService.this.zzbRj;
            synchronized (object2) {
                if (WearableListenerService.this.zzbRk) {
                    return false;
                }
                WearableListenerService.this.zzbRh.post(runnable);
            }
            return true;
        }

        private boolean zzSH() {
            int n = Binder.getCallingUid();
            if (n == this.zzbRn) {
                return true;
            }
            if (zzf.zzav((Context)WearableListenerService.this).zzb(WearableListenerService.this.getPackageManager(), "com.google.android.wearable.app.cn") && GooglePlayServicesUtil.zzc((Context)WearableListenerService.this, (int)n, (String)"com.google.android.wearable.app.cn")) {
                this.zzbRn = n;
                return true;
            }
            if (zzx.zzf((Context)WearableListenerService.this, (int)n)) {
                this.zzbRn = n;
                return true;
            }
            Log.e((String)"WearableLS", (String)new StringBuilder(57).append("Caller is not GooglePlayServices; caller UID: ").append(n).toString());
            return false;
        }
    }

    private final class zzb
    extends Handler {
        private boolean started;
        private final zza zzbRl;

        zzb(Looper looper) {
            super(looper);
            this.zzbRl = new zza(WearableListenerService.this);
        }

        public void dispatchMessage(Message message) {
            this.zzSG();
            try {
                super.dispatchMessage(message);
            }
            finally {
                if (!this.hasMessages(0)) {
                    this.zzir("dispatch");
                }
            }
        }

        void quit() {
            this.getLooper().quit();
            this.zzir("quit");
        }

        @SuppressLint(value={"UntrackedBindService"})
        private synchronized void zzSG() {
            if (this.started) {
                return;
            }
            if (Log.isLoggable((String)"WearableLS", (int)2)) {
                String string = String.valueOf(WearableListenerService.this.zzbRg);
                Log.v((String)"WearableLS", (String)new StringBuilder(13 + String.valueOf(string).length()).append("bindService: ").append(string).toString());
            }
            WearableListenerService.this.bindService(WearableListenerService.this.zzbRi, this.zzbRl, 1);
            this.started = true;
        }

        @SuppressLint(value={"UntrackedBindService"})
        private synchronized void zzir(String string) {
            if (!this.started) {
                return;
            }
            if (Log.isLoggable((String)"WearableLS", (int)2)) {
                String string2 = String.valueOf(WearableListenerService.this.zzbRg);
                Log.v((String)"WearableLS", (String)new StringBuilder(17 + String.valueOf(string).length() + String.valueOf(string2).length()).append("unbindService: ").append(string).append(", ").append(string2).toString());
            }
            try {
                WearableListenerService.this.unbindService(this.zzbRl);
            }
            catch (RuntimeException runtimeException) {
                Log.e((String)"WearableLS", (String)"Exception when unbinding from local service", (Throwable)runtimeException);
            }
            this.started = false;
        }
    }

    private class zza
    implements ServiceConnection {
        private zza(WearableListenerService wearableListenerService) {
        }

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        }

        public void onServiceDisconnected(ComponentName componentName) {
        }
    }
}

