/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.common.zzc;
import com.google.android.gms.common.zzf;
import com.google.android.gms.internal.zzaaz;
import com.google.android.gms.internal.zzzv;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.CapabilityApi;
import com.google.android.gms.wearable.Channel;
import com.google.android.gms.wearable.ChannelApi;
import com.google.android.gms.wearable.DataApi;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.DataItemBuffer;
import com.google.android.gms.wearable.MessageApi;
import com.google.android.gms.wearable.NodeApi;
import com.google.android.gms.wearable.PutDataRequest;
import com.google.android.gms.wearable.internal.zzac;
import com.google.android.gms.wearable.internal.zzbu;
import com.google.android.gms.wearable.internal.zzbw;
import com.google.android.gms.wearable.internal.zzbx;
import com.google.android.gms.wearable.internal.zzci;
import com.google.android.gms.wearable.internal.zzcq;
import com.google.android.gms.wearable.internal.zzcw;
import com.google.android.gms.wearable.internal.zzcy;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;

public class zzcx
extends zzl<zzbw> {
    private final ExecutorService zzbFy;
    private final zzbx<Object> zzbSV = new zzbx();
    private final zzbx<Object> zzbSW = new zzbx();
    private final zzbx<ChannelApi.ChannelListener> zzbSX = new zzbx();
    private final zzbx<DataApi.DataListener> zzbSY = new zzbx();
    private final zzbx<MessageApi.MessageListener> zzbSZ = new zzbx();
    private final zzbx<NodeApi.NodeListener> zzbTa = new zzbx();
    private final zzbx<Object> zzbTb = new zzbx();
    private final zzbx<CapabilityApi.CapabilityListener> zzbTc = new zzbx();
    private zzf zzbTd;

    public zzcx(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, zzg zzg2) {
        this(context, looper, connectionCallbacks, onConnectionFailedListener, zzg2, Executors.newCachedThreadPool(), zzf.zzav((Context)context));
    }

    zzcx(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, zzg zzg2, ExecutorService executorService, zzf zzf2) {
        super(context, looper, 14, zzg2, connectionCallbacks, onConnectionFailedListener);
        this.zzbFy = (ExecutorService)com.google.android.gms.common.internal.zzac.zzw((Object)executorService);
        this.zzbTd = zzf2;
    }

    protected String zzeu() {
        return "com.google.android.gms.wearable.BIND";
    }

    protected String zzwP() {
        if (this.zzbTd.zzb(this.getContext().getPackageManager(), "com.google.android.wearable.app.cn")) {
            return "com.google.android.wearable.app.cn";
        }
        return "com.google.android.gms";
    }

    protected String zzev() {
        return "com.google.android.gms.wearable.internal.IWearableService";
    }

    public boolean zzuI() {
        return !this.zzbTd.zzb(this.getContext().getPackageManager(), "com.google.android.wearable.app.cn");
    }

    protected zzbw zzfz(IBinder iBinder) {
        return zzbw.zza.zzfx(iBinder);
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (Log.isLoggable((String)"WearableClient", (int)2)) {
            Log.d((String)"WearableClient", (String)new StringBuilder(41).append("onPostInitHandler: statusCode ").append(n).toString());
        }
        if (n == 0) {
            this.zzbSV.zzfy(iBinder);
            this.zzbSW.zzfy(iBinder);
            this.zzbSX.zzfy(iBinder);
            this.zzbSY.zzfy(iBinder);
            this.zzbSZ.zzfy(iBinder);
            this.zzbTa.zzfy(iBinder);
            this.zzbTb.zzfy(iBinder);
            this.zzbTc.zzfy(iBinder);
        }
        super.zza(n, iBinder, bundle, n2);
    }

    public void zza(@NonNull zzf.zzf zzf2) {
        if (!this.zzuI()) {
            try {
                int n;
                Bundle bundle = this.getContext().getPackageManager().getApplicationInfo((String)"com.google.android.wearable.app.cn", (int)128).metaData;
                int n2 = n = bundle != null ? bundle.getInt("com.google.android.wearable.api.version", 0) : 0;
                if (n < zzc.GOOGLE_PLAY_SERVICES_VERSION_CODE) {
                    int n3 = zzc.GOOGLE_PLAY_SERVICES_VERSION_CODE;
                    Log.w((String)"WearableClient", (String)new StringBuilder(80).append("Android Wear out of date. Requires API version ").append(n3).append(" but found ").append(n).toString());
                    this.zza(zzf2, new ConnectionResult(6, PendingIntent.getActivity((Context)this.getContext(), (int)0, (Intent)zzcx.zzbP(this.getContext()), (int)0)));
                    return;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                this.zza(zzf2, new ConnectionResult(16));
                return;
            }
        }
        super.zza(zzf2);
    }

    public static Intent zzbP(Context context) {
        Intent intent = new Intent("com.google.android.wearable.app.cn.UPDATE_ANDROID_WEAR").setPackage("com.google.android.wearable.app.cn");
        PackageManager packageManager = context.getPackageManager();
        if (packageManager.resolveActivity(intent, 65536) != null) {
            return intent;
        }
        Uri uri = Uri.parse((String)"market://details").buildUpon().appendQueryParameter("id", "com.google.android.wearable.app.cn").build();
        return new Intent("android.intent.action.VIEW", uri);
    }

    public void zza(zzzv.zzb<DataApi.DataItemResult> zzb2, PutDataRequest putDataRequest) throws RemoteException {
        Map.Entry<String, Asset> entry22;
        for (Map.Entry<String, Asset> entry22 : putDataRequest.getAssets().entrySet()) {
            Object object = entry22.getValue();
            if (object.getData() != null || object.getDigest() != null || object.getFd() != null || object.getUri() != null) continue;
            String string = String.valueOf(putDataRequest.getUri());
            String string2 = String.valueOf(object);
            throw new IllegalArgumentException(new StringBuilder(33 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Put for ").append(string).append(" contains invalid asset: ").append(string2).toString());
        }
        PutDataRequest putDataRequest2 = PutDataRequest.zzy(putDataRequest.getUri());
        putDataRequest2.setData(putDataRequest.getData());
        if (putDataRequest.isUrgent()) {
            putDataRequest2.setUrgent();
        }
        entry22 = new ArrayList();
        for (Map.Entry entry3 : putDataRequest.getAssets().entrySet()) {
            Object object;
            ParcelFileDescriptor parcelFileDescriptor;
            Asset asset = (Asset)((Object)entry3.getValue());
            if (asset.getData() != null) {
                String string;
                try {
                    parcelFileDescriptor = ParcelFileDescriptor.createPipe();
                }
                catch (IOException iOException) {
                    string = String.valueOf((Object)putDataRequest);
                    throw new IllegalStateException(new StringBuilder(60 + String.valueOf(string).length()).append("Unable to create ParcelFileDescriptor for asset in request: ").append(string).toString(), iOException);
                }
                if (Log.isLoggable((String)"WearableClient", (int)3)) {
                    object = String.valueOf((Object)asset);
                    string = String.valueOf(parcelFileDescriptor[0]);
                    String string3 = String.valueOf(parcelFileDescriptor[1]);
                    Log.d((String)"WearableClient", (String)new StringBuilder(61 + String.valueOf(object).length() + String.valueOf(string).length() + String.valueOf(string3).length()).append("processAssets: replacing data with FD in asset: ").append((String)object).append(" read:").append(string).append(" write:").append(string3).toString());
                }
                putDataRequest2.putAsset((String)entry3.getKey(), Asset.createFromFd(parcelFileDescriptor[0]));
                object = this.zza(parcelFileDescriptor[1], asset.getData());
                entry22.add(object);
                this.zzbFy.submit((Runnable)object);
                continue;
            }
            if (asset.getUri() != null) {
                try {
                    parcelFileDescriptor = this.getContext().getContentResolver().openFileDescriptor(asset.getUri(), "r");
                    object = Asset.createFromFd(parcelFileDescriptor);
                    putDataRequest2.putAsset((String)entry3.getKey(), (Asset)((Object)object));
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    new zzcw.zzq(zzb2, (List<FutureTask<Boolean>>)((Object)entry22)).zza(new zzci(4005, null));
                    object = String.valueOf(asset.getUri());
                    Log.w((String)"WearableClient", (String)new StringBuilder(28 + String.valueOf(object).length()).append("Couldn't resolve asset URI: ").append((String)object).toString());
                    return;
                }
            }
            putDataRequest2.putAsset((String)entry3.getKey(), asset);
        }
        ((zzbw)this.zzwW()).zza((zzbu)new zzcw.zzq(zzb2, (List<FutureTask<Boolean>>)((Object)entry22)), putDataRequest2);
    }

    private FutureTask<Boolean> zza(final ParcelFileDescriptor parcelFileDescriptor, final byte[] byArray) {
        return new FutureTask<Boolean>(new Callable<Boolean>(this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public Boolean zzkt() {
                Object object;
                String string;
                if (Log.isLoggable((String)"WearableClient", (int)3)) {
                    string = String.valueOf(parcelFileDescriptor);
                    Log.d((String)"WearableClient", (String)new StringBuilder(36 + String.valueOf(string).length()).append("processAssets: writing data to FD : ").append(string).toString());
                }
                string = new ParcelFileDescriptor.AutoCloseOutputStream(parcelFileDescriptor);
                string.write(byArray);
                string.flush();
                if (Log.isLoggable((String)"WearableClient", (int)3)) {
                    object = String.valueOf(parcelFileDescriptor);
                    Log.d((String)"WearableClient", (String)new StringBuilder(27 + String.valueOf(object).length()).append("processAssets: wrote data: ").append((String)object).toString());
                }
                object = true;
                try {
                    if (Log.isLoggable((String)"WearableClient", (int)3)) {
                        String string2 = String.valueOf(parcelFileDescriptor);
                        Log.d((String)"WearableClient", (String)new StringBuilder(24 + String.valueOf(string2).length()).append("processAssets: closing: ").append(string2).toString());
                    }
                    string.close();
                }
                catch (IOException iOException) {}
                return object;
                catch (IOException iOException) {
                    try {
                        String string3 = String.valueOf(parcelFileDescriptor);
                        Log.w((String)"WearableClient", (String)new StringBuilder(36 + String.valueOf(string3).length()).append("processAssets: writing data failed: ").append(string3).toString());
                    }
                    catch (Throwable throwable) {
                        try {
                            if (Log.isLoggable((String)"WearableClient", (int)3)) {
                                String string4 = String.valueOf(parcelFileDescriptor);
                                Log.d((String)"WearableClient", (String)new StringBuilder(24 + String.valueOf(string4).length()).append("processAssets: closing: ").append(string4).toString());
                            }
                            string.close();
                        }
                        catch (IOException iOException2) {}
                        throw throwable;
                    }
                    try {
                        if (Log.isLoggable((String)"WearableClient", (int)3)) {
                            String string5 = String.valueOf(parcelFileDescriptor);
                            Log.d((String)"WearableClient", (String)new StringBuilder(24 + String.valueOf(string5).length()).append("processAssets: closing: ").append(string5).toString());
                        }
                        string.close();
                    }
                    catch (IOException iOException3) {}
                }
                return false;
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.zzkt();
            }
        });
    }

    public void zza(zzzv.zzb<DataApi.DataItemResult> zzb2, Uri uri) throws RemoteException {
        ((zzbw)this.zzwW()).zza((zzbu)new zzcw.zzk(zzb2), uri);
    }

    public void zzx(zzzv.zzb<DataItemBuffer> zzb2) throws RemoteException {
        ((zzbw)this.zzwW()).zzb(new zzcw.zzl(zzb2));
    }

    public void zza(zzzv.zzb<DataItemBuffer> zzb2, Uri uri, int n) throws RemoteException {
        ((zzbw)this.zzwW()).zza((zzbu)new zzcw.zzl(zzb2), uri, n);
    }

    public void zzb(zzzv.zzb<DataApi.DeleteDataItemsResult> zzb2, Uri uri, int n) throws RemoteException {
        ((zzbw)this.zzwW()).zzb((zzbu)new zzcw.zze(zzb2), uri, n);
    }

    public void zza(zzzv.zzb<MessageApi.SendMessageResult> zzb2, String string, String string2, byte[] byArray) throws RemoteException {
        ((zzbw)this.zzwW()).zza(new zzcw.zzt(zzb2), string, string2, byArray);
    }

    public void zza(zzzv.zzb<DataApi.GetFdForAssetResult> zzb2, Asset asset) throws RemoteException {
        ((zzbw)this.zzwW()).zza((zzbu)new zzcw.zzm(zzb2), asset);
    }

    public void zza(zzzv.zzb<DataApi.GetFdForAssetResult> zzb2, DataItemAsset dataItemAsset) throws RemoteException {
        this.zza(zzb2, Asset.createFromRef(dataItemAsset.getId()));
    }

    public void zzy(zzzv.zzb<NodeApi.GetLocalNodeResult> zzb2) throws RemoteException {
        ((zzbw)this.zzwW()).zzc(new zzcw.zzn(zzb2));
    }

    public void zzz(zzzv.zzb<NodeApi.GetConnectedNodesResult> zzb2) throws RemoteException {
        ((zzbw)this.zzwW()).zzd(new zzcw.zzj(zzb2));
    }

    public void zzh(zzzv.zzb<CapabilityApi.GetCapabilityResult> zzb2, String string, int n) throws RemoteException {
        ((zzbw)this.zzwW()).zza((zzbu)new zzcw.zzg(zzb2), string, n);
    }

    public void zzd(zzzv.zzb<CapabilityApi.GetAllCapabilitiesResult> zzb2, int n) throws RemoteException {
        ((zzbw)this.zzwW()).zza((zzbu)new zzcw.zzf(zzb2), n);
    }

    public void zzv(zzzv.zzb<CapabilityApi.AddLocalCapabilityResult> zzb2, String string) throws RemoteException {
        ((zzbw)this.zzwW()).zzd(new zzcw.zza(zzb2), string);
    }

    public void zzw(zzzv.zzb<CapabilityApi.RemoveLocalCapabilityResult> zzb2, String string) throws RemoteException {
        ((zzbw)this.zzwW()).zze(new zzcw.zzs(zzb2), string);
    }

    public void zze(zzzv.zzb<ChannelApi.OpenChannelResult> zzb2, String string, String string2) throws RemoteException {
        ((zzbw)this.zzwW()).zza((zzbu)new zzcw.zzp(zzb2), string, string2);
    }

    public void zzx(zzzv.zzb<Status> zzb2, String string) throws RemoteException {
        ((zzbw)this.zzwW()).zzf(new zzcw.zzc(zzb2), string);
    }

    public void zzi(zzzv.zzb<Status> zzb2, String string, int n) throws RemoteException {
        ((zzbw)this.zzwW()).zzb((zzbu)new zzcw.zzd(zzb2), string, n);
    }

    public void zzy(zzzv.zzb<Channel.GetInputStreamResult> zzb2, String string) throws RemoteException {
        zzac zzac2 = new zzac();
        ((zzbw)this.zzwW()).zza((zzbu)new zzcw.zzh(zzb2, zzac2), zzac2, string);
    }

    public void zzz(zzzv.zzb<Channel.GetOutputStreamResult> zzb2, String string) throws RemoteException {
        zzac zzac2 = new zzac();
        ((zzbw)this.zzwW()).zzb((zzbu)new zzcw.zzi(zzb2, zzac2), zzac2, string);
    }

    public void zza(zzzv.zzb<Status> zzb2, String string, Uri uri, boolean bl) {
        try {
            this.zzbFy.execute(this.zzb(zzb2, string, uri, bl));
        }
        catch (RuntimeException runtimeException) {
            zzb2.zzA(new Status(8));
            throw runtimeException;
        }
    }

    public void zza(zzzv.zzb<Status> zzb2, String string, Uri uri, long l, long l2) {
        try {
            this.zzbFy.execute(this.zzb(zzb2, string, uri, l, l2));
        }
        catch (RuntimeException runtimeException) {
            zzb2.zzA(new Status(8));
            throw runtimeException;
        }
    }

    public void zza(zzzv.zzb<Status> zzb2, DataApi.DataListener dataListener, zzaaz<DataApi.DataListener> zzaaz2, IntentFilter[] intentFilterArray) throws RemoteException {
        this.zzbSY.zza(this, zzb2, dataListener, zzcy.zza(zzaaz2, intentFilterArray));
    }

    public void zza(zzzv.zzb<Status> zzb2, MessageApi.MessageListener messageListener, zzaaz<MessageApi.MessageListener> zzaaz2, IntentFilter[] intentFilterArray) throws RemoteException {
        this.zzbSZ.zza(this, zzb2, messageListener, zzcy.zzb(zzaaz2, intentFilterArray));
    }

    public void zza(zzzv.zzb<Status> zzb2, NodeApi.NodeListener nodeListener, zzaaz<NodeApi.NodeListener> zzaaz2, IntentFilter[] intentFilterArray) throws RemoteException {
        this.zzbTa.zza(this, zzb2, nodeListener, zzcy.zzc(zzaaz2, intentFilterArray));
    }

    public void zza(zzzv.zzb<Status> zzb2, CapabilityApi.CapabilityListener capabilityListener, zzaaz<CapabilityApi.CapabilityListener> zzaaz2, IntentFilter[] intentFilterArray) throws RemoteException {
        this.zzbTc.zza(this, zzb2, capabilityListener, zzcy.zze(zzaaz2, intentFilterArray));
    }

    public void zza(zzzv.zzb<Status> zzb2, ChannelApi.ChannelListener channelListener, zzaaz<ChannelApi.ChannelListener> zzaaz2, String string, IntentFilter[] intentFilterArray) throws RemoteException {
        if (string == null) {
            this.zzbSX.zza(this, zzb2, channelListener, zzcy.zzd(zzaaz2, intentFilterArray));
        } else {
            zzcq zzcq2 = new zzcq(string, channelListener);
            this.zzbSX.zza(this, zzb2, zzcq2, zzcy.zza(zzaaz2, string, intentFilterArray));
        }
    }

    public void zza(zzzv.zzb<Status> zzb2, DataApi.DataListener dataListener) throws RemoteException {
        this.zzbSY.zza(this, zzb2, dataListener);
    }

    public void zza(zzzv.zzb<Status> zzb2, MessageApi.MessageListener messageListener) throws RemoteException {
        this.zzbSZ.zza(this, zzb2, messageListener);
    }

    public void zza(zzzv.zzb<Status> zzb2, NodeApi.NodeListener nodeListener) throws RemoteException {
        this.zzbTa.zza(this, zzb2, nodeListener);
    }

    public void zza(zzzv.zzb<Status> zzb2, CapabilityApi.CapabilityListener capabilityListener) throws RemoteException {
        this.zzbTc.zza(this, zzb2, capabilityListener);
    }

    public void zza(zzzv.zzb<Status> zzb2, ChannelApi.ChannelListener channelListener, String string) throws RemoteException {
        if (string == null) {
            this.zzbSX.zza(this, zzb2, channelListener);
        } else {
            zzcq zzcq2 = new zzcq(string, channelListener);
            this.zzbSX.zza(this, zzb2, zzcq2);
        }
    }

    private Runnable zzb(final zzzv.zzb<Status> zzb2, final String string, final Uri uri, final boolean bl) {
        com.google.android.gms.common.internal.zzac.zzw(zzb2);
        com.google.android.gms.common.internal.zzac.zzw((Object)string);
        com.google.android.gms.common.internal.zzac.zzw((Object)uri);
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ParcelFileDescriptor parcelFileDescriptor;
                if (Log.isLoggable((String)"WearableClient", (int)2)) {
                    Log.v((String)"WearableClient", (String)"Executing receiveFileFromChannelTask");
                }
                if (!"file".equals(uri.getScheme())) {
                    Log.w((String)"WearableClient", (String)"Channel.receiveFile used with non-file URI");
                    zzb2.zzA(new Status(10, "Channel.receiveFile used with non-file URI"));
                    return;
                }
                File file = new File(uri.getPath());
                int n = 0x28000000 | (bl ? 0x2000000 : 0);
                try {
                    parcelFileDescriptor = ParcelFileDescriptor.open((File)file, (int)n);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    String string2 = String.valueOf(file);
                    Log.w((String)"WearableClient", (String)new StringBuilder(49 + String.valueOf(string2).length()).append("File couldn't be opened for Channel.receiveFile: ").append(string2).toString());
                    zzb2.zzA(new Status(13));
                    return;
                }
                try {
                    ((zzbw)zzcx.this.zzwW()).zza((zzbu)new zzcw.zzu((zzzv.zzb<Status>)zzb2), string, parcelFileDescriptor);
                }
                catch (RemoteException remoteException) {
                    Log.w((String)"WearableClient", (String)"Channel.receiveFile failed.", (Throwable)remoteException);
                    zzb2.zzA(new Status(8));
                }
                finally {
                    try {
                        parcelFileDescriptor.close();
                    }
                    catch (IOException iOException) {
                        Log.w((String)"WearableClient", (String)"Failed to close targetFd", (Throwable)iOException);
                    }
                }
            }
        };
    }

    private Runnable zzb(final zzzv.zzb<Status> zzb2, final String string, final Uri uri, final long l, final long l2) {
        com.google.android.gms.common.internal.zzac.zzw(zzb2);
        com.google.android.gms.common.internal.zzac.zzw((Object)string);
        com.google.android.gms.common.internal.zzac.zzw((Object)uri);
        com.google.android.gms.common.internal.zzac.zzb((l >= 0L ? 1 : 0) != 0, (String)"startOffset is negative: %s", (Object[])new Object[]{l});
        com.google.android.gms.common.internal.zzac.zzb((l2 >= -1L ? 1 : 0) != 0, (String)"invalid length: %s", (Object[])new Object[]{l2});
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ParcelFileDescriptor parcelFileDescriptor;
                if (Log.isLoggable((String)"WearableClient", (int)2)) {
                    Log.v((String)"WearableClient", (String)"Executing sendFileToChannelTask");
                }
                if (!"file".equals(uri.getScheme())) {
                    Log.w((String)"WearableClient", (String)"Channel.sendFile used with non-file URI");
                    zzb2.zzA(new Status(10, "Channel.sendFile used with non-file URI"));
                    return;
                }
                File file = new File(uri.getPath());
                try {
                    parcelFileDescriptor = ParcelFileDescriptor.open((File)file, (int)0x10000000);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    String string2 = String.valueOf(file);
                    Log.w((String)"WearableClient", (String)new StringBuilder(46 + String.valueOf(string2).length()).append("File couldn't be opened for Channel.sendFile: ").append(string2).toString());
                    zzb2.zzA(new Status(13));
                    return;
                }
                try {
                    ((zzbw)zzcx.this.zzwW()).zza(new zzcw.zzr((zzzv.zzb<Status>)zzb2), string, parcelFileDescriptor, l, l2);
                }
                catch (RemoteException remoteException) {
                    Log.w((String)"WearableClient", (String)"Channel.sendFile failed.", (Throwable)remoteException);
                    zzb2.zzA(new Status(8));
                }
                finally {
                    try {
                        parcelFileDescriptor.close();
                    }
                    catch (IOException iOException) {
                        Log.w((String)"WearableClient", (String)"Failed to close sourceFd", (Throwable)iOException);
                    }
                }
            }
        };
    }

    protected /* synthetic */ IInterface zzh(IBinder iBinder) {
        return this.zzfz(iBinder);
    }
}

