/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.wearable.zze;
import java.util.Arrays;

public class Asset
extends zza
implements ReflectedParcelable {
    public static final Parcelable.Creator<Asset> CREATOR = new zze();
    final int mVersionCode;
    private byte[] zzbeh;
    private String zzbQN;
    public ParcelFileDescriptor zzbQO;
    public Uri uri;

    Asset(int n, byte[] byArray, String string, ParcelFileDescriptor parcelFileDescriptor, Uri uri) {
        this.mVersionCode = n;
        this.zzbeh = byArray;
        this.zzbQN = string;
        this.zzbQO = parcelFileDescriptor;
        this.uri = uri;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zze.zza(this, parcel, n | 1);
    }

    public static Asset createFromRef(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Asset digest cannot be null");
        }
        return new Asset(1, null, string, null, null);
    }

    public static Asset createFromBytes(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("Asset data cannot be null");
        }
        return new Asset(1, byArray, null, null, null);
    }

    public static Asset createFromFd(ParcelFileDescriptor parcelFileDescriptor) {
        if (parcelFileDescriptor == null) {
            throw new IllegalArgumentException("Asset fd cannot be null");
        }
        return new Asset(1, null, null, parcelFileDescriptor, null);
    }

    public static Asset createFromUri(Uri uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Asset uri cannot be null");
        }
        return new Asset(1, null, null, null, uri);
    }

    public byte[] getData() {
        return this.zzbeh;
    }

    public String getDigest() {
        return this.zzbQN;
    }

    public ParcelFileDescriptor getFd() {
        return this.zzbQO;
    }

    public Uri getUri() {
        return this.uri;
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.zzbeh, this.zzbQN, this.zzbQO, this.uri});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Asset)) {
            return false;
        }
        Asset asset = (Asset)((Object)object);
        return Arrays.equals(this.zzbeh, asset.zzbeh) && zzaa.equal((Object)this.zzbQN, (Object)asset.zzbQN) && zzaa.equal((Object)this.zzbQO, (Object)asset.zzbQO) && zzaa.equal((Object)this.uri, (Object)asset.uri);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Asset[@");
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        if (this.zzbQN == null) {
            stringBuilder.append(", nodigest");
        } else {
            stringBuilder.append(", ");
            stringBuilder.append(this.zzbQN);
        }
        if (this.zzbeh != null) {
            stringBuilder.append(", size=");
            stringBuilder.append(this.zzbeh.length);
        }
        if (this.zzbQO != null) {
            stringBuilder.append(", fd=");
            stringBuilder.append(this.zzbQO);
        }
        if (this.uri != null) {
            stringBuilder.append(", uri=");
            stringBuilder.append(this.uri);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

