/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.util.Log;
import com.google.android.gms.internal.zzbig;
import com.google.android.gms.internal.zzbut;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataMap;
import com.google.android.gms.wearable.DataMapItem;
import com.google.android.gms.wearable.PutDataRequest;

public class PutDataMapRequest {
    private final PutDataRequest zzbQW;
    private final DataMap zzbQV;

    private PutDataMapRequest(PutDataRequest putDataRequest, DataMap dataMap) {
        this.zzbQW = putDataRequest;
        this.zzbQV = new DataMap();
        if (dataMap != null) {
            this.zzbQV.putAll(dataMap);
        }
    }

    public static PutDataMapRequest createFromDataMapItem(DataMapItem dataMapItem) {
        return new PutDataMapRequest(PutDataRequest.zzy(dataMapItem.getUri()), dataMapItem.getDataMap());
    }

    public static PutDataMapRequest createWithAutoAppendedId(String string) {
        return new PutDataMapRequest(PutDataRequest.createWithAutoAppendedId(string), null);
    }

    public static PutDataMapRequest create(String string) {
        return new PutDataMapRequest(PutDataRequest.create(string), null);
    }

    public Uri getUri() {
        return this.zzbQW.getUri();
    }

    public DataMap getDataMap() {
        return this.zzbQV;
    }

    public PutDataMapRequest setUrgent() {
        this.zzbQW.setUrgent();
        return this;
    }

    public boolean isUrgent() {
        return this.zzbQW.isUrgent();
    }

    public PutDataRequest asPutDataRequest() {
        zzbig.zza zza2 = zzbig.zza(this.zzbQV);
        this.zzbQW.setData(zzbut.zzf((zzbut)zza2.zzbTq));
        int n = zza2.zzbTr.size();
        for (int i = 0; i < n; ++i) {
            String string;
            String string2 = Integer.toString(i);
            Asset asset = zza2.zzbTr.get(i);
            if (string2 == null) {
                string = String.valueOf((Object)asset);
                throw new IllegalStateException(new StringBuilder(26 + String.valueOf(string).length()).append("asset key cannot be null: ").append(string).toString());
            }
            if (asset == null) {
                String string3 = String.valueOf(string2);
                throw new IllegalStateException(string3.length() != 0 ? "asset cannot be null: key=".concat(string3) : new String("asset cannot be null: key="));
            }
            if (Log.isLoggable((String)"DataMap", (int)3)) {
                string = String.valueOf((Object)asset);
                Log.d((String)"DataMap", (String)new StringBuilder(33 + String.valueOf(string2).length() + String.valueOf(string).length()).append("asPutDataRequest: adding asset: ").append(string2).append(" ").append(string).toString());
            }
            this.zzbQW.putAsset(string2, asset);
        }
        return this.zzbQW;
    }
}

