/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.internal.zzblc;
import com.google.android.gms.internal.zzbld;
import com.google.android.gms.internal.zzbxs;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataItem;
import com.google.android.gms.wearable.DataMap;
import java.util.ArrayList;

public class DataMapItem {
    private final Uri mUri;
    private final DataMap zzbST;

    public static DataMapItem fromDataItem(DataItem dataItem) {
        if (dataItem == null) {
            throw new IllegalStateException("provided dataItem is null");
        }
        return new DataMapItem(dataItem);
    }

    private DataMapItem(DataItem dataItem) {
        this.mUri = dataItem.getUri();
        this.zzbST = this.zza((DataItem)dataItem.freeze());
    }

    public Uri getUri() {
        return this.mUri;
    }

    public DataMap getDataMap() {
        return this.zzbST;
    }

    private DataMap zza(DataItem dataItem) {
        if (dataItem.getData() == null && dataItem.getAssets().size() > 0) {
            throw new IllegalArgumentException("Cannot create DataMapItem from a DataItem  that wasn't made with DataMapItem.");
        }
        if (dataItem.getData() == null) {
            return new DataMap();
        }
        try {
            Object object;
            ArrayList<Asset> arrayList = new ArrayList<Asset>();
            int n = dataItem.getAssets().size();
            for (int i = 0; i < n; ++i) {
                object = dataItem.getAssets().get(Integer.toString(i));
                if (object == null) {
                    int n2 = i;
                    String string = String.valueOf(dataItem);
                    throw new IllegalStateException(new StringBuilder(64 + String.valueOf(string).length()).append("Cannot find DataItemAsset referenced in data at ").append(n2).append(" for ").append(string).toString());
                }
                Asset asset = Asset.createFromRef(object.getId());
                arrayList.add(asset);
            }
            zzbld zzbld2 = zzbld.zzS(dataItem.getData());
            object = new zzblc.zza(zzbld2, arrayList);
            return zzblc.zza((zzblc.zza)object);
        }
        catch (zzbxs | NullPointerException throwable) {
            String string = String.valueOf(dataItem.getUri());
            String string2 = String.valueOf(Base64.encodeToString((byte[])dataItem.getData(), (int)0));
            Log.w((String)"DataItem", (String)new StringBuilder(50 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Unable to parse datamap from dataItem. uri=").append(string).append(", data=").append(string2).toString());
            string = String.valueOf(dataItem.getUri());
            throw new IllegalStateException(new StringBuilder(44 + String.valueOf(string).length()).append("Unable to parse datamap from dataItem.  uri=").append(string).toString(), throwable);
        }
    }
}

