/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.content.IntentFilter;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzaad;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataApi;
import com.google.android.gms.wearable.DataItem;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.DataItemBuffer;
import com.google.android.gms.wearable.PutDataRequest;
import com.google.android.gms.wearable.internal.zzb;
import com.google.android.gms.wearable.internal.zzcv;
import com.google.android.gms.wearable.internal.zzcx;
import com.google.android.gms.wearable.internal.zzm;
import java.io.IOException;
import java.io.InputStream;

public final class zzah
implements DataApi {
    @Override
    public PendingResult<DataApi.DataItemResult> putDataItem(GoogleApiClient googleApiClient, final PutDataRequest putDataRequest) {
        return googleApiClient.zza((zzaad.zza)new zzm<DataApi.DataItemResult>(this, googleApiClient){

            protected void zza(zzcx zzcx2) throws RemoteException {
                zzcx2.zza((zzaad.zzb<DataApi.DataItemResult>)this, putDataRequest);
            }

            public DataApi.DataItemResult zzbW(Status status) {
                return new zza(status, null);
            }

            public /* synthetic */ Result zzc(Status status) {
                return this.zzbW(status);
            }
        });
    }

    @Override
    public PendingResult<DataApi.DataItemResult> getDataItem(GoogleApiClient googleApiClient, final Uri uri) {
        return googleApiClient.zza((zzaad.zza)new zzm<DataApi.DataItemResult>(this, googleApiClient){

            protected void zza(zzcx zzcx2) throws RemoteException {
                zzcx2.zza((zzaad.zzb<DataApi.DataItemResult>)this, uri);
            }

            protected DataApi.DataItemResult zzbW(Status status) {
                return new zza(status, null);
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzbW(status);
            }
        });
    }

    @Override
    public PendingResult<DataItemBuffer> getDataItems(GoogleApiClient googleApiClient) {
        return googleApiClient.zza((zzaad.zza)new zzm<DataItemBuffer>(this, googleApiClient){

            protected void zza(zzcx zzcx2) throws RemoteException {
                zzcx2.zzw((zzaad.zzb<DataItemBuffer>)this);
            }

            protected DataItemBuffer zzbX(Status status) {
                return new DataItemBuffer(DataHolder.zzcJ((int)status.getStatusCode()));
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzbX(status);
            }
        });
    }

    @Override
    public PendingResult<DataItemBuffer> getDataItems(GoogleApiClient googleApiClient, Uri uri) {
        return this.getDataItems(googleApiClient, uri, 0);
    }

    @Override
    public PendingResult<DataItemBuffer> getDataItems(GoogleApiClient googleApiClient, final Uri uri, final int n) {
        zzac.zzb((uri != null ? 1 : 0) != 0, (Object)"uri must not be null");
        zzac.zzb((n == 0 || n == 1 ? 1 : 0) != 0, (Object)"invalid filter type");
        return googleApiClient.zza((zzaad.zza)new zzm<DataItemBuffer>(this, googleApiClient){

            protected void zza(zzcx zzcx2) throws RemoteException {
                zzcx2.zza((zzaad.zzb<DataItemBuffer>)this, uri, n);
            }

            protected DataItemBuffer zzbX(Status status) {
                return new DataItemBuffer(DataHolder.zzcJ((int)status.getStatusCode()));
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzbX(status);
            }
        });
    }

    @Override
    public PendingResult<DataApi.DeleteDataItemsResult> deleteDataItems(GoogleApiClient googleApiClient, Uri uri) {
        return this.deleteDataItems(googleApiClient, uri, 0);
    }

    @Override
    public PendingResult<DataApi.DeleteDataItemsResult> deleteDataItems(GoogleApiClient googleApiClient, final Uri uri, final int n) {
        zzac.zzb((uri != null ? 1 : 0) != 0, (Object)"uri must not be null");
        zzac.zzb((n == 0 || n == 1 ? 1 : 0) != 0, (Object)"invalid filter type");
        return googleApiClient.zza((zzaad.zza)new zzm<DataApi.DeleteDataItemsResult>(this, googleApiClient){

            protected void zza(zzcx zzcx2) throws RemoteException {
                zzcx2.zzb((zzaad.zzb<DataApi.DeleteDataItemsResult>)this, uri, n);
            }

            protected DataApi.DeleteDataItemsResult zzbY(Status status) {
                return new zzb(status, 0);
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzbY(status);
            }
        });
    }

    private void zza(Asset asset) {
        if (asset == null) {
            throw new IllegalArgumentException("asset is null");
        }
        if (asset.getDigest() == null) {
            throw new IllegalArgumentException("invalid asset");
        }
        if (asset.getData() != null) {
            throw new IllegalArgumentException("invalid asset");
        }
    }

    @Override
    public PendingResult<DataApi.GetFdForAssetResult> getFdForAsset(GoogleApiClient googleApiClient, final Asset asset) {
        this.zza(asset);
        return googleApiClient.zza((zzaad.zza)new zzm<DataApi.GetFdForAssetResult>(this, googleApiClient){

            protected void zza(zzcx zzcx2) throws RemoteException {
                zzcx2.zza((zzaad.zzb<DataApi.GetFdForAssetResult>)this, asset);
            }

            protected DataApi.GetFdForAssetResult zzbZ(Status status) {
                return new zzc(status, null);
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzbZ(status);
            }
        });
    }

    @Override
    public PendingResult<DataApi.GetFdForAssetResult> getFdForAsset(GoogleApiClient googleApiClient, final DataItemAsset dataItemAsset) {
        return googleApiClient.zza((zzaad.zza)new zzm<DataApi.GetFdForAssetResult>(this, googleApiClient){

            protected void zza(zzcx zzcx2) throws RemoteException {
                zzcx2.zza((zzaad.zzb<DataApi.GetFdForAssetResult>)this, dataItemAsset);
            }

            protected DataApi.GetFdForAssetResult zzbZ(Status status) {
                return new zzc(status, null);
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzbZ(status);
            }
        });
    }

    @Override
    public PendingResult<Status> addListener(GoogleApiClient googleApiClient, DataApi.DataListener dataListener) {
        IntentFilter[] intentFilterArray = new IntentFilter[]{zzcv.zzip("com.google.android.gms.wearable.DATA_CHANGED")};
        return this.zza(googleApiClient, dataListener, intentFilterArray);
    }

    @Override
    public PendingResult<Status> addListener(GoogleApiClient googleApiClient, DataApi.DataListener dataListener, Uri uri, int n) {
        zzac.zzb((uri != null ? 1 : 0) != 0, (Object)"uri must not be null");
        zzac.zzb((n == 0 || n == 1 ? 1 : 0) != 0, (Object)"invalid filter type");
        IntentFilter intentFilter = zzcv.zza("com.google.android.gms.wearable.DATA_CHANGED", uri, n);
        return this.zza(googleApiClient, dataListener, new IntentFilter[]{intentFilter});
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, DataApi.DataListener dataListener, IntentFilter[] intentFilterArray) {
        return com.google.android.gms.wearable.internal.zzb.zza(googleApiClient, zzah.zza(intentFilterArray), dataListener);
    }

    private static zzb.zza<DataApi.DataListener> zza(final IntentFilter[] intentFilterArray) {
        return new zzb.zza<DataApi.DataListener>(){

            @Override
            public void zza(zzcx zzcx2, zzaad.zzb<Status> zzb2, DataApi.DataListener dataListener, zzabh<DataApi.DataListener> zzabh2) throws RemoteException {
                zzcx2.zza(zzb2, dataListener, zzabh2, intentFilterArray);
            }
        };
    }

    @Override
    public PendingResult<Status> removeListener(GoogleApiClient googleApiClient, final DataApi.DataListener dataListener) {
        return googleApiClient.zza((zzaad.zza)new zzm<Status>(this, googleApiClient){

            protected void zza(zzcx zzcx2) throws RemoteException {
                zzcx2.zza((zzaad.zzb<Status>)this, dataListener);
            }

            public Status zzb(Status status) {
                return status;
            }

            public /* synthetic */ Result zzc(Status status) {
                return this.zzb(status);
            }
        });
    }

    public static class zzc
    implements DataApi.GetFdForAssetResult {
        private final Status zzair;
        private volatile ParcelFileDescriptor zzbUq;
        private volatile InputStream zzbUb;
        private volatile boolean mClosed = false;

        public zzc(Status status, ParcelFileDescriptor parcelFileDescriptor) {
            this.zzair = status;
            this.zzbUq = parcelFileDescriptor;
        }

        public Status getStatus() {
            return this.zzair;
        }

        @Override
        public ParcelFileDescriptor getFd() {
            if (this.mClosed) {
                throw new IllegalStateException("Cannot access the file descriptor after release().");
            }
            return this.zzbUq;
        }

        @Override
        public InputStream getInputStream() {
            if (this.mClosed) {
                throw new IllegalStateException("Cannot access the input stream after release().");
            }
            if (this.zzbUq == null) {
                return null;
            }
            if (this.zzbUb == null) {
                this.zzbUb = new ParcelFileDescriptor.AutoCloseInputStream(this.zzbUq);
            }
            return this.zzbUb;
        }

        public void release() {
            if (this.zzbUq == null) {
                return;
            }
            if (this.mClosed) {
                throw new IllegalStateException("releasing an already released result.");
            }
            try {
                if (this.zzbUb != null) {
                    this.zzbUb.close();
                } else {
                    this.zzbUq.close();
                }
                this.mClosed = true;
                this.zzbUq = null;
                this.zzbUb = null;
            }
            catch (IOException iOException) {}
        }
    }

    public static class zzb
    implements DataApi.DeleteDataItemsResult {
        private final Status zzair;
        private final int zzbUp;

        public zzb(Status status, int n) {
            this.zzair = status;
            this.zzbUp = n;
        }

        public Status getStatus() {
            return this.zzair;
        }

        @Override
        public int getNumDeleted() {
            return this.zzbUp;
        }
    }

    public static class zza
    implements DataApi.DataItemResult {
        private final Status zzair;
        private final DataItem zzbUo;

        public zza(Status status, DataItem dataItem) {
            this.zzair = status;
            this.zzbUo = dataItem;
        }

        public Status getStatus() {
            return this.zzair;
        }

        @Override
        public DataItem getDataItem() {
            return this.zzbUo;
        }
    }
}

