/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.util.Log;
import com.google.android.gms.internal.zzblc;
import com.google.android.gms.internal.zzbyj;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataMap;
import com.google.android.gms.wearable.DataMapItem;
import com.google.android.gms.wearable.PutDataRequest;

public class PutDataMapRequest {
    private final PutDataRequest zzbSX;
    private final DataMap zzbSW;

    private PutDataMapRequest(PutDataRequest putDataRequest, DataMap dataMap) {
        this.zzbSX = putDataRequest;
        this.zzbSW = new DataMap();
        if (dataMap != null) {
            this.zzbSW.putAll(dataMap);
        }
    }

    public static PutDataMapRequest createFromDataMapItem(DataMapItem dataMapItem) {
        return new PutDataMapRequest(PutDataRequest.zzy(dataMapItem.getUri()), dataMapItem.getDataMap());
    }

    public static PutDataMapRequest createWithAutoAppendedId(String string) {
        return new PutDataMapRequest(PutDataRequest.createWithAutoAppendedId(string), null);
    }

    public static PutDataMapRequest create(String string) {
        return new PutDataMapRequest(PutDataRequest.create(string), null);
    }

    public Uri getUri() {
        return this.zzbSX.getUri();
    }

    public DataMap getDataMap() {
        return this.zzbSW;
    }

    public PutDataMapRequest setUrgent() {
        this.zzbSX.setUrgent();
        return this;
    }

    public boolean isUrgent() {
        return this.zzbSX.isUrgent();
    }

    public PutDataRequest asPutDataRequest() {
        zzblc.zza zza2 = zzblc.zza(this.zzbSW);
        this.zzbSX.setData(zzbyj.zzf((zzbyj)zza2.zzbVv));
        int n = zza2.zzbVw.size();
        for (int i = 0; i < n; ++i) {
            String string;
            String string2 = Integer.toString(i);
            Asset asset = zza2.zzbVw.get(i);
            if (string2 == null) {
                string = String.valueOf((Object)asset);
                throw new IllegalStateException(new StringBuilder(26 + String.valueOf(string).length()).append("asset key cannot be null: ").append(string).toString());
            }
            if (asset == null) {
                String string3 = String.valueOf(string2);
                throw new IllegalStateException(string3.length() != 0 ? "asset cannot be null: key=".concat(string3) : new String("asset cannot be null: key="));
            }
            if (Log.isLoggable((String)"DataMap", (int)3)) {
                string = String.valueOf((Object)asset);
                Log.d((String)"DataMap", (String)new StringBuilder(33 + String.valueOf(string2).length() + String.valueOf(string).length()).append("asPutDataRequest: adding asset: ").append(string2).append(" ").append(string).toString());
            }
            this.zzbSX.putAsset(string2, asset);
        }
        return this.zzbSX;
    }
}

