/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.annotation.SuppressLint;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Binder;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.util.zzw;
import com.google.android.gms.wearable.CapabilityApi;
import com.google.android.gms.wearable.CapabilityInfo;
import com.google.android.gms.wearable.Channel;
import com.google.android.gms.wearable.ChannelApi;
import com.google.android.gms.wearable.DataApi;
import com.google.android.gms.wearable.DataEventBuffer;
import com.google.android.gms.wearable.MessageApi;
import com.google.android.gms.wearable.MessageEvent;
import com.google.android.gms.wearable.Node;
import com.google.android.gms.wearable.NodeApi;
import com.google.android.gms.wearable.internal.zzaa;
import com.google.android.gms.wearable.internal.zzai;
import com.google.android.gms.wearable.internal.zzdl;
import com.google.android.gms.wearable.internal.zzdx;
import com.google.android.gms.wearable.internal.zzeg;
import com.google.android.gms.wearable.internal.zzgh;
import com.google.android.gms.wearable.internal.zzi;
import com.google.android.gms.wearable.internal.zzl;
import com.google.android.gms.wearable.zzd;
import com.google.android.gms.wearable.zzk;
import com.google.android.gms.wearable.zzm;
import com.google.android.gms.wearable.zzn;
import com.google.android.gms.wearable.zzo;
import com.google.android.gms.wearable.zzp;
import com.google.android.gms.wearable.zzq;
import com.google.android.gms.wearable.zzr;
import com.google.android.gms.wearable.zzs;
import com.google.android.gms.wearable.zzt;
import java.util.List;

public class WearableListenerService
extends Service
implements CapabilityApi.CapabilityListener,
ChannelApi.ChannelListener,
DataApi.DataListener,
MessageApi.MessageListener,
NodeApi.NodeListener {
    public static final String BIND_LISTENER_INTENT_ACTION = "com.google.android.gms.wearable.BIND_LISTENER";
    private ComponentName zzbRo;
    private zzb zzbRp;
    private IBinder zzaHj;
    private Intent zzbRq;
    private Looper zzbRr;
    private final Object zzbRs = new Object();
    private boolean zzbRt;

    public void onCreate() {
        super.onCreate();
        this.zzbRo = new ComponentName((Context)this, this.getClass().getName());
        if (Log.isLoggable((String)"WearableLS", (int)3)) {
            String string = String.valueOf(this.zzbRo);
            Log.d((String)"WearableLS", (String)new StringBuilder(10 + String.valueOf(string).length()).append("onCreate: ").append(string).toString());
        }
        this.zzbRp = new zzb(this, this.getLooper());
        this.zzbRq = new Intent(BIND_LISTENER_INTENT_ACTION);
        this.zzbRq.setComponent(this.zzbRo);
        this.zzaHj = new zzc(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDestroy() {
        Object object;
        if (Log.isLoggable((String)"WearableLS", (int)3)) {
            object = String.valueOf(this.zzbRo);
            Log.d((String)"WearableLS", (String)new StringBuilder(11 + String.valueOf(object).length()).append("onDestroy: ").append((String)object).toString());
        }
        object = this.zzbRs;
        synchronized (object) {
            this.zzbRt = true;
            if (this.zzbRp == null) {
                String string = String.valueOf(this.zzbRo);
                throw new IllegalStateException(new StringBuilder(111 + String.valueOf(string).length()).append("onDestroy: mServiceHandler not set, did you override onCreate() but forget to call super.onCreate()? component=").append(string).toString());
            }
            this.zzbRp.quit();
        }
        super.onDestroy();
    }

    public final IBinder onBind(Intent intent) {
        if (BIND_LISTENER_INTENT_ACTION.equals(intent.getAction())) {
            return this.zzaHj;
        }
        return null;
    }

    public Looper getLooper() {
        if (this.zzbRr == null) {
            HandlerThread handlerThread = new HandlerThread("WearableListenerService");
            handlerThread.start();
            this.zzbRr = handlerThread.getLooper();
        }
        return this.zzbRr;
    }

    @Override
    public void onDataChanged(DataEventBuffer dataEventBuffer) {
    }

    @Override
    public void onMessageReceived(MessageEvent messageEvent) {
    }

    @Override
    public void onPeerConnected(Node node) {
    }

    @Override
    public void onPeerDisconnected(Node node) {
    }

    public void onConnectedNodes(List<Node> list) {
    }

    @Override
    public void onCapabilityChanged(CapabilityInfo capabilityInfo) {
    }

    @Override
    public void onChannelOpened(Channel channel) {
    }

    @Override
    public void onChannelClosed(Channel channel, int n, int n2) {
    }

    @Override
    public void onInputClosed(Channel channel, int n, int n2) {
    }

    @Override
    public void onOutputClosed(Channel channel, int n, int n2) {
    }

    public void onNotificationReceived(zzd zzd2) {
    }

    public void onEntityUpdate(com.google.android.gms.wearable.zzb zzb2) {
    }

    final class zzc
    extends zzdl {
        private volatile int zzbRw = -1;

        private zzc() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public final void zzS(DataHolder dataHolder) {
            com.google.android.gms.wearable.zzl zzl2 = new com.google.android.gms.wearable.zzl(this, dataHolder);
            try {
                String string = String.valueOf(dataHolder);
                int n = dataHolder.getCount();
                boolean bl = this.zza(zzl2, "onDataItemChanged", new StringBuilder(18 + String.valueOf(string).length()).append(string).append(", rows=").append(n).toString());
                if (bl) return;
            }
            catch (Throwable throwable) {
                dataHolder.close();
                throw throwable;
            }
            dataHolder.close();
        }

        @Override
        public final void zza(zzdx zzdx2) {
            zzm zzm2 = new zzm(this, zzdx2);
            this.zza(zzm2, "onMessageReceived", zzdx2);
        }

        @Override
        public final void zza(zzeg zzeg2) {
            zzn zzn2 = new zzn(this, zzeg2);
            this.zza(zzn2, "onPeerConnected", zzeg2);
        }

        @Override
        public final void zzb(zzeg zzeg2) {
            zzo zzo2 = new zzo(this, zzeg2);
            this.zza(zzo2, "onPeerDisconnected", zzeg2);
        }

        @Override
        public final void onConnectedNodes(List<zzeg> list) {
            zzp zzp2 = new zzp(this, list);
            this.zza(zzp2, "onConnectedNodes", list);
        }

        @Override
        public final void zza(zzaa zzaa2) {
            zzq zzq2 = new zzq(this, zzaa2);
            this.zza(zzq2, "onConnectedCapabilityChanged", zzaa2);
        }

        @Override
        public final void zza(zzl zzl2) {
            zzr zzr2 = new zzr(this, zzl2);
            this.zza(zzr2, "onNotificationReceived", (Object)zzl2);
        }

        @Override
        public final void zza(zzi zzi2) {
            zzs zzs2 = new zzs(this, zzi2);
            this.zza(zzs2, "onEntityUpdate", (Object)zzi2);
        }

        @Override
        public final void zza(zzai zzai2) {
            zzt zzt2 = new zzt(this, zzai2);
            this.zza(zzt2, "onChannelEvent", (Object)zzai2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean zza(Runnable runnable, String string, Object object) {
            boolean bl;
            if (Log.isLoggable((String)"WearableLS", (int)3)) {
                Log.d((String)"WearableLS", (String)String.format("%s: %s %s", string, WearableListenerService.this.zzbRo.toString(), object));
            }
            zzc zzc2 = this;
            int n = Binder.getCallingUid();
            if (n == zzc2.zzbRw) {
                bl = true;
            } else if (zzgh.zzbz((Context)zzc2.WearableListenerService.this).zzgm("com.google.android.wearable.app.cn") && zzw.zzb((Context)zzc2.WearableListenerService.this, (int)n, (String)"com.google.android.wearable.app.cn")) {
                zzc2.zzbRw = n;
                bl = true;
            } else if (zzw.zzf((Context)zzc2.WearableListenerService.this, (int)n)) {
                zzc2.zzbRw = n;
                bl = true;
            } else {
                Log.e((String)"WearableLS", (String)new StringBuilder(57).append("Caller is not GooglePlayServices; caller UID: ").append(n).toString());
                bl = false;
            }
            if (!bl) {
                return false;
            }
            Object object2 = WearableListenerService.this.zzbRs;
            synchronized (object2) {
                if (WearableListenerService.this.zzbRt) {
                    return false;
                }
                WearableListenerService.this.zzbRp.post(runnable);
            }
            return true;
        }

        /* synthetic */ zzc(zzk zzk2) {
            this();
        }
    }

    final class zzb
    extends Handler {
        private boolean started;
        private final zza zzbRu;
        private /* synthetic */ WearableListenerService zzbRv;

        zzb(WearableListenerService wearableListenerService, Looper looper) {
            this.zzbRv = wearableListenerService;
            super(looper);
            this.zzbRu = new zza(this.zzbRv, null);
        }

        public final void dispatchMessage(Message message) {
            this.zzDV();
            try {
                super.dispatchMessage(message);
            }
            catch (Throwable throwable) {
                if (!this.hasMessages(0)) {
                    this.zzgk("dispatch");
                }
                throw throwable;
            }
            if (!this.hasMessages(0)) {
                this.zzgk("dispatch");
                return;
            }
        }

        final void quit() {
            this.getLooper().quit();
            this.zzgk("quit");
        }

        @SuppressLint(value={"UntrackedBindService"})
        private final synchronized void zzDV() {
            if (this.started) {
                return;
            }
            if (Log.isLoggable((String)"WearableLS", (int)2)) {
                String string = String.valueOf(this.zzbRv.zzbRo);
                Log.v((String)"WearableLS", (String)new StringBuilder(13 + String.valueOf(string).length()).append("bindService: ").append(string).toString());
            }
            this.zzbRv.bindService(this.zzbRv.zzbRq, this.zzbRu, 1);
            this.started = true;
        }

        @SuppressLint(value={"UntrackedBindService"})
        private final synchronized void zzgk(String string) {
            if (!this.started) {
                return;
            }
            if (Log.isLoggable((String)"WearableLS", (int)2)) {
                String string2 = String.valueOf(this.zzbRv.zzbRo);
                Log.v((String)"WearableLS", (String)new StringBuilder(17 + String.valueOf(string).length() + String.valueOf(string2).length()).append("unbindService: ").append(string).append(", ").append(string2).toString());
            }
            try {
                this.zzbRv.unbindService(this.zzbRu);
            }
            catch (RuntimeException runtimeException) {
                Log.e((String)"WearableLS", (String)"Exception when unbinding from local service", (Throwable)runtimeException);
            }
            this.started = false;
        }
    }

    final class zza
    implements ServiceConnection {
        private zza(WearableListenerService wearableListenerService) {
        }

        public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        }

        public final void onServiceDisconnected(ComponentName componentName) {
        }

        /* synthetic */ zza(WearableListenerService wearableListenerService, zzk zzk2) {
            this(wearableListenerService);
        }
    }
}

