/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.util.Log;
import com.google.android.gms.internal.zzdeb;
import com.google.android.gms.internal.zzdec;
import com.google.android.gms.internal.zzego;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataMap;
import com.google.android.gms.wearable.DataMapItem;
import com.google.android.gms.wearable.PutDataRequest;

public class PutDataMapRequest {
    private final PutDataRequest zzkpv;
    private final DataMap zzkpu;

    private PutDataMapRequest(PutDataRequest putDataRequest, DataMap dataMap) {
        this.zzkpv = putDataRequest;
        this.zzkpu = new DataMap();
        if (dataMap != null) {
            this.zzkpu.putAll(dataMap);
        }
    }

    public static PutDataMapRequest createFromDataMapItem(DataMapItem dataMapItem) {
        return new PutDataMapRequest(PutDataRequest.zzt(dataMapItem.getUri()), dataMapItem.getDataMap());
    }

    public static PutDataMapRequest createWithAutoAppendedId(String string) {
        return new PutDataMapRequest(PutDataRequest.createWithAutoAppendedId(string), null);
    }

    public static PutDataMapRequest create(String string) {
        return new PutDataMapRequest(PutDataRequest.create(string), null);
    }

    public Uri getUri() {
        return this.zzkpv.getUri();
    }

    public DataMap getDataMap() {
        return this.zzkpu;
    }

    public PutDataMapRequest setUrgent() {
        this.zzkpv.setUrgent();
        return this;
    }

    public boolean isUrgent() {
        return this.zzkpv.isUrgent();
    }

    public PutDataRequest asPutDataRequest() {
        zzdec zzdec2 = zzdeb.zza(this.zzkpu);
        this.zzkpv.setData(zzego.zzc((zzego)zzdec2.zzkut));
        int n = zzdec2.zzkuu.size();
        for (int i = 0; i < n; ++i) {
            String string;
            String string2 = Integer.toString(i);
            Asset asset = zzdec2.zzkuu.get(i);
            if (string2 == null) {
                string = String.valueOf((Object)asset);
                throw new IllegalStateException(new StringBuilder(26 + String.valueOf(string).length()).append("asset key cannot be null: ").append(string).toString());
            }
            if (asset == null) {
                String string3 = String.valueOf(string2);
                throw new IllegalStateException(string3.length() != 0 ? "asset cannot be null: key=".concat(string3) : new String("asset cannot be null: key="));
            }
            if (Log.isLoggable((String)"DataMap", (int)3)) {
                string = String.valueOf((Object)asset);
                Log.d((String)"DataMap", (String)new StringBuilder(33 + String.valueOf(string2).length() + String.valueOf(string).length()).append("asPutDataRequest: adding asset: ").append(string2).append(" ").append(string).toString());
            }
            this.zzkpv.putAsset(string2, asset);
        }
        return this.zzkpv;
    }
}

