/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.internal.zzdlz;
import com.google.android.gms.internal.zzdma;
import com.google.android.gms.internal.zzdmb;
import com.google.android.gms.internal.zzfjr;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataItem;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.DataMap;
import java.util.ArrayList;

public class DataMapItem {
    private final Uri mUri;
    private final DataMap zzlgs;

    public static DataMapItem fromDataItem(@NonNull DataItem dataItem) {
        zzc.zzb((Object)dataItem, (Object)"dataItem must not be null");
        return new DataMapItem(dataItem);
    }

    private DataMapItem(DataItem dataItem) {
        this.mUri = dataItem.getUri();
        this.zzlgs = DataMapItem.zza((DataItem)dataItem.freeze());
    }

    public Uri getUri() {
        return this.mUri;
    }

    public DataMap getDataMap() {
        return this.zzlgs;
    }

    private static DataMap zza(DataItem dataItem) {
        if (dataItem.getData() == null && dataItem.getAssets().size() > 0) {
            throw new IllegalArgumentException("Cannot create DataMapItem from a DataItem  that wasn't made with DataMapItem.");
        }
        if (dataItem.getData() == null) {
            return new DataMap();
        }
        try {
            ArrayList<Asset> arrayList = new ArrayList<Asset>();
            int n = dataItem.getAssets().size();
            for (int i = 0; i < n; ++i) {
                DataItemAsset dataItemAsset = dataItem.getAssets().get(Integer.toString(i));
                if (dataItemAsset == null) {
                    int n2 = i;
                    String string = String.valueOf(dataItem);
                    throw new IllegalStateException(new StringBuilder(64 + String.valueOf(string).length()).append("Cannot find DataItemAsset referenced in data at ").append(n2).append(" for ").append(string).toString());
                }
                Asset asset = Asset.createFromRef(dataItemAsset.getId());
                arrayList.add(asset);
            }
            zzdmb zzdmb2 = zzdmb.zzaa(dataItem.getData());
            return zzdlz.zza(new zzdma(zzdmb2, arrayList));
        }
        catch (zzfjr | NullPointerException throwable) {
            String string = String.valueOf(dataItem.getUri());
            String string2 = Base64.encodeToString((byte[])dataItem.getData(), (int)0);
            Log.w((String)"DataItem", (String)new StringBuilder(50 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Unable to parse datamap from dataItem. uri=").append(string).append(", data=").append(string2).toString());
            string = String.valueOf(dataItem.getUri());
            throw new IllegalStateException(new StringBuilder(44 + String.valueOf(string).length()).append("Unable to parse datamap from dataItem.  uri=").append(string).toString(), throwable);
        }
    }
}

