/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.internal.zzdlz;
import com.google.android.gms.internal.zzdma;
import com.google.android.gms.internal.zzfjs;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataMap;
import com.google.android.gms.wearable.DataMapItem;
import com.google.android.gms.wearable.PutDataRequest;

public class PutDataMapRequest {
    private final PutDataRequest zzlgt;
    private final DataMap zzlgs;

    private PutDataMapRequest(PutDataRequest putDataRequest, DataMap dataMap) {
        this.zzlgt = putDataRequest;
        this.zzlgs = new DataMap();
        if (dataMap != null) {
            this.zzlgs.putAll(dataMap);
        }
    }

    public static PutDataMapRequest createFromDataMapItem(@NonNull DataMapItem dataMapItem) {
        zzc.zzb((Object)dataMapItem, (Object)"source must not be null");
        return new PutDataMapRequest(PutDataRequest.zzs(dataMapItem.getUri()), dataMapItem.getDataMap());
    }

    public static PutDataMapRequest createWithAutoAppendedId(@NonNull String string) {
        zzc.zzb((Object)string, (Object)"pathPrefix must not be null");
        return new PutDataMapRequest(PutDataRequest.createWithAutoAppendedId(string), null);
    }

    public static PutDataMapRequest create(@NonNull String string) {
        zzc.zzb((Object)string, (Object)"path must not be null");
        return new PutDataMapRequest(PutDataRequest.create(string), null);
    }

    public Uri getUri() {
        return this.zzlgt.getUri();
    }

    public DataMap getDataMap() {
        return this.zzlgs;
    }

    public PutDataMapRequest setUrgent() {
        this.zzlgt.setUrgent();
        return this;
    }

    public boolean isUrgent() {
        return this.zzlgt.isUrgent();
    }

    public PutDataRequest asPutDataRequest() {
        zzdma zzdma2 = zzdlz.zza(this.zzlgs);
        this.zzlgt.setData(zzfjs.zzc((zzfjs)zzdma2.zzlmg));
        int n = zzdma2.zzlmh.size();
        for (int i = 0; i < n; ++i) {
            String string;
            String string2 = Integer.toString(i);
            Asset asset = zzdma2.zzlmh.get(i);
            if (string2 == null) {
                string = String.valueOf((Object)asset);
                throw new IllegalStateException(new StringBuilder(26 + String.valueOf(string).length()).append("asset key cannot be null: ").append(string).toString());
            }
            if (asset == null) {
                String string3 = String.valueOf(string2);
                throw new IllegalStateException(string3.length() != 0 ? "asset cannot be null: key=".concat(string3) : new String("asset cannot be null: key="));
            }
            if (Log.isLoggable((String)"DataMap", (int)3)) {
                string = String.valueOf((Object)asset);
                Log.d((String)"DataMap", (String)new StringBuilder(33 + String.valueOf(string2).length() + String.valueOf(string).length()).append("asPutDataRequest: adding asset: ").append(string2).append(" ").append(string).toString());
            }
            this.zzlgt.putAsset(string2, asset);
        }
        return this.zzlgt;
    }
}

