/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.annotation.SuppressLint;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Binder;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.util.zzx;
import com.google.android.gms.wearable.CapabilityApi;
import com.google.android.gms.wearable.CapabilityInfo;
import com.google.android.gms.wearable.Channel;
import com.google.android.gms.wearable.ChannelApi;
import com.google.android.gms.wearable.ChannelClient;
import com.google.android.gms.wearable.DataApi;
import com.google.android.gms.wearable.DataEventBuffer;
import com.google.android.gms.wearable.MessageApi;
import com.google.android.gms.wearable.MessageEvent;
import com.google.android.gms.wearable.Node;
import com.google.android.gms.wearable.internal.zzah;
import com.google.android.gms.wearable.internal.zzas;
import com.google.android.gms.wearable.internal.zzaw;
import com.google.android.gms.wearable.internal.zzen;
import com.google.android.gms.wearable.internal.zzfe;
import com.google.android.gms.wearable.internal.zzfo;
import com.google.android.gms.wearable.internal.zzhp;
import com.google.android.gms.wearable.internal.zzi;
import com.google.android.gms.wearable.internal.zzl;
import com.google.android.gms.wearable.zzk;
import com.google.android.gms.wearable.zzm;
import com.google.android.gms.wearable.zzn;
import com.google.android.gms.wearable.zzo;
import com.google.android.gms.wearable.zzp;
import com.google.android.gms.wearable.zzq;
import com.google.android.gms.wearable.zzr;
import com.google.android.gms.wearable.zzs;
import com.google.android.gms.wearable.zzt;
import java.util.List;

public class WearableListenerService
extends Service
implements CapabilityApi.CapabilityListener,
ChannelApi.ChannelListener,
DataApi.DataListener,
MessageApi.MessageListener {
    public static final String BIND_LISTENER_INTENT_ACTION = "com.google.android.gms.wearable.BIND_LISTENER";
    private ComponentName zzlhd;
    private zzc zzlhe;
    private IBinder zzfzf;
    private Intent zzlhf;
    private Looper zzlhg;
    private final Object zzlhh = new Object();
    private boolean zzlhi;
    private zzas zzlhj = new zzas(new zza(this, null));

    public WearableListenerService() {
    }

    public void onCreate() {
        super.onCreate();
        this.zzlhd = new ComponentName((Context)this, this.getClass().getName());
        if (Log.isLoggable((String)"WearableLS", (int)3)) {
            String string = String.valueOf(this.zzlhd);
            Log.d((String)"WearableLS", (String)new StringBuilder(10 + String.valueOf(string).length()).append("onCreate: ").append(string).toString());
        }
        this.zzlhe = new zzc(this, this.getLooper());
        this.zzlhf = new Intent(BIND_LISTENER_INTENT_ACTION);
        this.zzlhf.setComponent(this.zzlhd);
        this.zzfzf = new zzd(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDestroy() {
        Object object;
        if (Log.isLoggable((String)"WearableLS", (int)3)) {
            object = String.valueOf(this.zzlhd);
            Log.d((String)"WearableLS", (String)new StringBuilder(11 + String.valueOf(object).length()).append("onDestroy: ").append((String)object).toString());
        }
        object = this.zzlhh;
        synchronized (object) {
            this.zzlhi = true;
            if (this.zzlhe == null) {
                String string = String.valueOf(this.zzlhd);
                throw new IllegalStateException(new StringBuilder(111 + String.valueOf(string).length()).append("onDestroy: mServiceHandler not set, did you override onCreate() but forget to call super.onCreate()? component=").append(string).toString());
            }
            this.zzlhe.quit();
        }
        super.onDestroy();
    }

    public final IBinder onBind(Intent intent) {
        if (BIND_LISTENER_INTENT_ACTION.equals(intent.getAction())) {
            return this.zzfzf;
        }
        return null;
    }

    public Looper getLooper() {
        if (this.zzlhg == null) {
            HandlerThread handlerThread = new HandlerThread("WearableListenerService");
            handlerThread.start();
            this.zzlhg = handlerThread.getLooper();
        }
        return this.zzlhg;
    }

    @Override
    public void onDataChanged(DataEventBuffer dataEventBuffer) {
    }

    @Override
    public void onMessageReceived(MessageEvent messageEvent) {
    }

    public void onPeerConnected(Node node) {
    }

    public void onPeerDisconnected(Node node) {
    }

    public void onConnectedNodes(List<Node> list) {
    }

    @Override
    public void onCapabilityChanged(CapabilityInfo capabilityInfo) {
    }

    @Override
    public void onChannelOpened(Channel channel) {
    }

    @Override
    public void onChannelClosed(Channel channel, int n, int n2) {
    }

    @Override
    public void onInputClosed(Channel channel, int n, int n2) {
    }

    @Override
    public void onOutputClosed(Channel channel, int n, int n2) {
    }

    public void onChannelOpened(ChannelClient.Channel channel) {
    }

    public void onChannelClosed(ChannelClient.Channel channel, int n, int n2) {
    }

    public void onInputClosed(ChannelClient.Channel channel, int n, int n2) {
    }

    public void onOutputClosed(ChannelClient.Channel channel, int n, int n2) {
    }

    public void onNotificationReceived(com.google.android.gms.wearable.zzd zzd2) {
    }

    public void onEntityUpdate(com.google.android.gms.wearable.zzb zzb2) {
    }

    static /* synthetic */ zzas zzc(WearableListenerService wearableListenerService) {
        return wearableListenerService.zzlhj;
    }

    final class zzd
    extends zzen {
        private volatile int zzlhm = -1;

        private zzd() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public final void zzas(DataHolder dataHolder) {
            com.google.android.gms.wearable.zzl zzl2 = new com.google.android.gms.wearable.zzl(this, dataHolder);
            try {
                String string = String.valueOf(dataHolder);
                int n = dataHolder.getCount();
                boolean bl = this.zza(zzl2, "onDataItemChanged", new StringBuilder(18 + String.valueOf(string).length()).append(string).append(", rows=").append(n).toString());
                if (bl) return;
            }
            catch (Throwable throwable) {
                dataHolder.close();
                throw throwable;
            }
            dataHolder.close();
        }

        @Override
        public final void zza(zzfe zzfe2) {
            zzm zzm2 = new zzm(this, zzfe2);
            this.zza(zzm2, "onMessageReceived", zzfe2);
        }

        @Override
        public final void zza(zzfo zzfo2) {
            zzn zzn2 = new zzn(this, zzfo2);
            this.zza(zzn2, "onPeerConnected", zzfo2);
        }

        @Override
        public final void zzb(zzfo zzfo2) {
            zzo zzo2 = new zzo(this, zzfo2);
            this.zza(zzo2, "onPeerDisconnected", zzfo2);
        }

        @Override
        public final void onConnectedNodes(List<zzfo> list) {
            zzp zzp2 = new zzp(this, list);
            this.zza(zzp2, "onConnectedNodes", list);
        }

        @Override
        public final void zza(zzah zzah2) {
            zzq zzq2 = new zzq(this, zzah2);
            this.zza(zzq2, "onConnectedCapabilityChanged", zzah2);
        }

        @Override
        public final void zza(zzl zzl2) {
            zzr zzr2 = new zzr(this, zzl2);
            this.zza(zzr2, "onNotificationReceived", (Object)zzl2);
        }

        @Override
        public final void zza(zzi zzi2) {
            zzs zzs2 = new zzs(this, zzi2);
            this.zza(zzs2, "onEntityUpdate", (Object)zzi2);
        }

        @Override
        public final void zza(zzaw zzaw2) {
            zzt zzt2 = new zzt(this, zzaw2);
            this.zza(zzt2, "onChannelEvent", (Object)zzaw2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean zza(Runnable runnable, String string, Object object) {
            boolean bl;
            if (Log.isLoggable((String)"WearableLS", (int)3)) {
                Log.d((String)"WearableLS", (String)String.format("%s: %s %s", string, WearableListenerService.this.zzlhd.toString(), object));
            }
            zzd zzd2 = this;
            int n = Binder.getCallingUid();
            if (n == zzd2.zzlhm) {
                bl = true;
            } else if (zzhp.zzep((Context)zzd2.WearableListenerService.this).zznz("com.google.android.wearable.app.cn") && zzx.zzb((Context)zzd2.WearableListenerService.this, (int)n, (String)"com.google.android.wearable.app.cn")) {
                zzd2.zzlhm = n;
                bl = true;
            } else if (zzx.zzf((Context)zzd2.WearableListenerService.this, (int)n)) {
                zzd2.zzlhm = n;
                bl = true;
            } else {
                Log.e((String)"WearableLS", (String)new StringBuilder(57).append("Caller is not GooglePlayServices; caller UID: ").append(n).toString());
                bl = false;
            }
            if (!bl) {
                return false;
            }
            Object object2 = WearableListenerService.this.zzlhh;
            synchronized (object2) {
                if (WearableListenerService.this.zzlhi) {
                    return false;
                }
                WearableListenerService.this.zzlhe.post(runnable);
            }
            return true;
        }

        /* synthetic */ zzd(zzk zzk2) {
            this();
        }
    }

    final class zzc
    extends Handler {
        private boolean started;
        private final zzb zzlhl;
        private /* synthetic */ WearableListenerService zzlhk;

        zzc(WearableListenerService wearableListenerService, Looper looper) {
            this.zzlhk = wearableListenerService;
            super(looper);
            this.zzlhl = new zzb(this.zzlhk, null);
        }

        public final void dispatchMessage(Message message) {
            this.zzbke();
            try {
                super.dispatchMessage(message);
            }
            catch (Throwable throwable) {
                if (!this.hasMessages(0)) {
                    this.zznx("dispatch");
                }
                throw throwable;
            }
            if (!this.hasMessages(0)) {
                this.zznx("dispatch");
                return;
            }
        }

        final void quit() {
            this.getLooper().quit();
            this.zznx("quit");
        }

        @SuppressLint(value={"UntrackedBindService"})
        private final synchronized void zzbke() {
            if (this.started) {
                return;
            }
            if (Log.isLoggable((String)"WearableLS", (int)2)) {
                String string = String.valueOf(this.zzlhk.zzlhd);
                Log.v((String)"WearableLS", (String)new StringBuilder(13 + String.valueOf(string).length()).append("bindService: ").append(string).toString());
            }
            this.zzlhk.bindService(this.zzlhk.zzlhf, this.zzlhl, 1);
            this.started = true;
        }

        @SuppressLint(value={"UntrackedBindService"})
        private final synchronized void zznx(String string) {
            if (!this.started) {
                return;
            }
            if (Log.isLoggable((String)"WearableLS", (int)2)) {
                String string2 = String.valueOf(this.zzlhk.zzlhd);
                Log.v((String)"WearableLS", (String)new StringBuilder(17 + String.valueOf(string).length() + String.valueOf(string2).length()).append("unbindService: ").append(string).append(", ").append(string2).toString());
            }
            try {
                this.zzlhk.unbindService(this.zzlhl);
            }
            catch (RuntimeException runtimeException) {
                Log.e((String)"WearableLS", (String)"Exception when unbinding from local service", (Throwable)runtimeException);
            }
            this.started = false;
        }
    }

    final class zzb
    implements ServiceConnection {
        private zzb(WearableListenerService wearableListenerService) {
        }

        public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        }

        public final void onServiceDisconnected(ComponentName componentName) {
        }

        /* synthetic */ zzb(WearableListenerService wearableListenerService, zzk zzk2) {
            this(wearableListenerService);
        }
    }

    final class zza
    extends ChannelClient.ChannelCallback {
        private /* synthetic */ WearableListenerService zzlhk;

        private zza(WearableListenerService wearableListenerService) {
            this.zzlhk = wearableListenerService;
        }

        @Override
        public final void onChannelOpened(@NonNull ChannelClient.Channel channel) {
            this.zzlhk.onChannelOpened(channel);
        }

        @Override
        public final void onChannelClosed(@NonNull ChannelClient.Channel channel, int n, int n2) {
            this.zzlhk.onChannelClosed(channel, n, n2);
        }

        @Override
        public final void onInputClosed(@NonNull ChannelClient.Channel channel, int n, int n2) {
            this.zzlhk.onInputClosed(channel, n, n2);
        }

        @Override
        public final void onOutputClosed(@NonNull ChannelClient.Channel channel, int n, int n2) {
            this.zzlhk.onOutputClosed(channel, n, n2);
        }

        /* synthetic */ zza(WearableListenerService wearableListenerService, zzk zzk2) {
            this(wearableListenerService);
        }
    }
}

