/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.wearable.Wearable;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public abstract class ChannelClient
extends GoogleApi<Wearable.WearableOptions> {
    public static final String ACTION_CHANNEL_EVENT = "com.google.android.gms.wearable.CHANNEL_EVENT";

    @Hide
    public ChannelClient(@NonNull Context context, @NonNull GoogleApi.zza zza2) {
        super(context, Wearable.API, null, zza2);
    }

    @Hide
    public ChannelClient(@NonNull Activity activity, @NonNull GoogleApi.zza zza2) {
        super(activity, Wearable.API, null, zza2);
    }

    public abstract Task<Channel> openChannel(@NonNull String var1, @NonNull String var2);

    public abstract Task<Void> registerChannelCallback(@NonNull ChannelCallback var1);

    public abstract Task<Boolean> unregisterChannelCallback(@NonNull ChannelCallback var1);

    public abstract Task<Void> close(@NonNull Channel var1);

    public abstract Task<Void> close(@NonNull Channel var1, int var2);

    public abstract Task<InputStream> getInputStream(@NonNull Channel var1);

    public abstract Task<OutputStream> getOutputStream(@NonNull Channel var1);

    public abstract Task<Void> receiveFile(@NonNull Channel var1, @NonNull Uri var2, boolean var3);

    public abstract Task<Void> sendFile(@NonNull Channel var1, @NonNull Uri var2);

    public abstract Task<Void> sendFile(@NonNull Channel var1, @NonNull Uri var2, long var3, long var5);

    public abstract Task<Void> registerChannelCallback(@NonNull Channel var1, @NonNull ChannelCallback var2);

    public abstract Task<Boolean> unregisterChannelCallback(@NonNull Channel var1, @NonNull ChannelCallback var2);

    public static interface Channel
    extends Parcelable {
        public String getNodeId();

        public String getPath();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CloseReason {
    }

    public static abstract class ChannelCallback {
        public static final int CLOSE_REASON_NORMAL = 0;
        public static final int CLOSE_REASON_DISCONNECTED = 1;
        public static final int CLOSE_REASON_REMOTE_CLOSE = 2;
        public static final int CLOSE_REASON_LOCAL_CLOSE = 3;

        public ChannelCallback() {
        }

        public void onChannelOpened(@NonNull Channel channel) {
        }

        public void onChannelClosed(@NonNull Channel channel, int n, int n2) {
        }

        public void onInputClosed(@NonNull Channel channel, int n, int n2) {
        }

        public void onOutputClosed(@NonNull Channel channel, int n, int n2) {
        }
    }
}

