/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.annotation.SuppressLint;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Binder;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.util.zzz;
import com.google.android.gms.wearable.CapabilityApi;
import com.google.android.gms.wearable.CapabilityInfo;
import com.google.android.gms.wearable.Channel;
import com.google.android.gms.wearable.ChannelApi;
import com.google.android.gms.wearable.ChannelClient;
import com.google.android.gms.wearable.DataApi;
import com.google.android.gms.wearable.DataEventBuffer;
import com.google.android.gms.wearable.MessageApi;
import com.google.android.gms.wearable.MessageEvent;
import com.google.android.gms.wearable.Node;
import com.google.android.gms.wearable.internal.zzah;
import com.google.android.gms.wearable.internal.zzas;
import com.google.android.gms.wearable.internal.zzaw;
import com.google.android.gms.wearable.internal.zzen;
import com.google.android.gms.wearable.internal.zzfe;
import com.google.android.gms.wearable.internal.zzfo;
import com.google.android.gms.wearable.internal.zzhp;
import com.google.android.gms.wearable.internal.zzi;
import com.google.android.gms.wearable.internal.zzl;
import com.google.android.gms.wearable.zzk;
import com.google.android.gms.wearable.zzm;
import com.google.android.gms.wearable.zzn;
import com.google.android.gms.wearable.zzo;
import com.google.android.gms.wearable.zzp;
import com.google.android.gms.wearable.zzq;
import com.google.android.gms.wearable.zzr;
import com.google.android.gms.wearable.zzs;
import com.google.android.gms.wearable.zzt;
import java.util.List;

public class WearableListenerService
extends Service
implements CapabilityApi.CapabilityListener,
ChannelApi.ChannelListener,
DataApi.DataListener,
MessageApi.MessageListener {
    @Hide
    public static final String BIND_LISTENER_INTENT_ACTION = "com.google.android.gms.wearable.BIND_LISTENER";
    private ComponentName zza;
    private zzc zzb;
    private IBinder zzc;
    private Intent zzd;
    private Looper zze;
    private final Object zzf = new Object();
    private boolean zzg;
    private zzas zzh = new zzas(new zza(this, null));

    public WearableListenerService() {
    }

    public void onCreate() {
        super.onCreate();
        this.zza = new ComponentName((Context)this, this.getClass().getName());
        if (Log.isLoggable((String)"WearableLS", (int)3)) {
            String string = String.valueOf(this.zza);
            Log.d((String)"WearableLS", (String)new StringBuilder(10 + String.valueOf(string).length()).append("onCreate: ").append(string).toString());
        }
        this.zzb = new zzc(this, this.getLooper());
        this.zzd = new Intent(BIND_LISTENER_INTENT_ACTION);
        this.zzd.setComponent(this.zza);
        this.zzc = new zzd(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDestroy() {
        Object object;
        if (Log.isLoggable((String)"WearableLS", (int)3)) {
            object = String.valueOf(this.zza);
            Log.d((String)"WearableLS", (String)new StringBuilder(11 + String.valueOf(object).length()).append("onDestroy: ").append((String)object).toString());
        }
        object = this.zzf;
        synchronized (object) {
            this.zzg = true;
            if (this.zzb == null) {
                String string = String.valueOf(this.zza);
                throw new IllegalStateException(new StringBuilder(111 + String.valueOf(string).length()).append("onDestroy: mServiceHandler not set, did you override onCreate() but forget to call super.onCreate()? component=").append(string).toString());
            }
            this.zzb.zza();
        }
        super.onDestroy();
    }

    public final IBinder onBind(Intent intent) {
        if (BIND_LISTENER_INTENT_ACTION.equals(intent.getAction())) {
            return this.zzc;
        }
        return null;
    }

    public Looper getLooper() {
        if (this.zze == null) {
            HandlerThread handlerThread = new HandlerThread("WearableListenerService");
            handlerThread.start();
            this.zze = handlerThread.getLooper();
        }
        return this.zze;
    }

    @Override
    public void onDataChanged(DataEventBuffer dataEventBuffer) {
    }

    @Override
    public void onMessageReceived(MessageEvent messageEvent) {
    }

    public void onPeerConnected(Node node) {
    }

    public void onPeerDisconnected(Node node) {
    }

    public void onConnectedNodes(List<Node> list) {
    }

    @Override
    public void onCapabilityChanged(CapabilityInfo capabilityInfo) {
    }

    @Override
    public void onChannelOpened(Channel channel) {
    }

    @Override
    public void onChannelClosed(Channel channel, int n, int n2) {
    }

    @Override
    public void onInputClosed(Channel channel, int n, int n2) {
    }

    @Override
    public void onOutputClosed(Channel channel, int n, int n2) {
    }

    public void onChannelOpened(ChannelClient.Channel channel) {
    }

    public void onChannelClosed(ChannelClient.Channel channel, int n, int n2) {
    }

    public void onInputClosed(ChannelClient.Channel channel, int n, int n2) {
    }

    public void onOutputClosed(ChannelClient.Channel channel, int n, int n2) {
    }

    @Hide
    public void onNotificationReceived(com.google.android.gms.wearable.zzd zzd2) {
    }

    @Hide
    public void onEntityUpdate(com.google.android.gms.wearable.zzb zzb2) {
    }

    static /* synthetic */ zzas zzc(WearableListenerService wearableListenerService) {
        return wearableListenerService.zzh;
    }

    final class zzd
    extends zzen {
        private volatile int zzb = -1;

        private zzd() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public final void zza(DataHolder dataHolder) {
            com.google.android.gms.wearable.zzl zzl2 = new com.google.android.gms.wearable.zzl(this, dataHolder);
            try {
                String string = String.valueOf(dataHolder);
                int n = dataHolder.zzd();
                boolean bl = this.zza(zzl2, "onDataItemChanged", new StringBuilder(18 + String.valueOf(string).length()).append(string).append(", rows=").append(n).toString());
                if (bl) return;
            }
            catch (Throwable throwable) {
                dataHolder.close();
                throw throwable;
            }
            dataHolder.close();
        }

        @Override
        public final void zza(zzfe zzfe2) {
            zzm zzm2 = new zzm(this, zzfe2);
            this.zza(zzm2, "onMessageReceived", zzfe2);
        }

        @Override
        public final void zza(zzfo zzfo2) {
            zzn zzn2 = new zzn(this, zzfo2);
            this.zza(zzn2, "onPeerConnected", zzfo2);
        }

        @Override
        public final void zzb(zzfo zzfo2) {
            zzo zzo2 = new zzo(this, zzfo2);
            this.zza(zzo2, "onPeerDisconnected", zzfo2);
        }

        @Override
        public final void zza(List<zzfo> list) {
            zzp zzp2 = new zzp(this, list);
            this.zza(zzp2, "onConnectedNodes", list);
        }

        @Override
        public final void zza(zzah zzah2) {
            zzq zzq2 = new zzq(this, zzah2);
            this.zza(zzq2, "onConnectedCapabilityChanged", zzah2);
        }

        @Override
        public final void zza(zzl zzl2) {
            zzr zzr2 = new zzr(this, zzl2);
            this.zza(zzr2, "onNotificationReceived", (Object)zzl2);
        }

        @Override
        public final void zza(zzi zzi2) {
            zzs zzs2 = new zzs(this, zzi2);
            this.zza(zzs2, "onEntityUpdate", (Object)zzi2);
        }

        @Override
        public final void zza(zzaw zzaw2) {
            zzt zzt2 = new zzt(this, zzaw2);
            this.zza(zzt2, "onChannelEvent", (Object)zzaw2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean zza(Runnable runnable, String string, Object object) {
            boolean bl;
            if (Log.isLoggable((String)"WearableLS", (int)3)) {
                Log.d((String)"WearableLS", (String)String.format("%s: %s %s", string, WearableListenerService.this.zza.toString(), object));
            }
            zzd zzd2 = this;
            int n = Binder.getCallingUid();
            if (n == zzd2.zzb) {
                bl = true;
            } else if (zzhp.zza((Context)zzd2.WearableListenerService.this).zza("com.google.android.wearable.app.cn") && zzz.zza((Context)zzd2.WearableListenerService.this, (int)n, (String)"com.google.android.wearable.app.cn")) {
                zzd2.zzb = n;
                bl = true;
            } else if (zzz.zza((Context)zzd2.WearableListenerService.this, (int)n)) {
                zzd2.zzb = n;
                bl = true;
            } else {
                Log.e((String)"WearableLS", (String)new StringBuilder(57).append("Caller is not GooglePlayServices; caller UID: ").append(n).toString());
                bl = false;
            }
            if (!bl) {
                return false;
            }
            Object object2 = WearableListenerService.this.zzf;
            synchronized (object2) {
                if (WearableListenerService.this.zzg) {
                    return false;
                }
                WearableListenerService.this.zzb.post(runnable);
            }
            return true;
        }

        /* synthetic */ zzd(zzk zzk2) {
            this();
        }
    }

    final class zzc
    extends Handler {
        private boolean zza;
        private final zzb zzb;
        private /* synthetic */ WearableListenerService zzc;

        zzc(WearableListenerService wearableListenerService, Looper looper) {
            this.zzc = wearableListenerService;
            super(looper);
            this.zzb = new zzb(this.zzc, null);
        }

        public final void dispatchMessage(Message message) {
            this.zzb();
            try {
                super.dispatchMessage(message);
            }
            catch (Throwable throwable) {
                if (!this.hasMessages(0)) {
                    this.zza("dispatch");
                }
                throw throwable;
            }
            if (!this.hasMessages(0)) {
                this.zza("dispatch");
                return;
            }
        }

        final void zza() {
            this.getLooper().quit();
            this.zza("quit");
        }

        @SuppressLint(value={"UntrackedBindService"})
        private final synchronized void zzb() {
            if (this.zza) {
                return;
            }
            if (Log.isLoggable((String)"WearableLS", (int)2)) {
                String string = String.valueOf(this.zzc.zza);
                Log.v((String)"WearableLS", (String)new StringBuilder(13 + String.valueOf(string).length()).append("bindService: ").append(string).toString());
            }
            this.zzc.bindService(this.zzc.zzd, this.zzb, 1);
            this.zza = true;
        }

        @SuppressLint(value={"UntrackedBindService"})
        private final synchronized void zza(String string) {
            if (!this.zza) {
                return;
            }
            if (Log.isLoggable((String)"WearableLS", (int)2)) {
                String string2 = String.valueOf(this.zzc.zza);
                Log.v((String)"WearableLS", (String)new StringBuilder(17 + String.valueOf(string).length() + String.valueOf(string2).length()).append("unbindService: ").append(string).append(", ").append(string2).toString());
            }
            try {
                this.zzc.unbindService(this.zzb);
            }
            catch (RuntimeException runtimeException) {
                Log.e((String)"WearableLS", (String)"Exception when unbinding from local service", (Throwable)runtimeException);
            }
            this.zza = false;
        }
    }

    final class zzb
    implements ServiceConnection {
        private zzb(WearableListenerService wearableListenerService) {
        }

        public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        }

        public final void onServiceDisconnected(ComponentName componentName) {
        }

        /* synthetic */ zzb(WearableListenerService wearableListenerService, zzk zzk2) {
            this(wearableListenerService);
        }
    }

    final class zza
    extends ChannelClient.ChannelCallback {
        private /* synthetic */ WearableListenerService zza;

        private zza(WearableListenerService wearableListenerService) {
            this.zza = wearableListenerService;
        }

        @Override
        public final void onChannelOpened(@NonNull ChannelClient.Channel channel) {
            this.zza.onChannelOpened(channel);
        }

        @Override
        public final void onChannelClosed(@NonNull ChannelClient.Channel channel, int n, int n2) {
            this.zza.onChannelClosed(channel, n, n2);
        }

        @Override
        public final void onInputClosed(@NonNull ChannelClient.Channel channel, int n, int n2) {
            this.zza.onInputClosed(channel, n, n2);
        }

        @Override
        public final void onOutputClosed(@NonNull ChannelClient.Channel channel, int n, int n2) {
            this.zza.onOutputClosed(channel, n, n2);
        }

        /* synthetic */ zza(WearableListenerService wearableListenerService, zzk zzk2) {
            this(wearableListenerService);
        }
    }
}

