/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.support.annotation.NonNull;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.wearable.CapabilityApi;
import com.google.android.gms.wearable.CapabilityInfo;
import com.google.android.gms.wearable.Wearable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;

public abstract class CapabilityClient
extends GoogleApi<Wearable.WearableOptions> {
    public static final String ACTION_CAPABILITY_CHANGED = "com.google.android.gms.wearable.CAPABILITY_CHANGED";
    public static final int FILTER_ALL = 0;
    public static final int FILTER_REACHABLE = 1;
    public static final int FILTER_LITERAL = 0;
    public static final int FILTER_PREFIX = 1;

    public CapabilityClient(@NonNull Context context, @NonNull GoogleApi.Settings settings) {
        super(context, Wearable.API, null, settings);
    }

    public CapabilityClient(@NonNull Activity activity, @NonNull GoogleApi.Settings settings) {
        super(activity, Wearable.API, null, settings);
    }

    public abstract Task<CapabilityInfo> getCapability(@NonNull String var1, int var2);

    public abstract Task<Map<String, CapabilityInfo>> getAllCapabilities(int var1);

    public abstract Task<Void> addLocalCapability(@NonNull String var1);

    public abstract Task<Void> removeLocalCapability(@NonNull String var1);

    public abstract Task<Void> addListener(@NonNull OnCapabilityChangedListener var1, @NonNull String var2);

    public abstract Task<Boolean> removeListener(@NonNull OnCapabilityChangedListener var1, @NonNull String var2);

    public abstract Task<Void> addListener(@NonNull OnCapabilityChangedListener var1, @NonNull Uri var2, int var3);

    public abstract Task<Boolean> removeListener(@NonNull OnCapabilityChangedListener var1);

    public static interface OnCapabilityChangedListener
    extends CapabilityApi.CapabilityListener {
        @Override
        public void onCapabilityChanged(@NonNull CapabilityInfo var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CapabilityFilterType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NodeFilterType {
    }
}

