/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.internal.Asserts;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.wearable.zze;
import com.google.android.gms.internal.wearable.zzf;
import com.google.android.gms.internal.wearable.zzt;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataMap;
import com.google.android.gms.wearable.DataMapItem;
import com.google.android.gms.wearable.PutDataRequest;

@VisibleForTesting
public class PutDataMapRequest {
    private final PutDataRequest zzs;
    private final DataMap zzr;

    private PutDataMapRequest(PutDataRequest putDataRequest, DataMap dataMap) {
        this.zzs = putDataRequest;
        this.zzr = new DataMap();
        if (dataMap != null) {
            this.zzr.putAll(dataMap);
        }
    }

    public static PutDataMapRequest createFromDataMapItem(@NonNull DataMapItem dataMapItem) {
        Asserts.checkNotNull((Object)dataMapItem, (Object)"source must not be null");
        return new PutDataMapRequest(PutDataRequest.zza(dataMapItem.getUri()), dataMapItem.getDataMap());
    }

    public static PutDataMapRequest createWithAutoAppendedId(@NonNull String string) {
        Asserts.checkNotNull((Object)string, (Object)"pathPrefix must not be null");
        return new PutDataMapRequest(PutDataRequest.createWithAutoAppendedId(string), null);
    }

    public static PutDataMapRequest create(@NonNull String string) {
        Asserts.checkNotNull((Object)string, (Object)"path must not be null");
        return new PutDataMapRequest(PutDataRequest.create(string), null);
    }

    public Uri getUri() {
        return this.zzs.getUri();
    }

    public DataMap getDataMap() {
        return this.zzr;
    }

    public PutDataMapRequest setUrgent() {
        this.zzs.setUrgent();
        return this;
    }

    public boolean isUrgent() {
        return this.zzs.isUrgent();
    }

    public PutDataRequest asPutDataRequest() {
        zzf zzf2 = zze.zza(this.zzr);
        this.zzs.setData(zzt.zzb(zzf2.zzfw));
        int n = zzf2.zzfx.size();
        for (int i = 0; i < n; ++i) {
            String string;
            String string2 = Integer.toString(i);
            Asset asset = zzf2.zzfx.get(i);
            if (string2 == null) {
                string = String.valueOf((Object)asset);
                throw new IllegalStateException(new StringBuilder(26 + String.valueOf(string).length()).append("asset key cannot be null: ").append(string).toString());
            }
            if (asset == null) {
                String string3 = String.valueOf(string2);
                throw new IllegalStateException(string3.length() != 0 ? "asset cannot be null: key=".concat(string3) : new String("asset cannot be null: key="));
            }
            if (Log.isLoggable((String)"DataMap", (int)3)) {
                string = String.valueOf((Object)asset);
                Log.d((String)"DataMap", (String)new StringBuilder(33 + String.valueOf(string2).length() + String.valueOf(string).length()).append("asPutDataRequest: adding asset: ").append(string2).append(" ").append(string).toString());
            }
            this.zzs.putAsset(string2, asset);
        }
        return this.zzs;
    }
}

